/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.exceptions.VariableNotExistException;
import org.eclipse.embedcdt.core.liqp.nodes.LNode;

class LookupNode
implements LNode {
    private final String id;
    private final List<Indexable> indexes;

    public LookupNode(String id) {
        this.id = id;
        this.indexes = new ArrayList<Indexable>();
    }

    public void add(Indexable indexable) {
        this.indexes.add(indexable);
    }

    @Override
    public Object render(TemplateContext context) {
        Object value = this.id.startsWith("@") ? context.get(String.valueOf(context.get(this.id.substring(1)))) : context.get(this.id);
        for (Indexable index : this.indexes) {
            value = index.get(value, context);
        }
        if (value == null && context.renderSettings.strictVariables) {
            throw new VariableNotExistException(this.getVariableName());
        }
        return value;
    }

    private String getVariableName() {
        StringBuilder variableFullName = new StringBuilder(this.id);
        for (Indexable index : this.indexes) {
            variableFullName.append(index.toString());
        }
        return variableFullName.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        for (Indexable index : this.indexes) {
            builder.append(index.toString());
        }
        return builder.toString();
    }

    public static class Hash
    implements Indexable {
        private final String hash;

        public Hash(String hash) {
            this.hash = hash;
        }

        @Override
        public Object get(Object value, TemplateContext context) {
            if (value == null) {
                return null;
            }
            if (this.hash.equals("size")) {
                if (value instanceof Collection) {
                    return ((Collection)value).size();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    return map.containsKey(this.hash) ? map.get(this.hash) : Integer.valueOf(map.size());
                }
                if (value.getClass().isArray()) {
                    return ((Object[])value).length;
                }
                if (value instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)value;
                    return charSequence.length();
                }
            } else if (this.hash.equals("first")) {
                if (value instanceof List) {
                    List list = (List)value;
                    return list.isEmpty() ? null : list.get(0);
                }
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    return array.length == 0 ? null : array[0];
                }
            } else if (this.hash.equals("last")) {
                if (value instanceof List) {
                    List list = (List)value;
                    return list.isEmpty() ? null : list.get(list.size() - 1);
                }
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    return array.length == 0 ? null : array[array.length - 1];
                }
            }
            if (value instanceof Map) {
                return ((Map)value).get(this.hash);
            }
            if (value instanceof TemplateContext) {
                return ((TemplateContext)value).get(this.hash);
            }
            return null;
        }

        public String toString() {
            return String.format(".%s", this.hash);
        }
    }

    public static class Index
    implements Indexable {
        private final LNode expression;
        private Object key = null;

        public Index(LNode expression) {
            this.expression = expression;
        }

        @Override
        public Object get(Object value, TemplateContext context) {
            if (value == null) {
                return null;
            }
            this.key = this.expression.render(context);
            if (this.key instanceof Number) {
                int index = ((Number)this.key).intValue();
                if (value.getClass().isArray()) {
                    return ((Object[])value)[index];
                }
                if (value instanceof List) {
                    return ((List)value).get(index);
                }
                return null;
            }
            if (value.getClass().isArray() || value instanceof List) {
                return null;
            }
            String hash = String.valueOf(this.key);
            return new Hash(hash).get(value, context);
        }

        public String toString() {
            return String.format("[%s]", this.key);
        }
    }

    static interface Indexable {
        public Object get(Object var1, TemplateContext var2);
    }
}

