/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingResults;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.utilities.Visitor;

public class QvtResolveUtil {
    private QvtResolveUtil() {
    }

    public static boolean hasDeferredRightSideValue(AssignExp assignExp) {
        if (assignExp.getValue().isEmpty()) {
            return false;
        }
        OCLExpression rightValue = (OCLExpression)assignExp.getValue().get(0);
        if (rightValue instanceof ResolveExp && ((ResolveExp)rightValue).isIsDeferred()) {
            return true;
        }
        if (rightValue instanceof OperationCallExp) {
            OperationCallExp operCall = (OperationCallExp)rightValue;
            return QvtResolveUtil.isLateResolveResultConversion(operCall);
        }
        return false;
    }

    public static boolean isSuppportedAsDeferredAssigned(ResolveExp resolveExp) {
        return QvtResolveUtil.getDeferredAssignmentFor(resolveExp) != null;
    }

    public static AssignExp getDeferredAssignmentFor(ResolveExp resolveExp) {
        if (!resolveExp.isIsDeferred()) {
            return null;
        }
        EObject resolveContainer = resolveExp.eContainer();
        if (resolveContainer instanceof AssignExp) {
            AssignExp assignExp = (AssignExp)resolveContainer;
            if (assignExp.getLeft() instanceof PropertyCallExp) {
                return assignExp;
            }
        } else if (resolveContainer instanceof OperationCallExp) {
            OperationCallExp operCall = (OperationCallExp)resolveContainer;
            if (!QvtResolveUtil.isLateResolveResultConversion(operCall)) {
                return null;
            }
            EObject parent = operCall.eContainer();
            while (parent != null) {
                AssignExp assignExp;
                if (parent instanceof AssignExp && (assignExp = (AssignExp)parent).getValue().indexOf((Object)operCall) >= 0) {
                    return assignExp;
                }
                parent = parent.eContainer();
            }
        }
        return null;
    }

    private static boolean isLateResolveResultConversion(OperationCallExp operCall) {
        if (operCall.getSource() instanceof ResolveExp) {
            ResolveExp resolveExp = (ResolveExp)operCall.getSource();
            if (!resolveExp.isIsDeferred()) {
                return false;
            }
            return QvtResolveUtil.isCollectionConversionCall(operCall) && resolveExp.getType() instanceof CollectionType;
        }
        return false;
    }

    private static boolean isCollectionConversionCall(OperationCallExp operCall) {
        switch (operCall.getOperationCode()) {
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return true;
            }
        }
        return false;
    }

    private static Object coerceResultValue(ResolveExp resolveExp, Object resolveRawResult) {
        OperationCallExp opCallExp;
        if (resolveRawResult == null) {
            resolveRawResult = QvtResolveUtil.createEmptyCollectionOrNull(resolveExp);
        }
        if (resolveExp.isIsDeferred() && resolveExp.eContainer() instanceof OperationCallExp && (opCallExp = (OperationCallExp)resolveExp.eContainer()).getSource() == resolveExp) {
            List<Object> resultCollection = resolveRawResult instanceof Collection ? (List<Object>)resolveRawResult : Collections.singletonList(resolveRawResult);
            switch (opCallExp.getOperationCode()) {
                case 152: {
                    return CollectionUtil.asSet(resultCollection);
                }
                case 149: {
                    return CollectionUtil.asBag(resultCollection);
                }
                case 150: {
                    return CollectionUtil.asOrderedSet(resultCollection);
                }
                case 151: {
                    return CollectionUtil.asSequence(resultCollection);
                }
            }
        }
        return resolveRawResult;
    }

    public static final Object resolveNow(ResolveExp resolveExp, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env) {
        return QvtResolveUtil.resolveNow(resolveExp, visitor, env, null);
    }

    public static final Object resolveInNow(ResolveInExp resolveInExp, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env) {
        return QvtResolveUtil.resolveInNow(resolveInExp, visitor, env, null);
    }

    static final Object resolveNow(ResolveExp resolveExp, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env, SavedSourceObjectHolder savedSrcObj) {
        InternalEvaluationEnv internEnv = env.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        EMap<Object, EList<TraceRecord>> map = QvtResolveUtil.chooseKeyToTraceRecordMap(resolveExp, trace);
        OCLExpression source = resolveExp.getSource();
        Object sourceEval = savedSrcObj == null ? (source == null ? null : source.accept((Visitor)visitor)) : savedSrcObj.getSourceObj();
        EClassifier sourceType = source == null ? null : (EClassifier)source.getType();
        List<TraceRecord> traceRecords = QvtResolveUtil.lookupTraceRecordsBySource(sourceEval, sourceType, map);
        if (traceRecords == null) {
            return QvtResolveUtil.createEmptyCollectionOrNull(resolveExp);
        }
        Object result = QvtResolveUtil.searchByTypeAndCondition(resolveExp, traceRecords, visitor, env);
        if (savedSrcObj != null && savedSrcObj.isInDeferredExecution() && resolveExp.isIsDeferred()) {
            result = QvtResolveUtil.coerceResultValue(resolveExp, result);
        }
        return result;
    }

    static final Object resolveInNow(ResolveInExp resolveInExp, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env, SavedSourceObjectHolder savedSrcObj) {
        InternalEvaluationEnv internEnv = env.getAdapter(InternalEvaluationEnv.class);
        OCLExpression source = resolveInExp.getSource();
        ArrayList<TraceRecord> selectedTraceRecords = new ArrayList<TraceRecord>();
        Trace trace = internEnv.getTraces();
        if (source == null) {
            EList inMappingTraceRecords;
            ArrayList traceRecords = new ArrayList();
            MappingOperation inMapping = resolveInExp.getInMapping();
            ImperativeOperation overridingOper = EvaluationUtil.getOverridingOperation(env, inMapping);
            if (overridingOper instanceof MappingOperation) {
                inMapping = (MappingOperation)overridingOper;
            }
            if ((inMappingTraceRecords = (EList)trace.getTraceRecordMap().get((Object)inMapping)) != null) {
                traceRecords.addAll(inMappingTraceRecords);
            }
            if (traceRecords.isEmpty()) {
                return QvtResolveUtil.createEmptyCollectionOrNull(resolveInExp);
            }
            selectedTraceRecords.addAll(traceRecords);
        } else {
            EMap<Object, EList<TraceRecord>> map = QvtResolveUtil.chooseKeyToTraceRecordMap(resolveInExp, trace);
            Object sourceEval = savedSrcObj == null ? source.accept((Visitor)visitor) : savedSrcObj.getSourceObj();
            List<TraceRecord> traceRecords = QvtResolveUtil.lookupTraceRecordsBySource(sourceEval, (EClassifier)source.getType(), map);
            if (traceRecords.isEmpty()) {
                return QvtResolveUtil.createEmptyCollectionOrNull(resolveInExp);
            }
            for (TraceRecord traceRecord : traceRecords) {
                MappingOperation inMapping = resolveInExp.getInMapping();
                ImperativeOperation overridingOper = EvaluationUtil.getOverridingOperation(env, inMapping);
                if (overridingOper instanceof MappingOperation) {
                    inMapping = (MappingOperation)overridingOper;
                }
                if (!traceRecord.getMappingOperation().getRuntimeMappingOperation().equals(inMapping)) continue;
                selectedTraceRecords.add(traceRecord);
            }
        }
        Object result = QvtResolveUtil.searchByTypeAndCondition(resolveInExp, selectedTraceRecords, visitor, env);
        if (savedSrcObj != null && savedSrcObj.isInDeferredExecution() && resolveInExp.isIsDeferred()) {
            result = QvtResolveUtil.coerceResultValue(resolveInExp, result);
        }
        return result;
    }

    private static List<TraceRecord> lookupTraceRecordsBySource(Object source, EClassifier declaredSourceType, EMap<Object, EList<TraceRecord>> source2RecordMap) {
        List result = null;
        if (declaredSourceType == null) {
            for (EList rec : source2RecordMap.values()) {
                if (result == null) {
                    result = new BasicEList();
                }
                result.addAll(rec);
            }
        } else if (declaredSourceType instanceof CollectionType && source instanceof Collection) {
            Collection srcCol = (Collection)source;
            for (Object nextSrc : srcCol) {
                EList nextPart = (EList)source2RecordMap.get(nextSrc);
                if (nextPart == null) continue;
                if (result == null) {
                    result = new BasicEList();
                }
                result.addAll(nextPart);
            }
        } else {
            result = (List)source2RecordMap.get(source);
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    private static Object searchByTypeAndCondition(ResolveExp resolveExp, List<TraceRecord> traceRecords, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env) {
        if (resolveExp.isOne()) {
            for (TraceRecord traceRecord : traceRecords) {
                EMappingResults results = traceRecord.getResult();
                if (resolveExp.isIsInverse()) {
                    Object target;
                    if (traceRecord.getContext().getContext() == null || !QvtResolveUtil.checkTypeAndCondition(resolveExp, target = traceRecord.getContext().getContext().getValue().getOclObject(), visitor, env)) continue;
                    return target;
                }
                for (VarParameterValue varParameterValue : results.getResult()) {
                    Object target = varParameterValue.getValue().getOclObject();
                    if (!QvtResolveUtil.checkTypeAndCondition(resolveExp, target, visitor, env)) continue;
                    return target;
                }
            }
            return null;
        }
        List sequence = CollectionUtil.createNewSequence();
        for (TraceRecord traceRecord : traceRecords) {
            EMappingResults results = traceRecord.getResult();
            if (resolveExp.isIsInverse()) {
                Object target;
                if (traceRecord.getContext().getContext() == null || !QvtResolveUtil.checkTypeAndCondition(resolveExp, target = traceRecord.getContext().getContext().getValue().getOclObject(), visitor, env)) continue;
                sequence.add(target);
                continue;
            }
            for (VarParameterValue varParameterValue : results.getResult()) {
                Object target = varParameterValue.getValue().getOclObject();
                if (!QvtResolveUtil.checkTypeAndCondition(resolveExp, target, visitor, env)) continue;
                sequence.add(target);
            }
        }
        return sequence;
    }

    private static EMap<Object, EList<TraceRecord>> chooseKeyToTraceRecordMap(ResolveExp resolveExp, Trace trace) {
        return resolveExp.isIsInverse() ? trace.getTargetToTraceRecordMap() : trace.getSourceToTraceRecordMap();
    }

    private static boolean checkTypeAndCondition(ResolveExp resolveExp, Object resolveCandidate, QvtOperationalEvaluationVisitor visitor, QvtOperationalEvaluationEnv env) {
        EClassifier type;
        if (resolveExp.getTarget() != null && resolveExp.getTarget().getType() != null && !(type = (EClassifier)resolveExp.getTarget().getType()).isInstance(resolveCandidate)) {
            return false;
        }
        if (resolveExp.getCondition() != null) {
            if (resolveExp.getTarget() != null && resolveExp.getTarget().getName() != null) {
                env.add(resolveExp.getTarget().getName(), resolveCandidate);
            }
            Object conditionEval = resolveExp.getCondition().accept((Visitor)visitor);
            if (resolveExp.getTarget() != null && resolveExp.getTarget().getName() != null) {
                env.remove(resolveExp.getTarget().getName());
            }
            return Boolean.TRUE.equals(conditionEval);
        }
        return true;
    }

    private static Object createEmptyCollectionOrNull(ResolveExp resolveExp) {
        if (resolveExp.isOne()) {
            return null;
        }
        return CollectionUtil.createNewSequence();
    }

    static interface SavedSourceObjectHolder {
        public Object getSourceObj();

        public boolean isInDeferredExecution();
    }
}

