/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfilerDB;

public class ProfileSessionsManager {
    private static List<ProfilerDB> fProfileDBs = new ArrayList<ProfilerDB>();
    private static List<IProfileSessionListener> fProfileSessionListeners = new ArrayList<IProfileSessionListener>();
    private static ProfilerDB fCurrent;

    public static void addSession(ProfilerDB db) {
        int i = 0;
        while (i < fProfileDBs.size()) {
            if (fProfileDBs.get(i).getProfileDate().equals(db.getProfileDate())) {
                return;
            }
            ++i;
        }
        fProfileDBs.add(db);
        i = 0;
        while (i < fProfileSessionListeners.size()) {
            fProfileSessionListeners.get(i).profileSessionAdded(db);
            ++i;
        }
        ProfileSessionsManager.setCurrent(db);
    }

    public static void removeSession(ProfilerDB db) {
        if (fProfileDBs.contains(db)) {
            fProfileDBs.remove(db);
            int i = 0;
            while (i < fProfileSessionListeners.size()) {
                fProfileSessionListeners.get(i).profileSessionRemoved(db);
                ++i;
            }
            if (db == fCurrent) {
                if (fProfileDBs.size() > 0) {
                    ProfileSessionsManager.setCurrent(fProfileDBs.get(fProfileDBs.size() - 1));
                } else {
                    ProfileSessionsManager.setCurrent(null);
                }
            }
        }
    }

    public static ProfilerDB[] getSessions() {
        return fProfileDBs.toArray(new ProfilerDB[fProfileDBs.size()]);
    }

    public static void addProfileSessionListener(IProfileSessionListener listener) {
        if (!fProfileSessionListeners.contains(listener)) {
            fProfileSessionListeners.add(listener);
        }
    }

    public static void removeProfileSessionListener(IProfileSessionListener listener) {
        if (fProfileSessionListeners.contains(listener)) {
            fProfileSessionListeners.remove(listener);
        }
    }

    public static ProfilerDB getCurrent() {
        return fCurrent;
    }

    public static void setCurrent(ProfilerDB profileDB) {
        if (fCurrent != profileDB) {
            fCurrent = profileDB;
            int i = 0;
            while (i < fProfileSessionListeners.size()) {
                fProfileSessionListeners.get(i).currentSessionChanged(fCurrent);
                ++i;
            }
        }
    }
}

