/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.sdk.s2e.ui.fields.javadoc.JavaDocBrowser;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IDialogSettingsProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISearchRangeConsumer;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISelectionStateLabelProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.util.NormalizedPattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractContentProviderAdapter
extends BaseLabelProvider
implements IProposalContentProvider,
ILabelProvider,
ISearchRangeConsumer,
IDialogSettingsProvider,
ISelectionStateLabelProvider,
IProposalDescriptionProvider {
    private final Map<Object, int[]> m_searchRanges = new HashMap<Object, int[]>();
    private ILabelProvider m_decoratingWorkbenchLabelProvider;
    private volatile Collection<?> m_allProposals;
    private final Object m_proposalsLock = new Object();

    protected AbstractContentProviderAdapter() {
        this.m_decoratingWorkbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        super.dispose();
        this.m_allProposals = null;
        this.m_searchRanges.clear();
        if (this.m_decoratingWorkbenchLabelProvider != null) {
            this.m_decoratingWorkbenchLabelProvider.dispose();
            this.m_decoratingWorkbenchLabelProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.m_proposalsLock;
        synchronized (object) {
            this.m_allProposals = null;
        }
    }

    public Image getImage(Object element) {
        return this.m_decoratingWorkbenchLabelProvider.getImage(element);
    }

    @Override
    public Image getImageSelected(Object element) {
        return this.getImage(element);
    }

    @Override
    public String getTextSelected(Object element) {
        return this.getText(element);
    }

    @Override
    public Object createDescriptionContent(Object element, IProgressMonitor monitor) {
        if (!(element instanceof IJavaElement)) {
            return null;
        }
        return JavaDocBrowser.getJavaDoc((IJavaElement)element);
    }

    @Override
    public Control createDescriptionControl(Composite parent, Object content) {
        Browser browser = JavaDocBrowser.create(parent, content.toString());
        if (browser == null) {
            return null;
        }
        GridDataFactory.defaultsFor((Control)browser).align(4, 4).grab(true, true).applyTo((Control)browser);
        return browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Object> getProposals(NormalizedPattern searchPattern, IProgressMonitor monitor) {
        try {
            this.startRecordMatchRegions();
            if (monitor != null && monitor.isCanceled()) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            Collection<?> proposals = this.doLoadProposals();
            if (proposals == null || proposals.isEmpty()) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            ArrayList result = new ArrayList(proposals.size());
            for (Object o : proposals) {
                if (monitor != null && monitor.isCanceled()) break;
                int[] matchRegions = searchPattern.getMatchingRegions(this.getText(o));
                if (matchRegions != null) {
                    result.add(o);
                }
                this.addMatchRegions(o, matchRegions);
            }
            ArrayList<?> arrayList = result;
            return arrayList;
        }
        finally {
            this.endRecordMatchRegions();
        }
    }

    @Override
    public int[] getMatchRanges(Object element) {
        return this.m_searchRanges.get(element);
    }

    @Override
    public void startRecordMatchRegions() {
        this.m_searchRanges.clear();
    }

    @Override
    public void addMatchRegions(Object element, int[] matchRegions) {
        this.m_searchRanges.put(element, matchRegions);
    }

    @Override
    public void endRecordMatchRegions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<?> doLoadProposals() {
        Collection<?> loadedProposals = this.m_allProposals;
        if (loadedProposals != null) {
            return loadedProposals;
        }
        Object object = this.m_proposalsLock;
        synchronized (object) {
            loadedProposals = this.m_allProposals;
            if (loadedProposals != null) {
                return loadedProposals;
            }
            loadedProposals = this.loadProposals((IProgressMonitor)new NullProgressMonitor());
            if (loadedProposals == null) {
                loadedProposals = Collections.emptyList();
            }
            this.m_allProposals = loadedProposals;
            return loadedProposals;
        }
    }

    @Override
    public IDialogSettings getDialogSettings() {
        return S2ESdkUiActivator.getDefault().getDialogSettingsSection(this.getClass().getName());
    }

    protected abstract Collection<?> loadProposals(IProgressMonitor var1);
}

