/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.utils;

import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.sirius.editor.utils.TextChangeHelper;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class TextWithContentAssistChangeHelper
extends TextChangeHelper {
    @Override
    public void handleEvent(Event event) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] contentAssistBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (contentAssistBindings != null && contentAssistBindings.length > 0) {
            KeyStroke keyStroke = this.getKeyStroke(contentAssistBindings[0]);
            switch (event.type) {
                case 1: {
                    boolean isCR;
                    boolean bl = isCR = event.character == '\r' && this.notifyOnCarriageReturn;
                    if (!isCR && (keyStroke == null || event.keyCode != keyStroke.getNaturalKey() || event.stateMask != keyStroke.getModifierKeys())) break;
                    this.textChanged((Text)event.widget);
                    break;
                }
                case 16: {
                    this.textChanged((Text)event.widget);
                    break;
                }
            }
        }
    }

    private KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

