/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

final class RegExpSource {
    private static final Pattern HAS_BACK_REFERENCES = Pattern.compile("\\\\(\\d+)");
    private static final Pattern BACK_REFERENCING_END = Pattern.compile("\\\\(\\d+)");
    private String source;
    final RuleId ruleId;
    final boolean hasBackReferences;
    private String @Nullable [][] anchorCache;

    RegExpSource(String regExpSource, RuleId ruleId) {
        this(regExpSource, ruleId, true);
    }

    RegExpSource(String regExpSource, RuleId ruleId, boolean handleAnchors) {
        if (handleAnchors && !regExpSource.isEmpty()) {
            int len = regExpSource.length();
            int lastPushedPos = 0;
            StringBuilder output = new StringBuilder();
            boolean hasAnchors = false;
            int pos = 0;
            while (pos < len) {
                char ch = regExpSource.charAt(pos);
                if (ch == '\\' && pos + 1 < len) {
                    char nextCh = regExpSource.charAt(pos + 1);
                    if (nextCh == 'z') {
                        output.append(regExpSource.substring(lastPushedPos, pos));
                        output.append("$(?!\\n)(?<!\\n)");
                        lastPushedPos = pos + 2;
                    } else if (nextCh == 'A' || nextCh == 'G') {
                        hasAnchors = true;
                    }
                    ++pos;
                }
                ++pos;
            }
            if (lastPushedPos == 0) {
                this.source = regExpSource;
            } else {
                output.append(regExpSource.substring(lastPushedPos, len));
                this.source = output.toString();
            }
            if (hasAnchors) {
                this.anchorCache = this.buildAnchorCache();
            }
        } else {
            this.source = regExpSource;
        }
        this.ruleId = ruleId;
        this.hasBackReferences = HAS_BACK_REFERENCES.matcher(this.source).find();
    }

    protected RegExpSource clone() {
        return new RegExpSource(this.source, this.ruleId);
    }

    void setSource(String newSource) {
        if (Objects.equals(this.source, newSource)) {
            return;
        }
        this.source = newSource;
        if (this.hasAnchor()) {
            this.anchorCache = this.buildAnchorCache();
        }
    }

    String resolveBackReferences(CharSequence lineText, OnigCaptureIndex[] captureIndices) {
        ArrayList<String> capturedValues = new ArrayList<String>(captureIndices.length);
        OnigCaptureIndex[] onigCaptureIndexArray = captureIndices;
        int n = captureIndices.length;
        int n2 = 0;
        while (n2 < n) {
            OnigCaptureIndex capture = onigCaptureIndexArray[n2];
            capturedValues.add(lineText.subSequence(capture.start, capture.end).toString());
            ++n2;
        }
        return BACK_REFERENCING_END.matcher(this.source).replaceAll(match -> {
            try {
                int index = Integer.parseInt(match.group(1));
                if (index < captureIndices.length) {
                    String replacement = RegexSource.escapeRegExpCharacters((CharSequence)capturedValues.get(index));
                    return Matcher.quoteReplacement(replacement);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return "";
        });
    }

    private String[][] buildAnchorCache() {
        String source = this.source;
        int sourceLen = source.length();
        StringBuilder A0_G0_result = new StringBuilder(sourceLen);
        StringBuilder A0_G1_result = new StringBuilder(sourceLen);
        StringBuilder A1_G0_result = new StringBuilder(sourceLen);
        StringBuilder A1_G1_result = new StringBuilder(sourceLen);
        int pos = 0;
        int len = sourceLen;
        while (pos < len) {
            char ch = source.charAt(pos);
            A0_G0_result.append(ch);
            A0_G1_result.append(ch);
            A1_G0_result.append(ch);
            A1_G1_result.append(ch);
            if (ch == '\\' && pos + 1 < len) {
                char nextCh = source.charAt(pos + 1);
                if (nextCh == 'A') {
                    A0_G0_result.append('\uffff');
                    A0_G1_result.append('\uffff');
                    A1_G0_result.append('A');
                    A1_G1_result.append('A');
                } else if (nextCh == 'G') {
                    A0_G0_result.append('\uffff');
                    A0_G1_result.append('G');
                    A1_G0_result.append('\uffff');
                    A1_G1_result.append('G');
                } else {
                    A0_G0_result.append(nextCh);
                    A0_G1_result.append(nextCh);
                    A1_G0_result.append(nextCh);
                    A1_G1_result.append(nextCh);
                }
                ++pos;
            }
            ++pos;
        }
        return new String[][]{{A0_G0_result.toString(), A0_G1_result.toString()}, {A1_G0_result.toString(), A1_G1_result.toString()}};
    }

    String resolveAnchors(boolean allowA, boolean allowG) {
        String[][] anchorCache = this.anchorCache;
        if (anchorCache == null) {
            return this.source;
        }
        return anchorCache[allowA ? 1 : 0][allowG ? 1 : 0];
    }

    boolean hasAnchor() {
        return this.anchorCache != null;
    }

    String getSource() {
        return this.source;
    }
}

