/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.unittest.ui;

import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.browser.IndexModelUtil;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.unittest.CDTUnitTestPlugin;
import org.eclipse.cdt.unittest.ui.ActionsMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestSuiteElement;

public class OpenTestAction
extends Action {
    protected String fClassName;
    protected String fMethodName;
    protected Shell shell;
    private String fSearchPrefix;

    public OpenTestAction(Shell shell, ITestSuiteElement testSuite) {
        this(shell, testSuite, null);
    }

    public OpenTestAction(Shell shell, ITestSuiteElement testSuite, ITestCaseElement testCase) {
        super(ActionsMessages.OpenEditorAction_action_label);
        this.shell = shell;
        this.fClassName = this.getClassName((ITestElement)testSuite);
        this.fMethodName = testCase != null ? this.getTestMethodName((ITestElement)testCase) : "*";
        this.fSearchPrefix = this.fClassName + '_' + this.fMethodName + "_Test";
    }

    public void run() {
        ITypeReference location;
        UpdateElementsJob searchJob = new UpdateElementsJob(ActionsMessages.OpenEditorAction_UpdateElementsJob_name);
        Object[] result = searchJob.runQuery(this.fSearchPrefix);
        Object infoObject = result != null && result.length > 0 ? result[0] : null;
        ITypeInfo info = infoObject instanceof ITypeInfo ? (ITypeInfo)infoObject : null;
        ITypeReference iTypeReference = location = info != null ? info.getResolvedReference() : null;
        if (location == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ActionsMessages.OpenEditorAction_error_cannotopen_title, (String)ActionsMessages.OpenEditorAction_error_cannotopen_message);
        } else if (!this.openTypeInEditor(location)) {
            String title = ActionsMessages.OpenEditorAction_error_cannotopen_title;
            String message = NLS.bind((String)ActionsMessages.OpenEditorAction_errorOpenEditor, (Object)location.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected Shell getShell() {
        return this.shell;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openTypeInEditor(ITypeReference location) {
        ICElement[] cElements = location.getCElements();
        try {
            if (cElements != null && cElements.length > 0) {
                IEditorPart editor = EditorUtility.openInEditor((Object)cElements[0]);
                EditorUtility.revealInEditor((IEditorPart)editor, (ICElement)cElements[0]);
                return true;
            }
            ITranslationUnit unit = location.getTranslationUnit();
            IEditorPart editorPart = null;
            if (unit != null) {
                editorPart = EditorUtility.openInEditor((Object)unit);
            }
            if (editorPart == null) {
                editorPart = EditorUtility.openInEditor((IPath)location.getLocation(), null);
            }
            if (editorPart == null || !(editorPart instanceof ITextEditor)) return false;
            ITextEditor editor = (ITextEditor)editorPart;
            if (!location.isLineNumber()) {
                editor.selectAndReveal(location.getOffset(), location.getLength());
                return true;
            }
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int startOffset = document.getLineOffset(location.getOffset() - 1);
                int length = document.getLineLength(location.getOffset() - 1);
                editor.selectAndReveal(startOffset, length);
                return true;
            }
            catch (BadLocationException ble) {
                return false;
            }
        }
        catch (CModelException ex) {
            CDTUnitTestPlugin.log(ex);
            return false;
        }
        catch (PartInitException ex) {
            CDTUnitTestPlugin.log(ex);
            return false;
        }
    }

    public String getClassName(ITestElement test) {
        return OpenTestAction.extractClassName(test.getTestName());
    }

    private static String extractClassName(String testNameString) {
        testNameString = OpenTestAction.extractRawClassName(testNameString);
        testNameString = testNameString.replace('$', '.');
        return testNameString;
    }

    public static String extractRawClassName(String testNameString) {
        if (testNameString.startsWith("[") && testNameString.endsWith("]")) {
            return testNameString;
        }
        int index = testNameString.lastIndexOf(40);
        if (index < 0) {
            return testNameString;
        }
        int end = testNameString.lastIndexOf(41);
        testNameString = testNameString.substring(index + 1, end > index ? end : testNameString.length());
        return testNameString;
    }

    private String getTestMethodName(ITestElement test) {
        String testName = test.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            return testName.substring(0, index);
        }
        index = testName.indexOf(64);
        if (index > 0) {
            return testName.substring(0, index);
        }
        return testName;
    }

    private class UpdateElementsJob
    extends Job {
        private volatile char[] fCurrentPrefix;
        private Object[] result;

        public UpdateElementsJob(String name) {
            super(name);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        public Object[] runQuery(String prefix) {
            this.fCurrentPrefix = this.toPrefixChars(prefix);
            this.result = null;
            this.schedule();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                return null;
            }
            return this.result;
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ActionsMessages.OpenEditorAction_UpdateElementsJob_inProgress, -1);
            ITypeInfo[] elements = this.getElementsByPrefix(this.fCurrentPrefix, monitor);
            if (elements != null && !monitor.isCanceled()) {
                this.result = elements;
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        private char[] toPrefixChars(String filterPrefix) {
            filterPrefix = CSearchUtil.adjustSearchStringForOperators((String)filterPrefix);
            return this.toPrefix(filterPrefix);
        }

        private char[] toPrefix(String userFilter) {
            QualifiedTypeName qualifiedName = new QualifiedTypeName(userFilter);
            if (qualifiedName.segmentCount() > 1) {
                userFilter = qualifiedName.lastSegment();
            }
            if (userFilter.endsWith("<")) {
                userFilter = userFilter.substring(0, userFilter.length() - 1);
            }
            int asterisk = userFilter.indexOf("*");
            int questionMark = userFilter.indexOf("?");
            int prefixEnd = asterisk < 0 ? questionMark : (questionMark < 0 ? asterisk : Math.min(asterisk, questionMark));
            return (prefixEnd == -1 ? userFilter : userFilter.substring(0, prefixEnd)).toCharArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected ITypeInfo[] getElementsByPrefix(char[] prefix, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return null;
            }
            HashSet<IndexTypeInfo> types = new HashSet<IndexTypeInfo>();
            if (prefix == null) return types.toArray(new ITypeInfo[types.size()]);
            IndexFilter filter = new IndexFilter(){

                public boolean acceptBinding(IBinding binding) throws CoreException {
                    if (UpdateElementsJob.this.isVisibleType(IndexModelUtil.getElementType((IBinding)binding))) {
                        return IndexFilter.ALL_DECLARED.acceptBinding(binding);
                    }
                    return false;
                }
            };
            try {
                IIndex index = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProjects(), 8);
                index.acquireReadLock();
                try {
                    IIndexBinding[] bindings = index.findBindingsForPrefix(prefix, false, filter, monitor);
                    int i = 0;
                    while (i < bindings.length) {
                        if (i % 4096 == 0 && monitor.isCanceled()) {
                            return null;
                        }
                        IndexTypeInfo typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexBinding)bindings[i]);
                        types.add(typeinfo);
                        ++i;
                    }
                    if (!this.isVisibleType(79)) return types.toArray(new ITypeInfo[types.size()]);
                    IIndexMacro[] macros = index.findMacrosForPrefix(prefix, IndexFilter.ALL_DECLARED, monitor);
                    int i2 = 0;
                    while (i2 < macros.length) {
                        if (i2 % 4096 == 0 && monitor.isCanceled()) {
                            return null;
                        }
                        IndexTypeInfo typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexMacro)macros[i2]);
                        types.add(typeinfo);
                        ++i2;
                    }
                    return types.toArray(new ITypeInfo[types.size()]);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (InterruptedException | CoreException e) {
                CDTUnitTestPlugin.log(e);
            }
            return types.toArray(new ITypeInfo[types.size()]);
        }

        protected boolean isVisibleType(int type) {
            return 65 == type || 67 == type;
        }
    }
}

