/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.ArchiveProjectFragmentInfo;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.NameLookup;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.dltk.internal.core.util.Util;

class ProjectElementInfo
extends OpenableElementInfo {
    ProjectCache projectCache;
    private Object[] foreignResources;

    ProjectElementInfo() {
    }

    void resetCaches() {
        this.projectCache = null;
    }

    void setForeignResources(Object[] resources) {
        this.foreignResources = resources;
    }

    public Object[] getForeignResources(ScriptProject project) {
        if (this.foreignResources == null) {
            this.foreignResources = this.computeForeignResources(project);
        }
        return this.foreignResources;
    }

    private Object[] computeForeignResources(ScriptProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getResolvedBuildpath();
            int i = 0;
            while (i < buildpath.length) {
                IBuildpathEntry entry = buildpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    inclusionPatterns = ((BuildpathEntry)entry).fullInclusionPatternChars();
                    exclusionPatterns = ((BuildpathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
        }
        catch (ModelException i) {
            // empty catch block
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (org.eclipse.dltk.compiler.util.Util.isArchiveFileName(DLTKLanguageManager.getLanguageToolkit(project), resName) && this.isBuildpathEntry(resFullPath, buildpath) || srcIsProject && Util.isValidSourceModule((IModelElement)project, res) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage((IContainer)project.getResource(), res.getName()) || this.isBuildpathEntry(resFullPath, buildpath)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException e) {
            resources = NO_NON_SCRIPT_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    private boolean isBuildpathEntry(IPath path, IBuildpathEntry[] resolvedBuildpath) {
        int i = 0;
        int length = resolvedBuildpath.length;
        while (i < length) {
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addNames(String[] name, HashtableOfArrayToObject set) {
        set.put(name, name);
        int length = name.length;
        int i = length - 1;
        while (i > 0) {
            Object[] superName = new String[i];
            System.arraycopy(name, 0, superName, 0, i);
            set.put(superName, superName);
            --i;
        }
    }

    NameLookup newNameLookup(ScriptProject project, ISourceModule[] workingCopies) {
        ProjectCache cache = this.getProjectCache(project);
        return new NameLookup(cache.allProjectFragmentCache, cache.allPkgFragmentsCache, cache.isPackageCache, workingCopies, cache.rootToResolvedEntries);
    }

    ProjectCache getProjectCache(ScriptProject project) {
        ProjectCache cache = this.projectCache;
        if (cache == null) {
            IProjectFragment[] roots;
            HashMap<IProjectFragment, BuildpathEntry> reverseMap = new HashMap<IProjectFragment, BuildpathEntry>(3);
            try {
                roots = project.getAllProjectFragments(reverseMap);
            }
            catch (ModelException e) {
                roots = new IProjectFragment[]{};
                reverseMap.clear();
            }
            HashtableOfArrayToObject fragmentsCache = new HashtableOfArrayToObject();
            HashtableOfArrayToObject isPackageCache = new HashtableOfArrayToObject();
            int i = 0;
            int length = roots.length;
            while (i < length) {
                block14: {
                    IProjectFragment root = roots[i];
                    IModelElement[] frags = null;
                    try {
                        if (DLTKCore.DEBUG) {
                            System.err.println("TODO: Require to check for ExternalProjectFragment compatibility.");
                        }
                        if (root.isArchive() && !root.isOpen()) {
                            ArchiveProjectFragmentInfo info = new ArchiveProjectFragmentInfo();
                            ((ArchiveProjectFragment)root).computeChildren(info, new HashMap());
                            frags = info.getChildren();
                        } else {
                            frags = root.getChildren();
                        }
                    }
                    catch (ModelException e) {
                        break block14;
                    }
                    int j = 0;
                    int length2 = frags.length;
                    while (j < length2) {
                        IScriptFolder fragment = (IScriptFolder)frags[j];
                        IPath parentPath = fragment.getParent().getPath();
                        Object[] pkgName = fragment.getPath().removeFirstSegments(parentPath.segmentCount()).segments();
                        Object existing = fragmentsCache.get(pkgName);
                        if (existing == null) {
                            fragmentsCache.put(pkgName, root);
                            ProjectElementInfo.addNames((String[])pkgName, isPackageCache);
                        } else if (existing instanceof IProjectFragment) {
                            fragmentsCache.put(pkgName, new IProjectFragment[]{(IProjectFragment)existing, root});
                        } else {
                            IProjectFragment[] entry = (IProjectFragment[])existing;
                            IProjectFragment[] copy = new IProjectFragment[entry.length + 1];
                            System.arraycopy(entry, 0, copy, 0, entry.length);
                            copy[entry.length] = root;
                            fragmentsCache.put(pkgName, copy);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.projectCache = cache = new ProjectCache(roots, fragmentsCache, isPackageCache, reverseMap);
        }
        return cache;
    }

    static class ProjectCache {
        public IProjectFragment[] allProjectFragmentCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public HashtableOfArrayToObject isPackageCache;
        public Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries;

        ProjectCache(IProjectFragment[] allProjectFragmentCache, HashtableOfArrayToObject allPkgFragmentsCache, HashtableOfArrayToObject isPackageCache, Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries) {
            this.allProjectFragmentCache = allProjectFragmentCache;
            this.allPkgFragmentsCache = allPkgFragmentsCache;
            this.rootToResolvedEntries = rootToResolvedEntries;
            this.isPackageCache = isPackageCache;
        }
    }
}

