/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.File;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.IScrollMemory;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.cdt.debug.core.memory.transport.WriteMemory;
import org.eclipse.cdt.debug.internal.core.memory.transport.RAWBinaryImport;
import org.eclipse.cdt.debug.internal.core.memory.transport.TransportJob;
import org.eclipse.cdt.debug.internal.ui.memory.transport.ScrollMemory;
import org.eclipse.cdt.debug.internal.ui.memory.transport.WriteMemoryBlock;
import org.eclipse.cdt.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RAWBinaryImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;

    @Override
    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                RAWBinaryImporter.this.fProperties.put("File", RAWBinaryImporter.this.fFileText.getText().trim());
                RAWBinaryImporter.this.fProperties.put("Start", RAWBinaryImporter.this.fStartText.getText().trim());
                RAWBinaryImporter.this.fProperties.put("ScrollToStart", RAWBinaryImporter.this.fScrollToBeginningOnImportComplete.getSelection());
                try {
                    RAWBinaryImporter.this.fStartAddress = RAWBinaryImporter.this.getStartAddress();
                    RAWBinaryImporter.this.fInputFile = RAWBinaryImporter.this.getFile();
                    RAWBinaryImporter.this.fScrollToStart = RAWBinaryImporter.this.getScrollToStart();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label labelStartText = new Label(composite, 0);
        labelStartText.setText(Messages.getString("RAWBinaryImporter.RestoreAddress"));
        this.fStartText = new Text(composite, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)labelStartText);
        data.width = 120;
        this.fStartText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Importer.File"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Importer.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                dialog.setText(Messages.getString("RAWBinaryImporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Importer.AllFiles")});
                dialog.setFileName(RAWBinaryImporter.this.fFileText.getText().trim());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    RAWBinaryImporter.this.fFileText.setText(dialog.getFilterPath() + File.separator + filename);
                }
                RAWBinaryImporter.this.validate();
            }
        });
        this.fStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    RAWBinaryImporter.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                RAWBinaryImporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                RAWBinaryImporter.this.validate();
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RAWBinaryImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText(Messages.getString("RAWBinaryImporter.ScrollToStart"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        boolean scrollToStart = properties.getBoolean("ScrollToStart");
        this.fScrollToBeginningOnImportComplete.setSelection(scrollToStart);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(() -> this.validate());
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getStartAddress();
            if (this.fFileText.getText().trim().length() == 0) {
                isValid = false;
            }
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText().trim());
    }

    @Override
    public String getId() {
        return "rawbinary";
    }

    @Override
    public String getName() {
        return Messages.getString("RAWBinaryImporter.Name");
    }

    @Override
    public void importMemory() {
        try {
            IScrollMemory scroll = this.fScrollToStart != false ? new ScrollMemory(this.fParentDialog) : IScrollMemory.ignore();
            IMemoryBlockExtension block = (IMemoryBlockExtension)this.fMemoryBlock;
            ImportRequest request = new ImportRequest(block.getBigBaseAddress(), this.fStartAddress, (WriteMemory)new WriteMemoryBlock(block));
            RAWBinaryImport memoryImport = new RAWBinaryImport(this.fInputFile, request, scroll);
            TransportJob job = new TransportJob("Memory Import from RAW Binary File", (ICoreRunnable)memoryImport);
            job.setUser(true);
            job.schedule();
        }
        catch (DebugException e) {
            ErrorDialog.openError((Shell)this.fParentDialog.getShell(), (String)"Import Failure", (String)"Failed to retrieve base memory address", (IStatus)e.getStatus());
        }
    }
}

