/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.wizards;

import com.ibm.icu.lang.UCharacter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.util.JavaUtils;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.AbstractModelDiscovererParameters;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.DiscoveryParameterLine;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.ParameterCellModifier;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.TypeCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewDiscovererMainWizardPage
extends NewTypeWizardPage {
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int TYPE_COLUMN_INDEX = 1;
    private static final int DESCRIPTION_COLUMN_INDEX = 2;
    private static final int DIRECTION_COLUMN_INDEX = 3;
    private static final int REQUIRED_COLUMN_INDEX = 4;
    private static final int MULTIVALUED_COLUMN_INDEX = 5;
    public static final String NAME_COLUMN_PROPERTY = "name";
    public static final String TYPE_COLUMN_PROPERTY = "type";
    public static final String DESCRIPTION_COLUMN_PROPERTY = "description";
    public static final String DIRECTION_COLUMN_PROPERTY = "direction";
    public static final String REQUIRED_COLUMN_PROPERTY = "required";
    public static final String MULTIVALUED_COLUMN_PROPERTY = "multivalued";
    private static final String TXT_DISCOVERER_NAME = "txtDiscovererName";
    private static final String CHECKBOX_EXTEND_ABSTRACT_MODEL_DISCOVERER = "checkboxExtendAbstractModelDiscoverer";
    private static final String COMBO_INPUT_TYPE = "txtInputType";
    private static final String PARAMETERS_TABLE = "parametersTable";
    private Text txtDiscovererName;
    private Table tableParameters;
    private Combo fComboInputType;
    private IStatus fTxtDiscovererNameStatus;
    private IStatus fComboInputTypeStatus;
    private List<IStatus> fParametersTableStatus;
    private Button checkboxExtendAbstractModelDiscoverer;
    private String fInputType;
    private final List<DiscoveryParameterLine> fParameters = new ArrayList<DiscoveryParameterLine>();
    private TableViewer tableViewerParameters;
    private String fDiscovererName;
    private boolean fRegisterPopupMenu;
    private Image pageImage = null;
    private Button checkboxPopupMenu;
    private Text fDiscovererLabelText;
    private String fDiscovererLabel;
    private static final int PARAMETER_TABLE_HEIGHT = 120;
    private static final int NAME_COLUMN_WIDTH = 85;
    private static final int TYPE_COLUMN_WIDTH = 85;
    private static final int DESCRIPTION_COLUMN_WIDTH = 120;
    private static final int DIRECTION_COLUMN_WIDTH = 70;
    private static final int REQUIRED_COLUMN_WIDTH = 60;
    private static final int MULTIVALUED_COLUMN_WIDTH = 75;

    public NewDiscovererMainWizardPage() {
        super(true, NewDiscovererMainWizardPage.class.getName());
        this.setTitle(Messages.NewDiscovererMainWizardPage_newMoDiscoDiscoverer);
        this.setDescription(Messages.NewDiscovererMainWizardPage_createNewDiscoverer);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        int nColumns = 4;
        container.setLayout((Layout)new GridLayout(4, false));
        this.createContainerControls(container, 4);
        this.createPackageControls(container, 4);
        this.createTypeNameControls(container, 4);
        this.createSeparator(container, 4);
        this.createInputType(container);
        this.createDiscovererNameField(container);
        Label lblParameters = new Label(container, 0);
        lblParameters.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblParameters.setText(Messages.NewDiscovererMainWizardPage_discoverParamsDecl);
        this.createParametersTable(container);
        this.createTableButtons(container);
        this.createSeparator(container, 4);
        this.createExtendCheckbox(container);
        this.createPopupMenuGroup(container);
        this.updateSuperType();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private void createInputType(Composite container) {
        Label lblInputType = new Label(container, 0);
        lblInputType.setText(Messages.NewDiscovererMainWizardPage_inputType);
        this.fComboInputType = new Combo(container, 2048);
        this.fComboInputType.setItems(new String[]{"org.eclipse.core.resources.IFile", "org.eclipse.core.resources.IFolder", "org.eclipse.core.resources.IProject"});
        this.fComboInputType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fComboInputType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDiscovererMainWizardPage.this.handleFieldChanged(NewDiscovererMainWizardPage.COMBO_INPUT_TYPE);
                NewDiscovererMainWizardPage.this.updateSuperType();
            }
        });
        Button btnBrowseInputType = new Button(container, 0);
        btnBrowseInputType.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnBrowseInputType.setText(Messages.NewDiscovererMainWizardPage_browse);
        btnBrowseInputType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = NewDiscovererMainWizardPage.this.chooseInputType();
                if (type != null) {
                    NewDiscovererMainWizardPage.this.fComboInputType.setText(type.getFullyQualifiedName('.'));
                    NewDiscovererMainWizardPage.this.handleFieldChanged(NewDiscovererMainWizardPage.COMBO_INPUT_TYPE);
                    NewDiscovererMainWizardPage.this.updateSuperType();
                }
            }
        });
    }

    private void createDiscovererNameField(Composite container) {
        Label lblDiscovererName = new Label(container, 0);
        lblDiscovererName.setText(Messages.NewDiscovererMainWizardPage_uiName);
        this.txtDiscovererName = new Text(container, 2048);
        this.txtDiscovererName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtDiscovererName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDiscovererMainWizardPage.this.handleFieldChanged(NewDiscovererMainWizardPage.TXT_DISCOVERER_NAME);
            }
        });
        NewDiscovererMainWizardPage.spacer(container);
    }

    private static void spacer(Composite container) {
        new Label(container, 0);
    }

    private void createParametersTable(Composite container) {
        this.tableViewerParameters = new TableViewer(container, 67586);
        this.tableParameters = this.tableViewerParameters.getTable();
        this.tableParameters.setLinesVisible(true);
        this.tableParameters.setHeaderVisible(true);
        GridData gdTableParameters = new GridData(4, 4, true, true, 2, 1);
        gdTableParameters.heightHint = 120;
        this.tableParameters.setLayoutData((Object)gdTableParameters);
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnName = tableViewerColumnName.getColumn();
        tableColumnName.setWidth(85);
        tableColumnName.setText(Messages.NewDiscovererMainWizardPage_name);
        TableViewerColumn tableViewerColumnType = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnType = tableViewerColumnType.getColumn();
        tableColumnType.setWidth(85);
        tableColumnType.setText(Messages.NewDiscovererMainWizardPage_type);
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnDescription = tableViewerColumnDescription.getColumn();
        tableColumnDescription.setWidth(120);
        tableColumnDescription.setText(Messages.NewDiscovererMainWizardPage_description);
        TableViewerColumn tableViewerColumnDirection = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnDirection = tableViewerColumnDirection.getColumn();
        tableColumnDirection.setWidth(70);
        tableColumnDirection.setText(Messages.NewDiscovererMainWizardPage_direction);
        TableViewerColumn tableViewerColumnRequired = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnRequired = tableViewerColumnRequired.getColumn();
        tableColumnRequired.setWidth(60);
        tableColumnRequired.setText(Messages.NewDiscovererMainWizardPage_required);
        TableViewerColumn tableViewerColumnMultivalued = new TableViewerColumn(this.tableViewerParameters, 0);
        TableColumn tableColumnMultivalued = tableViewerColumnMultivalued.getColumn();
        tableColumnMultivalued.setWidth(75);
        tableColumnMultivalued.setText(Messages.NewDiscovererMainWizardPage_multivalued);
        this.tableViewerParameters.setColumnProperties(new String[]{NAME_COLUMN_PROPERTY, TYPE_COLUMN_PROPERTY, DESCRIPTION_COLUMN_PROPERTY, DIRECTION_COLUMN_PROPERTY, REQUIRED_COLUMN_PROPERTY, MULTIVALUED_COLUMN_PROPERTY});
        this.tableViewerParameters.setContentProvider((IContentProvider)new ParametersTableContentProvider());
        this.tableViewerParameters.setLabelProvider((IBaseLabelProvider)new ParametersTableLabelProvider());
        this.tableViewerParameters.setInput(this.fParameters);
        this.createCellEditors();
    }

    protected void createCellEditors() {
        int nColumns = 6;
        CellEditor[] editors = new CellEditor[6];
        editors[0] = new TextCellEditor((Composite)this.tableParameters);
        editors[1] = new TypeCellEditor((Composite)this.tableParameters, new TypeCellEditor.IJavaProjectProvider(){

            @Override
            public IJavaProject getJavaProject() {
                return NewDiscovererMainWizardPage.this.getJavaProject();
            }
        });
        editors[2] = new TextCellEditor((Composite)this.tableParameters);
        DirectionKind[] values = DirectionKind.values();
        String[] valueNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            valueNames[i] = values[i].name();
            ++i;
        }
        editors[3] = new ComboBoxCellEditor((Composite)this.tableParameters, valueNames, 8);
        editors[4] = new CheckboxCellEditor((Composite)this.tableParameters);
        editors[5] = new CheckboxCellEditor((Composite)this.tableParameters);
        this.tableViewerParameters.setCellEditors(editors);
        this.tableViewerParameters.setCellModifier((ICellModifier)new ParameterCellModifier(this));
    }

    private void createTableButtons(Composite container) {
        Composite buttonsComposite = new Composite(container, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        Button btnAddParameter = new Button(buttonsComposite, 0);
        btnAddParameter.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddParameter.setText(Messages.NewDiscovererMainWizardPage_add);
        btnAddParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryParameterLine discoveryParameterLine = new DiscoveryParameterLine();
                NewDiscovererMainWizardPage.this.getParameters().add(discoveryParameterLine);
                NewDiscovererMainWizardPage.this.getTableViewerParameters().refresh();
                NewDiscovererMainWizardPage.this.getTableViewerParameters().editElement((Object)discoveryParameterLine, 0);
                NewDiscovererMainWizardPage.this.parameterDataWasModified();
            }
        });
        Button btnRemoveParameter = new Button(buttonsComposite, 0);
        btnRemoveParameter.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnRemoveParameter.setText(Messages.NewDiscovererMainWizardPage_remove);
        btnRemoveParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NewDiscovererMainWizardPage.this.getTableViewerParameters().getSelection();
                for (Object element : selection) {
                    if (AbstractModelDiscovererParameters.isInheritedParameter(element)) continue;
                    NewDiscovererMainWizardPage.this.getParameters().remove(element);
                }
                NewDiscovererMainWizardPage.this.getTableViewerParameters().refresh();
                NewDiscovererMainWizardPage.this.parameterDataWasModified();
            }
        });
    }

    private void createExtendCheckbox(Composite container) {
        Group group = new Group(container, 0);
        group.setText(Messages.NewDiscovererMainWizardPage_handlesModel);
        int horizontalSpan = 3;
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        group.setLayout((Layout)new GridLayout());
        NewDiscovererMainWizardPage.spacer(container);
        this.checkboxExtendAbstractModelDiscoverer = new Button((Composite)group, 32);
        this.checkboxExtendAbstractModelDiscoverer.setText(Messages.NewDiscovererMainWizardPage_extendAbstractModelDiscoverer);
        this.checkboxExtendAbstractModelDiscoverer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDiscovererMainWizardPage.this.updateSuperType();
                NewDiscovererMainWizardPage.this.getTableViewerParameters().refresh();
                NewDiscovererMainWizardPage.this.handleFieldChanged(NewDiscovererMainWizardPage.CHECKBOX_EXTEND_ABSTRACT_MODEL_DISCOVERER);
            }
        });
    }

    private void createPopupMenuGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(Messages.NewDiscovererMainWizardPage_makeUIContributions);
        int horizontalSpan = 3;
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        NewDiscovererMainWizardPage.spacer(container);
        this.checkboxPopupMenu = new Button((Composite)group, 32);
        this.checkboxPopupMenu.setText(Messages.NewDiscovererMainWizardPage_registerMenuAction);
        this.checkboxPopupMenu.setToolTipText(Messages.NewDiscovererMainWizardPage_registerMenuActionTooltip);
        this.checkboxPopupMenu.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        final Label label = new Label((Composite)group, 0);
        label.setText(Messages.NewDiscovererMainWizardPage_discovererLabel);
        label.setToolTipText(Messages.NewDiscovererMainWizardPage_discovererLabelTooltip);
        label.setEnabled(false);
        this.fDiscovererLabelText = new Text((Composite)group, 2048);
        this.fDiscovererLabelText.setEnabled(false);
        this.fDiscovererLabelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkboxPopupMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDiscovererMainWizardPage.this.fDiscovererLabelText.setEnabled(NewDiscovererMainWizardPage.this.checkboxPopupMenu.getSelection());
                label.setEnabled(NewDiscovererMainWizardPage.this.checkboxPopupMenu.getSelection());
            }
        });
    }

    protected String getTypeNameLabel() {
        return Messages.NewDiscovererMainWizardPage_className;
    }

    protected void updateSuperType() {
        String text = this.fComboInputType.getText();
        if (text.trim().length() == 0) {
            text = "java.lang.Object";
        }
        if (this.checkboxExtendAbstractModelDiscoverer.getSelection()) {
            this.setSuperClass("org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer<" + text + ">", true);
        } else {
            this.setSuperClass("org.eclipse.modisco.infra.discovery.core.AbstractDiscoverer<" + text + ">", true);
        }
    }

    private void doStatusUpdate() {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        statuses.add(this.fContainerStatus);
        statuses.add(this.fPackageStatus);
        statuses.add(this.fTypeNameStatus);
        statuses.add(this.fComboInputTypeStatus);
        statuses.add(this.fTxtDiscovererNameStatus);
        statuses.addAll(this.fParametersTableStatus);
        this.updateStatus(statuses.toArray(new IStatus[statuses.size()]));
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == TXT_DISCOVERER_NAME || fieldName == "NewContainerWizardPage.container") {
            this.fTxtDiscovererNameStatus = this.txtDiscovererNameStatus();
        }
        if (fieldName == COMBO_INPUT_TYPE || fieldName == "NewContainerWizardPage.container") {
            this.fComboInputTypeStatus = this.comboInputTypeStatus();
        }
        if (fieldName == PARAMETERS_TABLE || fieldName == "NewContainerWizardPage.container") {
            this.fParametersTableStatus = this.parametersTableStatuses();
        }
        this.doStatusUpdate();
    }

    private IStatus txtDiscovererNameStatus() {
        if (this.txtDiscovererName == null || this.txtDiscovererName.getText().trim().length() == 0) {
            return new Status(4, "org.eclipse.modisco.infra.discovery.ui", Messages.NewDiscovererMainWizardPage_uiNameIsEmpty);
        }
        String text = this.txtDiscovererName.getText();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (" #/\\<>&'\"".indexOf(c) != -1) {
                return new Status(4, "org.eclipse.modisco.infra.discovery.ui", Messages.NewDiscovererMainWizardPage_noSpecialChars);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.modisco.infra.discovery.ui", null);
    }

    private IStatus comboInputTypeStatus() {
        if (this.fComboInputType != null) {
            String name = this.fComboInputType.getText();
            return JavaConventions.validateJavaTypeName((String)name, (String)"1.5", (String)"1.5");
        }
        return new Status(4, "org.eclipse.modisco.infra.discovery.ui", Messages.NewDiscovererMainWizardPage_inputTypeFieldInvalid);
    }

    protected IStatus containerChanged() {
        IFile manifestResource;
        IStatus status = super.containerChanged();
        if (status.isOK() && (manifestResource = (IFile)this.getJavaProject().getProject().findMember((IPath)new Path("/META-INF/MANIFEST.MF"))) == null) {
            return new Status(4, "org.eclipse.modisco.infra.discovery.ui", "Project is not a plug-in project (doesn't have a Manifest.MF)");
        }
        return status;
    }

    private List<IStatus> parametersTableStatuses() {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (DiscoveryParameterLine parameter : this.fParameters) {
            String description;
            String name = parameter.getName();
            if (name.length() == 0) {
                statuses.add((IStatus)new Status(4, "org.eclipse.modisco.infra.discovery.ui", Messages.NewDiscovererMainWizardPage_parameterWithEmptyName));
            } else {
                IStatus nameStatus = JavaConventions.validateFieldName((String)name, (String)"1.5", (String)"1.5");
                if (!nameStatus.isOK()) {
                    statuses.add(nameStatus);
                }
            }
            String type = parameter.getType();
            IStatus typeNameStatus = JavaConventions.validateJavaTypeName((String)type, (String)"1.5", (String)"1.5");
            if (!typeNameStatus.isOK()) {
                statuses.add(typeNameStatus);
            }
            if ((description = parameter.getDescription()).trim().length() != 0) continue;
            statuses.add((IStatus)new Status(2, "org.eclipse.modisco.infra.discovery.ui", Messages.NewDiscovererMainWizardPage_parameterMustHaveDescription));
        }
        return statuses;
    }

    public void init(IStructuredSelection selection) {
        IJavaElement javaElement = this.getInitialJavaElement(selection);
        this.initContainerPage(javaElement);
        this.initTypePage(javaElement);
        this.doStatusUpdate();
    }

    protected IType chooseInputType() {
        IJavaProject project = this.getJavaProject();
        ArrayList<String> bundlesInSearchPath = new ArrayList<String>();
        bundlesInSearchPath.add("org.eclipse.emf.ecore");
        return JavaUtils.openTypeSelectionDialog((IJavaProject)project, bundlesInSearchPath, (Shell)this.getShell(), (IRunnableContext)this.getContainer(), (int)512, (String)Messages.NewDiscovererMainWizardPage_chooseInputType, (String)Messages.NewDiscovererMainWizardPage_chooseInputTypeLong);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        StringBuffer buf = new StringBuffer();
        String lineDelimiter = "\n";
        String inputType = imports.addImport(this.fInputType);
        for (DiscoveryParameterLine parameter : this.fParameters) {
            String shortType = imports.addImport(parameter.getType());
            String shortParameter = imports.addImport("org.eclipse.modisco.infra.discovery.core.annotations.Parameter");
            Object capitalizedName = parameter.getName().length() > 0 ? UCharacter.toUpperCase((int)parameter.getName().charAt(0)) + parameter.getName().substring(1) : "";
            if (parameter.getDescription().trim().length() > 0) {
                buf.append("/** ").append(parameter.getDescription()).append(" */").append("\n");
            }
            buf.append("private ").append(shortType).append(NewDiscovererMainWizardPage.maybeArray(parameter.isMultivalued())).append(" ").append(parameter.getName()).append(";").append("\n");
            type.createField(buf.toString(), null, false, monitor);
            buf.setLength(0);
            if (parameter.getDirection().equals((Object)DirectionKind.OUT) || parameter.getDirection().equals((Object)DirectionKind.INOUT)) {
                buf.append("@").append(shortParameter).append("(name=\"").append(parameter.getName()).append("\"").append(NewDiscovererMainWizardPage.maybeDescription(parameter.getDescription())).append(")").append("\n");
                buf.append("public ").append(shortType).append(NewDiscovererMainWizardPage.maybeArray(parameter.isMultivalued())).append(" get").append((String)capitalizedName).append("() {").append("\n");
                buf.append("return this.").append(parameter.getName()).append(";").append("\n");
                buf.append("}").append("\n");
                type.createMethod(buf.toString(), null, false, monitor);
                buf.setLength(0);
            }
            if (!parameter.getDirection().equals((Object)DirectionKind.IN) && !parameter.getDirection().equals((Object)DirectionKind.INOUT)) continue;
            buf.append("@").append(shortParameter).append("(name=\"").append(parameter.getName()).append("\"").append(NewDiscovererMainWizardPage.maybeDescription(parameter.getDescription())).append(NewDiscovererMainWizardPage.maybeRequiresInputValue(parameter.isRequired())).append(")").append("\n");
            buf.append("public void set").append((String)capitalizedName).append("(").append(shortType).append(NewDiscovererMainWizardPage.maybeArray(parameter.isMultivalued())).append(" value) {").append("\n");
            buf.append("this.").append(parameter.getName()).append(" = value;").append("\n");
            buf.append("}").append("\n");
            type.createMethod(buf.toString(), null, false, monitor);
            buf.setLength(0);
        }
        buf.append("public boolean isApplicableTo(final ").append(inputType).append(" source) {").append("\n");
        String isApplicableToBodyContent = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"isApplicableTo", (boolean)false, (String)"return false;", (String)"\n");
        if (isApplicableToBodyContent != null && isApplicableToBodyContent.length() != 0) {
            buf.append(isApplicableToBodyContent);
        }
        buf.append("\n");
        buf.append("}");
        type.createMethod(buf.toString(), null, false, monitor);
        buf.setLength(0);
        String discoveryException = imports.addImport("org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException");
        String progressMonitor = imports.addImport("org.eclipse.core.runtime.IProgressMonitor");
        buf.append("@Override").append("\n");
        buf.append("protected void basicDiscoverElement(final ").append(inputType).append(" source, final ").append(progressMonitor).append(" monitor) throws ").append(discoveryException).append(" {").append("\n");
        String basicDiscoverElementBodyContent = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"basicDiscoverElement", (boolean)false, (String)"", (String)"\n");
        if (basicDiscoverElementBodyContent != null && basicDiscoverElementBodyContent.length() != 0) {
            buf.append(basicDiscoverElementBodyContent);
        }
        buf.append("\n");
        buf.append("}");
        type.createMethod(buf.toString(), null, false, monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private static String maybeRequiresInputValue(boolean required) {
        if (required) {
            return ", requiresInputValue = true";
        }
        return "";
    }

    private static String maybeDescription(String description) {
        if (description.trim().length() == 0) {
            return "";
        }
        return ", description = \"" + description.replaceAll("\"", "\\\"") + "\"";
    }

    private static String maybeArray(boolean multivalued) {
        if (multivalued) {
            return "[]";
        }
        return "";
    }

    protected TableViewer getTableViewerParameters() {
        return this.tableViewerParameters;
    }

    public List<DiscoveryParameterLine> getParameters() {
        return this.fParameters;
    }

    public void preFinishPage() {
        this.fInputType = this.fComboInputType.getText();
        this.fDiscovererName = this.txtDiscovererName.getText();
        this.fRegisterPopupMenu = this.checkboxPopupMenu.getSelection();
        this.fDiscovererLabel = this.fDiscovererLabelText.getText();
    }

    public void finishPage(IProgressMonitor monitor) {
        try {
            this.createType(monitor);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public void parameterDataWasModified() {
        this.handleFieldChanged(PARAMETERS_TABLE);
        this.tableViewerParameters.refresh();
    }

    public String getInputType() {
        return this.fInputType;
    }

    public String getDiscovererName() {
        return this.fDiscovererName;
    }

    public boolean isRegisterPopupMenu() {
        return this.fRegisterPopupMenu;
    }

    public String getDiscovererLabel() {
        return this.fDiscovererLabel;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.setFocusOnContainer();
    }

    public Image getImage() {
        if (this.pageImage == null) {
            this.pageImage = Activator.getImageDescriptor("icons/discoverer_banner.png").createImage();
        }
        return this.pageImage;
    }

    public void dispose() {
        super.dispose();
        if (this.pageImage != null) {
            this.pageImage.dispose();
        }
    }

    protected final class ParametersTableContentProvider
    implements IStructuredContentProvider {
        protected ParametersTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                if (NewDiscovererMainWizardPage.this.checkboxExtendAbstractModelDiscoverer != null && NewDiscovererMainWizardPage.this.checkboxExtendAbstractModelDiscoverer.getSelection()) {
                    List<DiscoveryParameterLine> parameters = AbstractModelDiscovererParameters.getInstance().getParameters();
                    Object[] result = new Object[list.size() + parameters.size()];
                    int i = 0;
                    while (i < list.size()) {
                        result[i] = list.get(i);
                        ++i;
                    }
                    i = 0;
                    while (i < parameters.size()) {
                        result[list.size() + i] = parameters.get(i);
                        ++i;
                    }
                    return result;
                }
                return list.toArray();
            }
            throw new IllegalArgumentException();
        }
    }

    protected static final class ParametersTableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        protected ParametersTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DiscoveryParameterLine) {
                DiscoveryParameterLine discoveryParameterLine = (DiscoveryParameterLine)element;
                switch (columnIndex) {
                    case 0: {
                        return discoveryParameterLine.getName();
                    }
                    case 1: {
                        return discoveryParameterLine.getType();
                    }
                    case 2: {
                        return discoveryParameterLine.getDescription();
                    }
                    case 3: {
                        return discoveryParameterLine.getDirection().toString();
                    }
                    case 4: {
                        if (discoveryParameterLine.getDirection() == DirectionKind.OUT) {
                            return Messages.NewDiscovererMainWizardPage_NA;
                        }
                        return Boolean.toString(discoveryParameterLine.isRequired());
                    }
                    case 5: {
                        return Boolean.toString(discoveryParameterLine.isMultivalued());
                    }
                }
                MoDiscoLogger.logError((String)"unhandled case", (Plugin)Activator.getDefault());
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            if (AbstractModelDiscovererParameters.isInheritedParameter(element)) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

