/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public abstract class VSCodeJSDebugDelegate
extends DSPLaunchDelegate {
    public static final String ARGUMENTS = "args";
    private static final String CWD = "cwd";
    private static final String ENV = "env";
    public static final String RUNTIME_EXECUTABLE = "runtimeExecutable";
    public static final String NODE_DEBUG_CMD = "/js-debug/src/dapDebugServer.js";
    public static final String TYPESCRIPT_CONTENT_TYPE = "org.eclipse.tm4e.language_pack.typescript";
    public static final String JAVACRIPT_CONTENT_TYPE = "org.eclipse.tm4e.language_pack.javascript";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS = "__debuggablePatterns";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS_DEFAULT = "[\"*.js\",\"*.es6\",\"*.jsx\",\"*.mjs\".\"*.cjs\"]";
    private static final String TS_CONFIG_NAME = "tsconfig.json";
    private static final String COMPILER_OPTIONS = "compilerOptions";
    private static final String SOURCE_MAPS = "sourceMaps";
    private static final String OUT_DIR = "outDir";
    private static final String ROOT_DIR = "rootDir";
    protected final String type;
    private static final Pattern BlockCommentPattern = Pattern.compile("(?<!//.*)/\\*(?:.|\\R)*?\\*/");
    private static final Pattern LineCommentPattern = Pattern.compile("\\s*//.*");
    private static final Pattern TrailingCommaPattern = Pattern.compile(",(\\s*)\\}");

    protected VSCodeJSDebugDelegate(String type) {
        this.type = type;
    }

    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File runtimeExecutable;
        String cwd;
        Map env;
        Object[] args;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String program = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("program", ""));
        param.put("program", program);
        param.put("type", this.type);
        param.put("request", "launch");
        param.put("outputCapture", "std");
        String argsString = configuration.getAttribute(ARGUMENTS, "").trim();
        if (!argsString.isEmpty() && (args = Arrays.asList(argsString.split(" ")).stream().filter(s -> !s.trim().isEmpty()).map(s -> {
            try {
                return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
            }
            catch (CoreException e) {
                ILog.get().error(e.getMessage(), (Throwable)e);
                return s;
            }
        }).toArray()).length > 0) {
            param.put(ARGUMENTS, args);
        }
        if (!(env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap())).isEmpty()) {
            JsonObject envJson = new JsonObject();
            for (Map.Entry entry2 : env.entrySet()) {
                envJson.addProperty((String)entry2.getKey(), VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution((String)entry2.getValue()));
            }
            param.put(ENV, envJson);
        }
        if (!(cwd = (cwd = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim()).isEmpty() && program != null && !program.isEmpty() ? new File(program).getParentFile().getAbsolutePath() : VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cwd)).isEmpty()) {
            param.put(CWD, cwd);
        }
        if ((runtimeExecutable = this.computeRuntimeExecutable(configuration)) != null) {
            param.put(RUNTIME_EXECUTABLE, runtimeExecutable.getAbsolutePath());
        }
        if (!this.configureAdditionalParameters(configuration, param)) {
            return;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource(NODE_DEBUG_CMD));
            File file = new File(fileURL.getPath());
            int port = 0;
            try {
                Throwable throwable = null;
                Object var15_18 = null;
                try (ServerSocket serverSocket = new ServerSocket(0);){
                    port = serverSocket.getLocalPort();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            File cwdFile = cwd == null || cwd.isBlank() ? new File(System.getProperty("user.dir")) : new File(cwd);
            HashMap<String, String> processEnv = new HashMap<String, String>(System.getenv());
            processEnv.put("DA_TEST_DISABLE_TELEMETRY", Boolean.TRUE.toString());
            final Process vscodeJsDebugExec = DebugPlugin.exec((String[])new String[]{NodeJSManager.getNodeJsLocation().getAbsolutePath(), file.getAbsolutePath(), Integer.toString(port)}, (File)cwdFile, (String[])((String[])processEnv.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new)), (boolean)false);
            final IProcess vscodeJsDebugIProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)vscodeJsDebugExec, (String)"debug adapter");
            AtomicReference host = new AtomicReference();
            String portSuffix = ":" + port;
            vscodeJsDebugIProcess.getStreamsProxy().getOutputStreamMonitor().addListener((text, mon) -> {
                if (text.toLowerCase().contains("listening")) {
                    String[] stringArray = text.split(" ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String word = stringArray[n2];
                        if ((word = word.trim()).endsWith(portSuffix)) {
                            host.set(word.substring(0, word.length() - portSuffix.length()));
                            return;
                        }
                        ++n2;
                    }
                }
            });
            Instant request = Instant.now();
            while (host.get() == null && Duration.between(request, Instant.now()).compareTo(Duration.ofSeconds(3L)) < 3) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setAttachDebugAdapter((String)host.get(), port);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
            IDebugEventSetListener shutdownParentOnCompletion = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    if (Arrays.stream(events).anyMatch(event -> {
                        IDebugTarget target;
                        Object object;
                        return event.getKind() == 8 && (object = event.getSource()) instanceof IDebugTarget && (target = (IDebugTarget)object).getLaunch() == launch;
                    }) && Arrays.stream(launch.getDebugTargets()).allMatch(ITerminate::isTerminated) && List.of(vscodeJsDebugIProcess).equals(Arrays.stream(launch.getProcesses()).filter(Predicate.not(ITerminate::isTerminated)).toList())) {
                        try {
                            vscodeJsDebugIProcess.terminate();
                        }
                        catch (DebugException ex) {
                            vscodeJsDebugExec.destroy();
                        }
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
            };
            DebugPlugin.getDefault().addDebugEventListener(shutdownParentOnCompletion);
        }
        catch (IOException ex) {
            LanguageServerPlugin.logError((Throwable)ex);
        }
    }

    protected File computeRuntimeExecutable(ILaunchConfiguration configuration) {
        return NodeJSManager.getNodeJsLocation();
    }

    protected boolean configureAdditionalParameters(ILaunchConfiguration config, Map<String, Object> param) throws CoreException {
        String program = (String)param.get("program");
        String cwd = (String)param.get(CWD);
        if (program == null) {
            return false;
        }
        File programFile = new File(program);
        param.put(SOURCE_MAPS, true);
        if (Platform.getContentTypeManager().getContentType(TYPESCRIPT_CONTENT_TYPE).isAssociatedWith(programFile.getName())) {
            String string;
            String string2;
            HashMap co;
            File parentDirectory = cwd == null ? programFile.getParentFile() : new File(cwd);
            File tsConfigFile = this.findTSConfigFile(parentDirectory);
            if (tsConfigFile != null && tsConfigFile.exists()) {
                parentDirectory = tsConfigFile.getParentFile();
            }
            String errorMessage = null;
            Map<String, Object> tsConfig = this.readJSonFile(tsConfigFile);
            HashMap hashMap = co = tsConfig == null ? null : (HashMap)tsConfig.get(COMPILER_OPTIONS);
            if (co == null) {
                errorMessage = Messages.NodeDebug_TSConfirError_NoTsConfig;
                co = new HashMap();
            }
            boolean outDirOrFileIsSet = false;
            Object v = co.get(OUT_DIR);
            if (v instanceof String) {
                String o = (String)v;
                string2 = o.trim();
            } else {
                string2 = null;
            }
            String outDir = string2;
            File outDirFile = parentDirectory;
            if (outDir != null && outDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                outDirFile = new File(parentDirectory, outDir);
                try {
                    outDir = outDirFile.getCanonicalPath();
                }
                catch (IOException e) {
                    outDir = outDirFile.getAbsolutePath();
                }
                outDirOrFileIsSet = true;
                param.put("outFiles", List.of(outDirFile.getAbsolutePath() + "/**/*.js"));
                Path jsFile = outDirFile.toPath().resolve(tsConfigFile.getParentFile().toPath().relativize(programFile.toPath().getParent().resolve(this.toJS(programFile.getName()))));
                param.put("program", jsFile.toString());
            }
            param.put("rootPath", tsConfigFile.getParentFile().getAbsolutePath());
            Object v2 = co.get(ROOT_DIR);
            if (v2 instanceof String) {
                String o = (String)v2;
                string = o.trim();
            } else {
                string = null;
            }
            String rootDir = string;
            File rootDirFile = parentDirectory;
            if (rootDir != null && rootDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                rootDirFile = new File(parentDirectory, rootDir);
                try {
                    rootDir = rootDirFile.getCanonicalPath();
                }
                catch (IOException e) {
                    rootDir = rootDirFile.getAbsolutePath();
                }
                param.put(ROOT_DIR, rootDir);
                param.put("rootPath", rootDir);
            }
            Path jsFile = outDirFile.toPath().resolve(rootDirFile.toPath().relativize(programFile.toPath().getParent().resolve(this.toJS(programFile.getName()))));
            param.put("program", jsFile.toString());
            if (!outDirOrFileIsSet && errorMessage == null) {
                errorMessage = Messages.NodeDebug_TSConfigError_OutDirIsNotSet;
            }
            if (errorMessage != null) {
                int[] result = new int[1];
                String dialogMessage = errorMessage;
                String editTSConfig = tsConfigFile.exists() && tsConfigFile.isFile() ? Messages.NodeDebug_TSConfirError_OpenTSConfigInEditor : Messages.NodeDebug_TSConfirError_CreateAndOpenTSConfigInEditor;
                final File directory = parentDirectory;
                Display.getDefault().syncExec(() -> {
                    MessageDialog dialog = new MessageDialog(DebugUIPlugin.getShell(), Messages.NodeDebug_TSConfirError_Title, null, dialogMessage, 6, 2, new String[]{editTSConfig, Messages.NodeDebug_TSConfirError_StartDebuggingAsIs, Messages.NodeDebug_TSConfirError_Cancel});
                    nArray[0] = dialog.open();
                });
                if (result[0] == 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IFile file = this.createNewEmptyFile(new File(directory, VSCodeJSDebugDelegate.TS_CONFIG_NAME));
                            if (file != null) {
                                try {
                                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileEditorInput(file), (String)"org.eclipse.ui.genericeditor.GenericEditor", (boolean)true);
                                }
                                catch (PartInitException e1) {
                                    ILog.get().error(e1.getMessage(), (Throwable)e1);
                                }
                            }
                        }

                        private IFile createNewEmptyFile(File fsFile) {
                            IWorkspace ws = ResourcesPlugin.getWorkspace();
                            IWorkspaceRoot wr = ws.getRoot();
                            IFile file = wr.getFileForLocation(IPath.fromFile((File)fsFile));
                            if (!file.exists() || !file.isAccessible()) {
                                IFile[] result = new IFile[1];
                                try {
                                    ws.run(monitor -> {
                                        iFileArray[0] = null;
                                        try {
                                            this.createContainers((IResource)file);
                                            file.create(new byte[0], true, false, null);
                                            file.refreshLocal(0, null);
                                            iFileArray[0] = file;
                                        }
                                        catch (CoreException e) {
                                            ILog.get().error(e.getMessage(), (Throwable)e);
                                        }
                                    }, null);
                                }
                                catch (CoreException e) {
                                    ILog.get().error(e.getMessage(), (Throwable)e);
                                }
                                return result[0];
                            }
                            return file;
                        }

                        void createContainers(IResource resource) throws CoreException {
                            IFolder parent;
                            IContainer container = resource.getParent();
                            if (container instanceof IFolder && !(parent = (IFolder)container).exists()) {
                                this.createContainers((IResource)parent);
                                parent.create(false, true, null);
                            }
                        }
                    });
                } else if (result[0] == 1) {
                    return true;
                }
                return false;
            }
            return true;
        }
        if (Platform.getContentTypeManager().getContentType(JAVACRIPT_CONTENT_TYPE).isAssociatedWith(programFile.getName())) {
            param.put(SOURCE_MAPS, false);
            param.put(JAVACRIPT_DEBUGGABLE_PATTERNS, JAVACRIPT_DEBUGGABLE_PATTERNS_DEFAULT);
            return true;
        }
        return true;
    }

    private String toJS(String name) {
        return name.endsWith(".js") ? name : name.substring(0, name.length() - 2) + "js";
    }

    private File findTSConfigFile(File parentDirectory) {
        do {
            File tsConfigFile;
            if (!(tsConfigFile = new File(parentDirectory, TS_CONFIG_NAME)).isFile()) continue;
            return tsConfigFile;
        } while ((parentDirectory = parentDirectory.getParentFile()) != null && parentDirectory.isDirectory());
        return null;
    }

    private String getSanitisedTSConfigForGson(String tsConfgContent) {
        tsConfgContent = BlockCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = LineCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = TrailingCommaPattern.matcher(tsConfgContent).replaceAll("$1}");
        return tsConfgContent;
    }

    public Map<String, Object> readJSonFile(File tsConfgFile) {
        if (tsConfgFile == null || !tsConfgFile.isFile()) {
            return Map.of();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(tsConfgFile));){
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append('\n');
                }
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                return (Map)new Gson().fromJson(this.getSanitisedTSConfigForGson(response.toString()), type);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Map.of();
        }
    }
}

