/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.markdown.ui.preferences;

import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public final class MarkdownPreferences {
    private static final String MD_SECTION = "markdown";
    static final String MD_SERVER_LOG = "markdown.server.log";
    static final String MD_OCCURRENCES_HIGHLIGHT_ENABLED = "markdown.occurrencesHighlight.enabled";
    static final String MD_PREFERRED_MD_PATH_EXTENSION_STYLE = "markdown.preferredMdPathExtensionStyle";
    static final String MD_SUGGEST_PATHS_ENABLED = "markdown.suggest.paths.enabled";
    static final String MD_SUGGEST_PATHS_INCLUDE_WKS_HEADER_COMPLETIONS = "markdown.suggest.paths.includeWorkspaceHeaderCompletions";
    static final String MD_SUGGEST_PATHS_EXCLUDE_GLOBS = "markdown.suggest.paths.excludeGlobs";
    private static final String MD_VADLIDATE_SECTION = "markdown.validate";
    static final String MD_VALIDATE_ENABLED = "markdown.validate.enabled";
    static final String MD_VALIDATE_REFERENCE_LINKS_ENABLED = "markdown.validate.referenceLinks.enabled";
    static final String MD_VALIDATE_FRAGMENT_LINKS_ENABLED = "markdown.validate.fragmentLinks.enabled";
    static final String MD_VALIDATE_FILE_LINKS_ENABLED = "markdown.validate.fileLinks.enabled";
    static final String MD_VALIDATE_FILE_LINKS_MARKDOWN_FRAGMENT_LINKS = "markdown.validate.fileLinks.markdownFragmentLinks";
    static final String MD_VALIDATE_IGNORED_LINKS = "markdown.validate.ignoredLinks";
    static final String MD_VALIDATE_UNUSED_LINK_DEFS_ENABLED = "markdown.validate.unusedLinkDefinitions.enabled";
    static final String MD_VALIDATE_DUPLICATE_LINK_DEFS_ENABLED = "markdown.validate.duplicateLinkDefinitions.enabled";

    public static Settings getGlobalSettings() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Settings settings = new Settings(store);
        settings.fillAsString(MD_SERVER_LOG);
        settings.fillAsBoolean(MD_OCCURRENCES_HIGHLIGHT_ENABLED);
        settings.fillAsString(MD_PREFERRED_MD_PATH_EXTENSION_STYLE);
        settings.fillAsBoolean(MD_SUGGEST_PATHS_ENABLED);
        settings.fillSetting(MD_SUGGEST_PATHS_INCLUDE_WKS_HEADER_COMPLETIONS, store.getString(MD_SUGGEST_PATHS_INCLUDE_WKS_HEADER_COMPLETIONS));
        settings.fillAsBoolean(MD_VALIDATE_ENABLED);
        settings.fillAsString(MD_VALIDATE_REFERENCE_LINKS_ENABLED);
        settings.fillAsString(MD_VALIDATE_FRAGMENT_LINKS_ENABLED);
        settings.fillAsString(MD_VALIDATE_FILE_LINKS_ENABLED);
        settings.fillAsString(MD_VALIDATE_FILE_LINKS_MARKDOWN_FRAGMENT_LINKS);
        String rawIgnored = store.getString(MD_VALIDATE_IGNORED_LINKS);
        if (rawIgnored == null || rawIgnored.trim().isEmpty()) {
            settings.fillSetting(MD_VALIDATE_IGNORED_LINKS, new String[0]);
        } else {
            String[] globs = (String[])Arrays.stream(rawIgnored.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
            settings.fillSetting(MD_VALIDATE_IGNORED_LINKS, globs);
        }
        settings.fillAsString(MD_VALIDATE_UNUSED_LINK_DEFS_ENABLED);
        settings.fillAsString(MD_VALIDATE_DUPLICATE_LINK_DEFS_ENABLED);
        return settings;
    }

    public static String[] getSuggestPathsExcludeGlobs() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String raw = store.getString(MD_SUGGEST_PATHS_EXCLUDE_GLOBS);
        if (raw == null || raw.trim().isEmpty()) {
            return new String[0];
        }
        return (String[])Arrays.stream(raw.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }

    public static boolean isMatchMarkdownSection(String section) {
        return Settings.isMatchSection(section, MD_SECTION);
    }

    private MarkdownPreferences() {
    }

    static enum IncludeWorkspaceHeaderCompletions {
        never("Never"),
        onSingleOrDoubleHash("On single or double '#'"),
        onDoubleHash("Only on double '##'");

        final String value = this.toString();
        final String label;

        private IncludeWorkspaceHeaderCompletions(String label) {
            this.label = label;
        }
    }

    static enum PreferredMdPathExtensionStyle {
        auto("Auto"),
        includeExtension("Include .md extension"),
        removeExtension("Remove .md extension");

        final String value = this.toString();
        final String label;

        private PreferredMdPathExtensionStyle(String label) {
            this.label = label;
        }
    }

    static enum ServerLog {
        off("Off"),
        debug("Debug"),
        trace("Trace");

        final String value = this.toString();
        final String label;

        private ServerLog(String label) {
            this.label = label;
        }
    }

    static enum ValidateEnabled {
        ignore("Ignore"),
        warning("Warning"),
        error("Error"),
        hint("Hint");

        final String value = this.toString();
        final String label;

        private ValidateEnabled(String label) {
            this.label = label;
        }
    }

    static enum ValidateEnabledForFragmentLinks {
        ignore("Ignore"),
        warning("Warning"),
        error("Error"),
        hint("Hint"),
        inherit("Inherit");

        final String value = this.toString();
        final String label;

        private ValidateEnabledForFragmentLinks(String label) {
            this.label = label;
        }
    }
}

