/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.strategy;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.core.set.constraint.MemberConstraint;
import org.eclipse.jst.jsf.core.set.mapping.ElementToTagIdentifierMapping;
import org.eclipse.jst.jsf.core.tagmatcher.EvaluationException;
import org.eclipse.jst.jsf.core.tagmatcher.InvalidExpressionException;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.validation.internal.AbstractXMLViewValidationStrategy;
import org.eclipse.jst.jsf.validation.internal.JSFValidationContext;
import org.eclipse.jst.jsf.validation.internal.constraints.ContainsTagConstraint;
import org.eclipse.jst.jsf.validation.internal.constraints.TagId;
import org.eclipse.jst.jsf.validation.internal.constraints.TagSet;
import org.eclipse.jst.jsf.validation.internal.strategy.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.strategy.Messages;
import org.w3c.dom.Node;

public class ContainmentValidatingStrategy
extends AbstractXMLViewValidationStrategy {
    public static final String ID = "org.eclipse.jst.jsf.validation.strategy.ElementValidatingStrategy";
    private static final String DISPLAY_NAME = Messages.ContainmentValidatingStrategy_DisplayName;
    private static final ElementToTagIdentifierMapping elem2TagIdMapper = new ElementToTagIdentifierMapping();
    private static final String ENABLE_CONTAINMENT_VALIDATION_KEY = "jsfCoreEnableContainmentValidation";
    private int _containmentValidationCount;
    private final JSFValidationContext _jsfValidationContext;
    private boolean _enabled;

    public ContainmentValidatingStrategy(JSFValidationContext jsfValidationContext) {
        super(ID, DISPLAY_NAME);
        this._jsfValidationContext = jsfValidationContext;
        this._enabled = ContainmentValidatingStrategy.isEnabled();
    }

    @Override
    public boolean isInteresting(DOMAdapter domAdapter) {
        return domAdapter instanceof Region2ElementAdapter;
    }

    @Override
    public void validate(DOMAdapter domAdapter) {
        if (this._enabled && domAdapter instanceof Region2ElementAdapter) {
            Region2ElementAdapter elementAdapter = (Region2ElementAdapter)domAdapter;
            this.validateContainment(elementAdapter, this._jsfValidationContext);
        }
    }

    public static boolean isEnabled() {
        String res = System.getProperty(ENABLE_CONTAINMENT_VALIDATION_KEY);
        if (res == null) {
            res = System.getenv(ENABLE_CONTAINMENT_VALIDATION_KEY);
        }
        return res != null;
    }

    private void validateContainment(Region2ElementAdapter elementAdapter, JSFValidationContext jsfValidationContext) {
        Trait trait;
        if (JSPUtil.isJSPFragment((IFile)jsfValidationContext.getFile()) || this._containmentValidationCount > 0) {
            return;
        }
        IStructuredDocumentContext context = elementAdapter.getDocumentContext();
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node node = resolver.getNode();
        String uri = elementAdapter.getNamespace();
        String tagName = elementAdapter.getLocalName();
        IMetaDataDomainContext mdcontext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(jsfValidationContext.getFile());
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(mdcontext);
        Entity entity = query.getQueryHelper().getEntity(uri, tagName);
        if (entity != null && (trait = query.findTrait(entity, "containment-constraint")) != null) {
            ContainsTagConstraint tagConstraint = (ContainsTagConstraint)trait.getValue();
            String algorithm = tagConstraint.getSetGenerator().getAlgorithm();
            if (!"xpath".equals(algorithm)) {
                return;
            }
            String expr = tagConstraint.getSetGenerator().getExpression();
            XPathMatchingAlgorithm xpathAlg = new XPathMatchingAlgorithm(expr);
            AxiomaticSet set = null;
            try {
                set = xpathAlg.evaluate(node);
                set = elem2TagIdMapper.map(set);
            }
            catch (InvalidExpressionException e) {
                JSFCorePlugin.log(e, "Problem with expression: " + expr + " on node " + String.valueOf(node));
                return;
            }
            catch (EvaluationException e) {
                JSFCorePlugin.log(e, "Problem evaluating expression: " + expr + " on node " + String.valueOf(node));
                return;
            }
            TagSet constraintData = tagConstraint.getSatisfiesSet();
            ConcreteAxiomaticSet constraintSet = new ConcreteAxiomaticSet();
            for (TagId tagId : constraintData.getTags()) {
                constraintSet.add((Object)TagIdentifierFactory.createJSPTagWrapper(tagId.getUri(), tagId.getName()));
            }
            MemberConstraint memberConstraint = new MemberConstraint((AxiomaticSet)constraintSet);
            Diagnostic diag = memberConstraint.isSatisfied(set);
            if (diag.getSeverity() != 0) {
                ++this._containmentValidationCount;
                List data = diag.getData();
                for (TagIdentifier missingParent : data) {
                    this.reportContainmentProblem(context, node, missingParent);
                }
            }
        }
    }

    private void reportContainmentProblem(IStructuredDocumentContext context, Node node, TagIdentifier missingParent) {
        Diagnostic diagnostic = null;
        diagnostic = missingParent.equals((Object)IJSFConstants.TAG_IDENTIFIER_VIEW) ? DiagnosticFactory.create_CONTAINMENT_ERROR_MISSING_VIEW(node.getNodeName()) : (missingParent.equals((Object)IJSFConstants.TAG_IDENTIFIER_FORM) ? DiagnosticFactory.create_CONTAINMENT_ERROR_MISSING_FORM(node.getNodeName()) : DiagnosticFactory.create_CONTAINMENT_ERROR_MISSING_ANCESTOR(node.getNodeName(), missingParent));
        int start = context.getDocumentPosition() + 1;
        int length = node.getNodeName().length();
        this._jsfValidationContext.getReporter().report(diagnostic, start, length);
    }
}

