/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMarkerResolutionGenerator;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.part.FileEditorInput;

public class APTCompileProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        return id == 900;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList completionProposals;
        AssistContext invocationContext;
        IStatus status;
        IProblemLocation problemLocation;
        FileEditorInput editorInput;
        if (!this.hasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        ICompilationUnit compilationUnit = this.getCompilationUnit(marker);
        if (compilationUnit != null && (editorInput = new FileEditorInput((IFile)compilationUnit.getResource())) != null && (problemLocation = this.createProblemLocation(marker)) != null && (status = JavaCorrectionProcessor.collectCorrections((IInvocationContext)(invocationContext = new AssistContext(compilationUnit, problemLocation.getOffset(), problemLocation.getLength())), (IProblemLocation[])new IProblemLocation[]{problemLocation}, completionProposals = new ArrayList())).isOK()) {
            Collections.sort(completionProposals, new CompletionProposalComparator());
            IMarkerResolution[] markerResolutions = new IMarkerResolution[completionProposals.size()];
            int i = 0;
            while (i < completionProposals.size()) {
                markerResolutions[i] = new CorrectionMarkerResolutionGenerator.CorrectionMarkerResolution(compilationUnit, problemLocation.getOffset(), problemLocation.getLength(), (IJavaCompletionProposal)completionProposals.get(i), marker);
                ++i;
            }
            return markerResolutions;
        }
        return NO_RESOLUTIONS;
    }

    private IProblemLocation createProblemLocation(IMarker marker) {
        try {
            int id = marker.getAttribute("id", -1);
            int offset = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            String markerType = marker.getType();
            if (id != -1 && offset != -1 && end != -1 && arguments != null) {
                int length = end - offset;
                boolean isError = severity == 2;
                return new ProblemLocation(offset, length, id, arguments, isError, markerType);
            }
        }
        catch (CoreException ce) {
            JAXWSUIPlugin.log(ce.getStatus());
        }
        return null;
    }

    private ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement javaElement;
        IResource resource = marker.getResource();
        if (resource instanceof IFile && resource.isAccessible() && (javaElement = JavaCore.create((IFile)((IFile)resource))) != null && javaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)javaElement;
        }
        return null;
    }
}

