/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.common.TraceWorkbenchPart;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.editor.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.EObjectNode;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

public class TraceEditorPart
extends EditorPart
implements IGotoMarker {
    private final TraceWorkbenchPart myTraceWorkbenchPart = new TraceWorkbenchPart((IWorkbenchPart)this);
    private Trace myTrace;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(NLS.bind((String)Messages.TraceEditorPart_InvalidInput, (Object)input));
        }
        IFileEditorInput inp = (IFileEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.setInput(input);
        this.myTrace = this.initTrace(inp.getFile());
    }

    public void createPartControl(Composite parent) {
        this.myTraceWorkbenchPart.createPartControl(parent);
        this.myTraceWorkbenchPart.setInput(this.myTrace);
    }

    public void setFocus() {
        if (!this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().setFocus();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public TreeViewer getViewer() {
        return this.myTraceWorkbenchPart.getViewer();
    }

    public void gotoMarker(IMarker marker) {
        try {
            EObject eObject;
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.m2m.qvt.oml.project.QVTOProblem") && (uriAttribute = marker.getAttribute("uri", null)) != null && (eObject = this.myTrace.eResource().getEObject(uriAttribute)) != null) {
                this.myTraceWorkbenchPart.setSelection(new EObjectNode((Object)eObject.eContainer(), eObject));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private Trace initTrace(IFile file) throws PartInitException {
        EObject traceObj;
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl mappingAwareRS = CompiledUnit.createResourceSet();
        CompilerUtils.addMappingsToResourceSet((ResourceSet)mappingAwareRS, (URI)uri);
        ModelContent traceModel = EmfUtil.loadModel((URI)uri, (ResourceSet)mappingAwareRS);
        EObject eObject = traceObj = traceModel != null && !traceModel.getContent().isEmpty() ? (EObject)traceModel.getContent().get(0) : null;
        if (!(traceObj instanceof Trace)) {
            throw new PartInitException(NLS.bind((String)Messages.TraceEditorPart_LoadingFailed, (Object)file.getFullPath()));
        }
        return (Trace)traceObj;
    }
}

