/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.AbstractGenericAdapter;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;

public class ModelParameterExtent {
    private static final int INITIAL_EXTENT_SIZE = 150;
    private int myCountAddedAfterPurge = 0;
    private int myPurgeLimitSize = 150;
    private static int ourExtentId = 0;
    private final List<EObject> myInitialEObjects;
    private final List<EObject> myAdditionalEObjects;
    private final ModelParameter myModelParameter;
    private final Map<EObject, EObject> myInitialObj2ContainerMap;
    private final ReadonlyExtentAdapter myReadonlyAdapter;
    private final Set<EObject> myResourceAdditionalEObjects;
    private final ResourceModificationAdapter myResourceAdapter;
    private final Set<Resource> myResourceInstalledAdapters;
    private Resource myInMemoryResource;
    private ResourceSet myResourceSet;

    public ModelParameterExtent() {
        this((ResourceSet)null);
    }

    public ModelParameterExtent(ResourceSet rs) {
        this(Collections.emptyList(), rs, null);
    }

    public ModelParameterExtent(ModelParameterExtent extentToCopy) {
        this(new ArrayList<EObject>(EcoreUtil.copyAll(extentToCopy.getRootObjects())), extentToCopy.getResourceSet(), extentToCopy.getModelParameter());
    }

    public ModelParameterExtent(List<EObject> initialEObjs, ResourceSet rs, ModelParameter modelParameter) {
        this.myResourceSet = rs;
        this.myInitialEObjects = new ArrayList<EObject>(initialEObjs);
        this.myAdditionalEObjects = new ArrayList<EObject>(150);
        this.myModelParameter = modelParameter;
        this.myReadonlyAdapter = this.isReadonly() ? new ReadonlyExtentAdapter() : null;
        this.myResourceAdditionalEObjects = !this.isReadonly() ? new LinkedHashSet() : Collections.emptySet();
        this.myResourceAdapter = !this.isReadonly() ? new ResourceModificationAdapter() : null;
        this.myResourceInstalledAdapters = !this.isReadonly() ? new HashSet() : Collections.emptySet();
        Map<EObject, EObject> containerMap = null;
        for (EObject nextInitialRoot : this.myInitialEObjects) {
            if (nextInitialRoot.eContainer() == null) continue;
            if (containerMap == null) {
                containerMap = new HashMap();
            }
            containerMap.put(nextInitialRoot, nextInitialRoot.eContainer());
        }
        Map<EObject, EObject> map = this.myInitialObj2ContainerMap = containerMap != null ? containerMap : Collections.emptyMap();
        if (this.isReadonly()) {
            for (EObject eObj : this.myInitialEObjects) {
                eObj.eAdapters().add((Object)this.myReadonlyAdapter);
            }
        } else {
            for (EObject eObject : this.myInitialEObjects) {
                if (eObject.eResource() == null) {
                    this.getInMemoryResource(true).getContents().add((Object)eObject);
                    continue;
                }
                eObject.eResource().eAdapters().add((Object)this.myResourceAdapter);
                this.myResourceInstalledAdapters.add(eObject.eResource());
                eObject.eResource().eSetDeliver(true);
            }
        }
    }

    private Resource getInMemoryResource(boolean createOnDemand) {
        if (this.myInMemoryResource == null) {
            if (!createOnDemand) {
                return null;
            }
            this.myInMemoryResource = new ExtentResource();
            if (this.myResourceSet == null) {
                for (EObject obj : this.myInitialEObjects) {
                    if (obj.eResource() == null || obj.eResource().getResourceSet() == null) continue;
                    this.myResourceSet = obj.eResource().getResourceSet();
                    break;
                }
            }
            if (this.myResourceSet != null) {
                this.myResourceSet.getResources().add((Object)this.myInMemoryResource);
            }
        }
        return this.myInMemoryResource;
    }

    private ResourceSet getResourceSet() {
        return this.myResourceSet;
    }

    private ModelParameter getModelParameter() {
        return this.myModelParameter;
    }

    public static ModelParameter getReadonlyModelParameter(EObject eObj) {
        EObject auxParent = eObj;
        while (auxParent != null) {
            Adapter adapter = EcoreUtil.getAdapter((List)auxParent.eAdapters(), ReadonlyExtentAdapter.class);
            if (adapter != null) {
                return ((ReadonlyExtentAdapter)adapter).getModelParameter();
            }
            auxParent = auxParent.eContainer();
        }
        return null;
    }

    public void addObject(EObject eObject) {
        if (eObject != null) {
            this.myAdditionalEObjects.add(eObject);
            if (eObject.eResource() == null) {
                this.getInMemoryResource(true).getContents().add((Object)eObject);
            }
            if (++this.myCountAddedAfterPurge >= this.myPurgeLimitSize) {
                this.purgeContents(this.myAdditionalEObjects, true);
                this.myCountAddedAfterPurge = 0;
                this.myPurgeLimitSize = Math.max(this.myAdditionalEObjects.size(), 150);
            }
        }
    }

    public List<EObject> getInitialObjects() {
        return this.myInitialEObjects;
    }

    public List<EObject> getRootObjects() {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EObject eObj : this.myInitialEObjects) {
            EObject eContainer = eObj.eContainer();
            if (eContainer != null && eContainer != this.myInitialObj2ContainerMap.get(eObj)) continue;
            objects.add(eObj);
        }
        for (EObject eObj : this.myAdditionalEObjects) {
            if (eObj.eContainer() != null) continue;
            objects.add(eObj);
        }
        return objects;
    }

    public List<Object> getAllObjects() {
        this.purgeContents();
        ArrayList<Object> objects = new ArrayList<Object>();
        ModelParameterExtent.getAllObjects(this.myInitialEObjects, objects);
        ModelParameterExtent.getAllObjects(this.myAdditionalEObjects, objects);
        return objects;
    }

    private static void getAllObjects(Collection<EObject> rootObjs, Collection<Object> result) {
        for (EObject nextRoot : rootObjs) {
            result.add(nextRoot);
            TreeIterator iterContents = EcoreUtil.getAllContents((EObject)nextRoot, (boolean)true);
            while (iterContents.hasNext()) {
                result.add(iterContents.next());
            }
        }
    }

    public ModelExtentContents getContents() {
        this.purgeContents();
        LinkedHashSet<EObject> initialObjects = new LinkedHashSet<EObject>(this.myInitialEObjects);
        LinkedHashSet<EObject> allRootObjects = new LinkedHashSet<EObject>(this.myInitialEObjects);
        allRootObjects.addAll(this.myAdditionalEObjects);
        for (EObject obj : this.myResourceAdditionalEObjects) {
            if (obj.eContainer() != null) continue;
            allRootObjects.add(obj);
        }
        for (EObject obj : allRootObjects) {
            if (!(((InternalEObject)obj).eDirectResource() instanceof ExtentResource)) continue;
            ((InternalEObject)obj).eSetResource(null, null);
        }
        if (this.myInMemoryResource != null && this.myInMemoryResource.getResourceSet() != null) {
            this.myInMemoryResource.getResourceSet().getResources().remove((Object)this.myInMemoryResource);
            this.myInMemoryResource = null;
        }
        return new ExtentContents(new ArrayList<EObject>(initialObjects), new ArrayList<EObject>(allRootObjects));
    }

    public boolean removeElement(EObject element) {
        this.purgeContents();
        ModelParameterExtent.delete(this.getRootObjects(), element);
        if (!this.myInitialEObjects.remove(element)) {
            this.myAdditionalEObjects.remove(element);
            this.myPurgeLimitSize = Math.max(this.myAdditionalEObjects.size(), 150);
        }
        this.myResourceAdditionalEObjects.remove(element);
        return true;
    }

    public String toString() {
        return this.myInitialEObjects.isEmpty() ? super.toString() : this.myInitialEObjects.toString();
    }

    private void dispose() {
        Adapter adapter;
        if (this.isReadonly()) {
            for (EObject eObj : this.myInitialEObjects) {
                adapter = EcoreUtil.getAdapter((List)eObj.eAdapters(), ReadonlyExtentAdapter.class);
                if (adapter == null) continue;
                eObj.eAdapters().remove((Object)adapter);
            }
        }
        for (Resource res : this.myResourceInstalledAdapters) {
            adapter = EcoreUtil.getAdapter((List)res.eAdapters(), ResourceModificationAdapter.class);
            if (adapter == null) continue;
            res.eAdapters().remove((Object)adapter);
        }
    }

    public void cleanup() {
        this.dispose();
        if (this.myInMemoryResource != null && this.myInMemoryResource.getResourceSet() != null) {
            this.myInMemoryResource.getResourceSet().getResources().remove((Object)this.myInMemoryResource);
            this.myInMemoryResource = null;
        }
    }

    public boolean isReadonly() {
        return this.myModelParameter != null && this.myModelParameter.getKind() == DirectionKind.IN;
    }

    private void purgeContents() {
        this.purgeContents(this.myInitialEObjects, false);
        this.purgeContents(this.myAdditionalEObjects, true);
    }

    private void purgeContents(List<EObject> elements, boolean isResetResource) {
        int resultSize;
        ArrayList<EObject> result = null;
        for (EObject nextElement : elements) {
            EObject eContainer = nextElement.eContainer();
            if (eContainer == null || elements == this.myInitialEObjects && eContainer == this.myInitialObj2ContainerMap.get(nextElement)) {
                if (result == null) {
                    result = new ArrayList<EObject>(elements.size());
                }
                result.add(nextElement);
                continue;
            }
            InternalEObject internElement = (InternalEObject)nextElement;
            if (!isResetResource || !(internElement.eDirectResource() instanceof ExtentResource)) continue;
            internElement.eSetResource(null, null);
        }
        int n = resultSize = result != null ? result.size() : 0;
        if (elements.size() != resultSize) {
            elements.clear();
            if (result != null) {
                elements.addAll((Collection<EObject>)result);
            }
        }
    }

    private static void delete(List<EObject> rootEObjects, EObject eObject) {
        HashSet<Object> eObjects = new HashSet<Object>();
        HashSet<InternalEObject> crossResourceEObjects = new HashSet<InternalEObject>();
        eObjects.add(eObject);
        TreeIterator j = eObject.eAllContents();
        while (j.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)j.next();
            if (internalEObject.eDirectResource() != null) {
                crossResourceEObjects.add(internalEObject);
                continue;
            }
            eObjects.add(internalEObject);
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll(eObjects, rootEObjects);
        for (Map.Entry entry : usages.entrySet()) {
            EObject deletedEObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                if (eObjects.contains(setting.getEObject()) || !setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)deletedEObject);
            }
        }
        EcoreUtil.remove((EObject)eObject);
        for (EObject eObject2 : crossResourceEObjects) {
            EcoreUtil.remove((EObject)eObject2.eContainer(), (EStructuralFeature)eObject2.eContainmentFeature(), (Object)eObject2);
        }
    }

    private static class ExtentContents
    implements ModelExtentContents {
        private final List<EObject> myInitialObjects;
        private final List<EObject> myRootObjects;

        private ExtentContents(List<EObject> initialObjects, List<EObject> allRootObjects) {
            this.myInitialObjects = Collections.unmodifiableList(initialObjects);
            this.myRootObjects = Collections.unmodifiableList(allRootObjects);
        }

        @Override
        public List<EObject> getInitialElements() {
            return this.myInitialObjects;
        }

        @Override
        public List<EObject> getAllRootElements() {
            return this.myRootObjects;
        }
    }

    private class ExtentResource
    extends ResourceImpl {
        ExtentResource() {
            StringBuilder stringBuilder = new StringBuilder("extent:/");
            int n = ourExtentId + 1;
            ourExtentId = n;
            this.setURI(URI.createURI((String)stringBuilder.append(n).toString()));
            this.setTrackingModification(false);
            this.eAdapters().add((Object)ModelParameterExtent.this.myResourceAdapter);
            ModelParameterExtent.this.myResourceInstalledAdapters.add(this);
        }

        public boolean eNotificationRequired() {
            return !ModelParameterExtent.this.isReadonly();
        }

        public EList<EObject> getContents() {
            if (this.contents == null) {
                this.contents = new ContentsImpl();
            }
            return this.contents;
        }

        private class ContentsImpl
        extends ResourceImpl.ContentsEList<EObject> {
            private static final long serialVersionUID = 2958909849409879855L;

            private ContentsImpl() {
                super((ResourceImpl)ExtentResource.this);
            }

            protected boolean isUnique() {
                return false;
            }
        }
    }

    private class ReadonlyExtentAdapter
    extends AbstractGenericAdapter<ReadonlyExtentAdapter> {
        private ReadonlyExtentAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return ReadonlyExtentAdapter.class == type;
        }

        public ModelParameter getModelParameter() {
            return ModelParameterExtent.this.myModelParameter;
        }
    }

    private class ResourceModificationAdapter
    extends AbstractGenericAdapter<ResourceModificationAdapter> {
        private ResourceModificationAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return ResourceModificationAdapter.class == type;
        }

        @Override
        public void notifyChanged(Notification notification) {
            Object newValue = notification.getNewValue();
            if (notification.getEventType() == 3 && newValue instanceof EObject) {
                ModelParameterExtent.this.myResourceAdditionalEObjects.add((EObject)newValue);
            }
        }
    }
}

