/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.ui.dialogs.QuerySelectionDialog;
import org.eclipse.modisco.infra.query.ui.filters.QueryScopeFilter;
import org.eclipse.swt.widgets.Shell;

public class SelectQueryAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public SelectQueryAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.SelectQueryAction_addQueryOnElement);
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        Shell shell = this.browserActionBarContributor.getBrowser().getSite().getShell();
        ArrayList<EObject> selectedModelElements = new ArrayList<EObject>();
        ISelection selection = this.browserActionBarContributor.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof ModelElementItem)) continue;
                ModelElementItem item = (ModelElementItem)selectedElement;
                selectedModelElements.add(item.getEObject());
            }
            ArrayList<QueryScopeFilter> filters = new ArrayList<QueryScopeFilter>();
            for (EObject eObject : selectedModelElements) {
                filters.add(new QueryScopeFilter(eObject.eClass()));
            }
            QuerySelectionDialog querySelectionDialog = new QuerySelectionDialog(shell, true, null, filters);
            if (querySelectionDialog.open() == 0) {
                List selectedQueries = querySelectionDialog.getSelectedQueries();
                SelectedQueriesManager selectedQueriesManager = this.browserActionBarContributor.getBrowser().getBrowserConfiguration().getSelectedQueriesManager();
                for (EObject eObject : selectedModelElements) {
                    for (ModelQuery selectedQuery : selectedQueries) {
                        selectedQueriesManager.add(eObject, selectedQuery);
                    }
                }
            }
        }
    }
}

