/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.swt.graphics.GC;

public class TextUtils {
    public static String getShortStr(GC gc, String text, int width, int style) {
        if (text == null || text.equals("")) {
            return text;
        }
        if (width >= gc.stringExtent((String)text).x) {
            return text;
        }
        switch (style) {
            case 16384: {
                return TextUtils.getShortStringTruncatedInTheBeginning(gc, text, width);
            }
            case 131072: {
                return TextUtils.getShortStringTruncatedInTheEnd(gc, text, width);
            }
            case 0x1000000: {
                return TextUtils.getShortStringTruncatedInTheMiddle(gc, text, width);
            }
        }
        return text;
    }

    private static String getShortStringTruncatedInTheBeginning(GC gc, String text, int width) {
        char[] chars = text.toCharArray();
        int calcWidth = gc.stringExtent((String)"...").x;
        int index = chars.length - 1;
        while (calcWidth < width && index >= 0) {
            int step = gc.getCharWidth(chars[index]);
            if ((calcWidth += step) >= width) break;
            --index;
        }
        if (index <= 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(chars.length - index + 4);
        sb.append("...").append(text.substring(index));
        return sb.toString();
    }

    private static String getShortStringTruncatedInTheEnd(GC gc, String text, int width) {
        char[] chars = text.toCharArray();
        int calcWidth = gc.stringExtent((String)"...").x;
        int index = 0;
        int length = chars.length;
        while (calcWidth < width && index < length) {
            int step = gc.getCharWidth(chars[index]);
            if ((calcWidth += step) >= width) break;
            ++index;
        }
        if (index == length - 1) {
            return text;
        }
        StringBuilder sb = new StringBuilder(index + 4);
        if (index > 4) {
            sb.append(text.substring(0, index - 4));
        } else {
            sb.append(text.substring(0, 1));
        }
        sb.append("...");
        return sb.toString();
    }

    private static String getShortStringTruncatedInTheMiddle(GC gc, String text, int width) {
        char[] chars = text.toCharArray();
        int length = chars.length;
        int left = 0;
        int right = length - 1;
        int calcWidth = gc.stringExtent((String)"...").x;
        while (left < right) {
            int step = gc.getCharWidth(chars[left]);
            if ((calcWidth += step) >= width) break;
            ++left;
            step = gc.getCharWidth(chars[right]);
            if ((calcWidth += step) >= width) break;
            --right;
        }
        if (left >= right) {
            return text;
        }
        StringBuilder builder = new StringBuilder(left + length - right + 4);
        if (left == 0 || right == length - 1) {
            builder.append(chars[0]).append("...").append(chars[length - 1]);
        } else {
            int leftLen = left == 1 ? left : left - 1;
            builder.append(chars, 0, leftLen).append("...").append(chars, right + 1, length - right - 1);
        }
        return builder.toString();
    }

    private TextUtils() {
    }
}

