/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Key2FunctionForIdentification;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.QVTrelationDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class TransformationAnalysis
extends QVTrelationHelper
implements Nameable {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull RelationalTransformation transformation;
    private final @NonNull Map<@NonNull Relation, @NonNull RelationAnalysis> relation2relationAnalysis = new HashMap<Relation, RelationAnalysis>();
    private final @NonNull Map<@NonNull Key, @NonNull Map<@NonNull TypedModel, @NonNull Function>> key2typedModel2function = new HashMap<Key, Map<TypedModel, Function>>();
    private final @NonNull Map<@NonNull CompleteClass, @Nullable Key> completeClass2key = new HashMap<CompleteClass, Key>();
    private @Nullable QVTrelationDomainUsageAnalysis domainUsageAnalysis = null;

    public TransformationAnalysis(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull RelationalTransformation rTransformation) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.transformation = rTransformation;
        for (Relation relation : QVTrelationUtil.getOwnedRelations((RelationalTransformation)rTransformation)) {
            this.relation2relationAnalysis.put(relation, new RelationAnalysis(this, relation));
        }
    }

    public void analyze() {
        for (Key key : QVTrelationUtil.getOwnedKey((RelationalTransformation)this.transformation)) {
            this.analyzeKey(key);
        }
        for (RelationAnalysis relationAnalysis : this.relation2relationAnalysis.values()) {
            relationAnalysis.analyze();
        }
    }

    protected void analyzeKey(@NonNull Key key) {
        CompleteClass identifies = this.getCompleteClass((Type)QVTrelationUtil.getIdentifies((Key)key));
        this.completeClass2key.put(identifies, key);
    }

    public @NonNull DomainUsageAnalysis getDomainUsageAnalysis() {
        QVTrelationDomainUsageAnalysis domainUsageAnalysis2 = this.domainUsageAnalysis;
        if (domainUsageAnalysis2 == null) {
            this.domainUsageAnalysis = domainUsageAnalysis2 = new QVTrelationDomainUsageAnalysis(this.environmentFactory, this.qvtr2qvtc.getProblemHandler(), (Transformation)this.transformation);
            domainUsageAnalysis2.analyzeTransformation();
        }
        return domainUsageAnalysis2;
    }

    public @Nullable Key getKeyForCompleteClass(@NonNull CompleteClass completeClass) {
        Key key = this.completeClass2key.get(completeClass);
        if (key == null && !this.completeClass2key.containsKey(completeClass)) {
            HashSet<@NonNull Property> parts = null;
            for (CompleteClass superCompleteClass : completeClass.getProperSuperCompleteClasses()) {
                Key superKey = this.getKeyForCompleteClass(superCompleteClass);
                if (superKey == null) continue;
                if (parts == null) {
                    parts = new HashSet<Property>();
                }
                for (Property property : QVTrelationUtil.getOwnedParts((Key)superKey)) {
                    parts.add(property);
                }
                for (Property property : QVTrelationUtil.getOwnedOppositeParts((Key)superKey)) {
                    parts.add(QVTrelationUtil.getOpposite((Property)property));
                }
            }
            if (parts != null) {
                key = this.createKey(completeClass.getPrimaryClass(), parts);
            }
            this.completeClass2key.put(completeClass, key);
        }
        return key;
    }

    public @Nullable Key getKeyForType(@NonNull Type type) {
        CompleteClass completeClass = this.getCompleteClass(type);
        return this.getKeyForCompleteClass(completeClass);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Function getKeyFunction(@NonNull TypedModel rTypedModel, @NonNull Key rKey) {
        Function cKeyFunction;
        Map<@NonNull TypedModel, @NonNull Function> typedModel2function = this.key2typedModel2function.get(rKey);
        if (typedModel2function == null) {
            typedModel2function = new HashMap<TypedModel, Function>();
            this.key2typedModel2function.put(rKey, typedModel2function);
        }
        if ((cKeyFunction = typedModel2function.get(rTypedModel)) == null) {
            @NonNull Iterable usedClasses = QVTrelationUtil.getUsedClasses((TypedModel)rTypedModel);
            @NonNull Class identifiedClass = QVTrelationUtil.getIdentifies((Key)rKey);
            assert (Iterables.contains((Iterable)usedClasses, (Object)identifiedClass));
            QVTr2QVTc.SYNTHESIS.println("key " + rKey);
            Key2FunctionForIdentification keyToMapping = new Key2FunctionForIdentification(this.qvtr2qvtc, rTypedModel, rKey);
            cKeyFunction = keyToMapping.transform();
            this.qvtr2qvtc.getRelationalTransformation2CoreTransformation(this).getCoreTransformation().getOwnedOperations().add(cKeyFunction);
            typedModel2function.put(rTypedModel, cKeyFunction);
        }
        return cKeyFunction;
    }

    public String getName() {
        return this.transformation.getName();
    }

    public @NonNull QVTr2QVTc getQVTr2QVTc() {
        return this.qvtr2qvtc;
    }

    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage() {
        return this.qvtr2qvtc.getRelationalTransformation2TracePackage(this);
    }

    public @NonNull Iterable<@NonNull RelationAnalysis> getRelationAnalyses() {
        return this.relation2relationAnalysis.values();
    }

    public @NonNull RelationAnalysis getRelationAnalysis(@NonNull Relation relation) {
        RelationAnalysis relationAnalysis = this.relation2relationAnalysis.get(relation);
        if (relationAnalysis != null) {
            return relationAnalysis;
        }
        TransformationAnalysis transformationAnalysis = this.qvtr2qvtc.getTransformationAnalysis(QVTrelationUtil.getContainingTransformation((EObject)relation));
        if (transformationAnalysis != this) {
            return transformationAnalysis.getRelationAnalysis(relation);
        }
        throw new IllegalStateException("No RelationAnalysis for '" + relation + "'");
    }

    public @NonNull RelationalTransformation getTransformation() {
        return this.transformation;
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }
}

