/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.text.MessageFormat;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangeMassivelyImagePathDialog
extends Dialog {
    private String oldPathPrefix;
    private String newPathPrefix;
    private Text textOldPath;
    private Text textNewPath;
    private Label invalidText;
    private Composite invalidComposite;
    private boolean processDiagramContent = true;

    public ChangeMassivelyImagePathDialog(Shell parentShell, String oldPathPrefix) {
        super(parentShell);
        this.oldPathPrefix = oldPathPrefix;
        this.newPathPrefix = oldPathPrefix;
    }

    protected Control createDialogArea(Composite parent) {
        this.createWarningMessage(parent);
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, true, 1, 1);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        container.setLayoutData((Object)layoutData);
        Label labelOldPath = new Label(container, 64);
        labelOldPath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelOldPath.setText(Messages.ChangeMassivelyImagePathDialog_oldLabel);
        labelOldPath.setFont(container.getFont());
        Label infoIconLabelOldPath = new Label(container, 0);
        infoIconLabelOldPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        infoIconLabelOldPath.setImage(JFaceResources.getImage((String)"dialog_help_image"));
        infoIconLabelOldPath.setToolTipText(Messages.ChangeMassivelyImagePathDialog_oldTooltip);
        this.textOldPath = new Text(container, 2052);
        this.textOldPath.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textOldPath.setText(this.oldPathPrefix);
        this.textOldPath.setFont(container.getFont());
        this.textOldPath.addModifyListener(e -> this.validateNewText());
        Label labelNewPath = new Label(container, 64);
        labelNewPath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelNewPath.setText(Messages.ChangeMassivelyImagePathDialog_newLabel);
        labelNewPath.setFont(container.getFont());
        Label infoIconLabelNewPath = new Label(container, 0);
        infoIconLabelNewPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        infoIconLabelNewPath.setImage(JFaceResources.getImage((String)"dialog_help_image"));
        infoIconLabelNewPath.setToolTipText(Messages.ChangeMassivelyImagePathDialog_newTooltip);
        this.textNewPath = new Text(container, 2052);
        this.textNewPath.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textNewPath.setText(this.newPathPrefix);
        this.textNewPath.setFont(container.getFont());
        this.textNewPath.addModifyListener(e -> this.validateNewText());
        this.invalidComposite = new Composite(container, 0);
        this.invalidComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.invalidComposite.setLayout((Layout)new GridLayout(2, false));
        this.invalidComposite.setVisible(false);
        Label errorIcon = new Label(this.invalidComposite, 0);
        errorIcon.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        errorIcon.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.invalidText = new Label(this.invalidComposite, 64);
        this.invalidText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Button processDiagramContentbutton = new Button(container, 32);
        processDiagramContentbutton.setLayoutData((Object)new GridData(1, 4, true, false, 3, 1));
        processDiagramContentbutton.setText(Messages.ChangeMassivelyImagePathDialog_processDiagramContentLabel);
        processDiagramContentbutton.setToolTipText(Messages.ChangeMassivelyImagePathDialog_processDiagramContentTooltip);
        processDiagramContentbutton.setSelection(this.processDiagramContent);
        processDiagramContentbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeMassivelyImagePathDialog.this.processDiagramContent = ((Button)e.widget).getSelection();
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void validateNewText() {
        String cdoPrefix;
        String text = this.textNewPath.getText();
        String path = text.startsWith(cdoPrefix = "cdo:/") ? text.substring(cdoPrefix.length()) : text;
        boolean invalid = false;
        if (path.startsWith("/")) {
            this.invalidText.setText(Messages.ChangeMassivelyImagePathDialog_badLeadingCharacter);
            invalid = true;
        } else if (!path.isEmpty()) {
            String[] segments = path.split("/");
            char[] chars = OS.INVALID_RESOURCE_CHARACTERS;
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.isEmpty()) {
                    this.invalidText.setText(MessageFormat.format(Messages.ChangeMassivelyImagePathDialog_invalidCharInName, String.valueOf("/")));
                    invalid = true;
                    break;
                }
                char[] cArray = chars;
                int n3 = chars.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    if (segment.indexOf(c) != -1) {
                        this.invalidText.setText(MessageFormat.format(Messages.ChangeMassivelyImagePathDialog_invalidCharInName, String.valueOf(c)));
                        invalid = true;
                        break;
                    }
                    ++n4;
                }
                if (invalid) break;
                ++n2;
            }
        }
        if (invalid) {
            this.invalidComposite.setVisible(true);
            this.getButton(0).setEnabled(false);
        } else {
            this.invalidText.setText("");
            this.invalidComposite.setVisible(false);
            this.getButton(0).setEnabled(!this.textOldPath.getText().equals(this.textNewPath.getText()) && !this.textNewPath.getText().isBlank());
        }
    }

    private Control createWarningMessage(Composite parent) {
        Composite warningComposite = null;
        warningComposite = new Composite(parent, 0);
        warningComposite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 128, true, true, 1, 1);
        warningComposite.setLayoutData((Object)layoutData);
        Label descriptionWarning = new Label(warningComposite, 0);
        descriptionWarning.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        descriptionWarning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        Label descriptionLabel = new Label(warningComposite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        descriptionLabel.setText(Messages.ChangeMassivelyImagePathDialog_warning);
        return warningComposite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.oldPathPrefix = this.textOldPath.getText();
            this.newPathPrefix = this.textNewPath.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ChangeMassivelyImagePathDialog_title);
    }

    protected boolean isResizable() {
        return false;
    }

    public String getNewPathPrefix() {
        return this.newPathPrefix;
    }

    public String getOldPathPrefix() {
        return this.oldPathPrefix;
    }

    public boolean processDiagramContent() {
        return this.processDiagramContent;
    }
}

