/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSourceParameters;
import org.eclipse.wb.internal.core.nls.ui.common.AbstractFieldsSourceNewComposite;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.PackageRootAndPackageSelectionDialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public abstract class AbstractBundleSourceNewComposite
extends AbstractFieldsSourceNewComposite {
    private Group m_propertyGroup;
    private PackageRootAndPackageSelectionDialogField m_propertyPackageField;
    private StringButtonDialogField m_propertyFileField;
    private static final String KEY_PROPERTY_FOLDER = "KEY_PROPERTY_FOLDER";
    private static final String KEY_PROPERTY_PACKAGE = "KEY_PROPERTY_PACKAGE";
    private static final String KEY_PROPERTY_FILE = "KEY_PROPERTY_FILE";

    public AbstractBundleSourceNewComposite(Composite parent, int style, JavaInfo root) {
        super(parent, style, root);
    }

    protected final void createPropertyGroup() {
        this.m_propertyGroup = new Group((Composite)this, 0);
        GridDataFactory.create((Control)this.m_propertyGroup).grabH().fillH();
        GridLayoutFactory.create((Composite)this.m_propertyGroup).columns(3);
        this.m_propertyGroup.setText(Messages.AbstractBundleSourceNewComposite_propertiesGroup);
        this.m_propertyPackageField = new PackageRootAndPackageSelectionDialogField(60, Messages.AbstractBundleSourceNewComposite_propertiesSourceFolder, Messages.AbstractBundleSourceNewComposite_propertiesSourceFolderBrowse, Messages.AbstractBundleSourceNewComposite_propertiesPackage, Messages.AbstractBundleSourceNewComposite_propertiesPackageBrowse);
        this.m_propertyPackageField.setDialogFieldListener(this.m_validateListener);
        this.m_propertyPackageField.doFillIntoGrid((Composite)this.m_propertyGroup, 3);
        this.m_propertyFileField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractBundleSourceNewComposite.this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
                dialog.setIgnoreCase(false);
                dialog.setTitle(Messages.AbstractBundleSourceNewComposite_propertiesChooseTitle);
                dialog.setMessage(Messages.AbstractBundleSourceNewComposite_propertiesChooseMessage);
                dialog.setElements(this.createFileListInput());
                dialog.setFilter("*.properties");
                if (dialog.open() != 0) {
                    return;
                }
                IFile selectedFile = (IFile)dialog.getFirstResult();
                AbstractBundleSourceNewComposite.this.m_propertyFileField.setText(selectedFile.getName());
            }

            private Object[] createFileListInput() {
                try {
                    IPackageFragment currentPackage = AbstractBundleSourceNewComposite.this.m_propertyPackageField.getPackage();
                    if (currentPackage == null) {
                        return ArrayUtils.EMPTY_OBJECT_ARRAY;
                    }
                    ArrayList<IFile> result = new ArrayList<IFile>(1);
                    Object[] nonJava = currentPackage.getNonJavaResources();
                    int i = 0;
                    while (i < nonJava.length) {
                        if (this.isPropertyFile(nonJava[i])) {
                            result.add((IFile)nonJava[i]);
                        }
                        ++i;
                    }
                    return result.toArray();
                }
                catch (JavaModelException e) {
                    DesignerPlugin.log((Throwable)e);
                    return new Object[0];
                }
            }

            private boolean isPropertyFile(Object o) {
                if (o instanceof IFile) {
                    IFile file = (IFile)o;
                    return ".properties".equals("." + file.getFileExtension());
                }
                return false;
            }
        });
        this.m_propertyFileField.setDialogFieldListener(this.m_validateListener);
        this.m_propertyFileField.setLabelText(Messages.AbstractBundleSourceNewComposite_propertiesLabel);
        this.m_propertyFileField.setButtonLabel(Messages.AbstractBundleSourceNewComposite_propertiesChooseButton);
        this.createTextFieldControls((Composite)this.m_propertyGroup, (StringDialogField)this.m_propertyFileField, 3);
    }

    protected final void initializePropertyGroup() {
        this.m_propertyPackageField.setCompilationUnit(this.m_compilationUnit);
        this.m_propertyFileField.setText("messages.properties");
    }

    protected final void initializePropertyGroupActivator() {
        this.m_propertyPackageField.setCompilationUnit(this.m_compilationUnit);
        this.m_propertyFileField.setText("plugin.properties");
    }

    protected final void setPropertyGroupEnable(boolean enable) {
        UiUtils.changeControlEnable((Control)this.m_propertyGroup, (boolean)enable);
    }

    protected void validatePropertyFields() {
        IPackageFragmentRoot root = this.m_propertyPackageField.getRoot();
        if (root == null || !root.exists()) {
            this.setInvalid(KEY_PROPERTY_FOLDER, Messages.AbstractBundleSourceNewComposite_validatePropertiesInvalidSourceFolder);
        } else {
            this.setValid(KEY_PROPERTY_FOLDER);
        }
        IPackageFragment fragment = this.m_propertyPackageField.getPackage();
        if (fragment == null || !fragment.exists()) {
            this.setInvalid(KEY_PROPERTY_PACKAGE, Messages.AbstractBundleSourceNewComposite_validatePropertiesInvalidPackage);
        } else {
            this.setValid(KEY_PROPERTY_PACKAGE);
        }
        String fileName = this.m_propertyFileField.getText();
        if (fileName.length() == 0) {
            this.setInvalid(KEY_PROPERTY_FILE, Messages.AbstractBundleSourceNewComposite_validatePropertiesFileEmpty);
        } else if (!fileName.endsWith(".properties")) {
            this.setInvalid(KEY_PROPERTY_FILE, Messages.AbstractBundleSourceNewComposite_validatePropertiesFileExtension);
        } else {
            this.setValid(KEY_PROPERTY_FILE);
        }
    }

    @Override
    protected void validateAll() {
        this.validatePropertyFields();
        super.validateAll();
    }

    protected final void fillPropertyParameters(AbstractBundleSourceParameters parameters) throws Exception {
        parameters.m_propertySourceFolder = this.m_propertyPackageField.getRoot();
        parameters.m_propertyPackage = this.m_propertyPackageField.getPackage();
        parameters.m_propertyFileName = this.m_propertyFileField.getText();
        IPackageFragment property_package = this.m_propertyPackageField.getPackage();
        if (property_package != null) {
            String property_packageName = property_package.getElementName();
            String property_fileName = this.m_propertyFileField.getText();
            String property_bundleName = StringUtils.substring((String)property_fileName, (int)0, (int)(-".properties".length()));
            parameters.m_propertyBundleName = property_packageName.length() != 0 ? property_packageName + "." + property_bundleName : property_bundleName;
        }
        if (parameters.m_propertyPackage != null) {
            IFolder property_folder = (IFolder)parameters.m_propertyPackage.getUnderlyingResource();
            parameters.m_propertyFileExists = property_folder.getFile(parameters.m_propertyFileName).exists();
        }
    }
}

