/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentassist;

import java.util.Collection;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.jsonpath.JSONPathMatcher;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class CompletionProposalMatcher {
    private final Collection<ICompletionProposalCollector.TargetType> targets;
    private final IJSONPath[] paths;
    private final ICompletionProposalCollector collector;

    public CompletionProposalMatcher(Collection<ICompletionProposalCollector.TargetType> targets, IJSONPath[] paths, ICompletionProposalCollector collector) {
        this.targets = targets;
        this.paths = paths;
        this.collector = collector;
    }

    public void addProposalsIfMatch(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, ICompletionProposalCollector.TargetType target) {
        if (this.isMatchTarget(target) && this.isMatchPaths(contentAssistRequest.getNode())) {
            this.collector.addProposals(contentAssistRequest, context, target);
        }
    }

    private boolean isMatchPaths(IJSONNode node) {
        int i = 0;
        while (i < this.paths.length) {
            if (JSONPathMatcher.isMatch((IJSONNode)node, (IJSONPath)this.paths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isMatchTarget(ICompletionProposalCollector.TargetType target) {
        return this.targets.contains((Object)target);
    }
}

