/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.junit5.cm.BlockingConfigurationHandler;
import org.osgi.test.junit5.cm.ConfigUtil;
import org.osgi.test.junit5.cm.ConfigurationCopy;
import org.osgi.test.junit5.cm.ConfigurationExtension;
import org.osgi.test.junit5.cm.ConfigurationHolder;

public class ConfigCloseableResource
implements ExtensionContext.Store.CloseableResource {
    private ExtensionContext extensionContext;
    private BlockingConfigurationHandler timeoutListener;
    private List<ConfigurationHolder> holders = new ArrayList<ConfigurationHolder>();

    public ConfigCloseableResource(ExtensionContext extensionContext, BlockingConfigurationHandler timeoutListener) {
        this.extensionContext = extensionContext;
        this.timeoutListener = timeoutListener;
    }

    public void close() throws Throwable {
        ConfigurationAdmin ca = ConfigurationExtension.configurationAdmin(this.extensionContext);
        this.holders.stream().forEach(holder -> {
            if (holder == null) {
                return;
            }
            if (holder.getConfiguration() == null) {
                return;
            }
            ConfigurationCopy configuration = holder.getConfiguration();
            Optional<ConfigurationCopy> configurationCopyBefore = holder.getBeforeConfiguration();
            try {
                if (configurationCopyBefore.isPresent()) {
                    ConfigurationCopy copy = configurationCopyBefore.get();
                    Configuration conf = null;
                    if (copy.getFactoryPid() != null) {
                        String name = copy.getPid().substring(copy.getFactoryPid().length() + 1);
                        conf = ca.getFactoryConfiguration(copy.getFactoryPid(), name, copy.getBundleLocation());
                    } else {
                        conf = ca.getConfiguration(copy.getPid(), copy.getBundleLocation());
                    }
                    this.timeoutListener.update(conf, copy.getProperties(), 3000L);
                } else {
                    String pid = configuration.getPid();
                    Configuration configurationToDelete = ConfigUtil.getConfigsByServicePid(ca, pid, 1000L);
                    if (configurationToDelete != null) {
                        this.timeoutListener.delete(configurationToDelete, 3000L);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void addAll(List<ConfigurationHolder> holders) {
        holders.forEach(this::add);
    }

    public void add(ConfigurationHolder holder) {
        ConfigurationCopy compateConfig = holder.getConfiguration();
        Optional<ConfigurationHolder> preStoresConfig = this.holders.stream().filter(c -> c.getConfiguration().getPid().endsWith(compateConfig.getPid())).findAny();
        if (!preStoresConfig.isPresent()) {
            this.holders.add(holder);
        }
    }
}

