/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.util.List;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.ProcessPrompterDialog;
import org.eclipse.cdt.dsf.gdb.launching.IProcessExtendedInfo;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ProcessPrompter
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object info) throws CoreException {
        Shell shell = GdbUIPlugin.getShell();
        if (shell == null) {
            Status error = new Status(4, GdbUIPlugin.getUniqueIdentifier(), 150, LaunchMessages.getString((String)"CoreFileLaunchDelegate.No_Shell_available_in_Launch"), null);
            throw new CoreException((IStatus)error);
        }
        final PrompterInfo prompterInfo = (PrompterInfo)info;
        Object[] plist = prompterInfo.processList;
        if (plist == null) {
            MessageDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LocalAttachLaunchDelegate.CDT_Launch_Error"), (String)LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Platform_cannot_list_processes"));
            return null;
        }
        if (plist.length == 0) {
            InputDialog dialog = new InputDialog(shell, LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Select_Process"), LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Select_Process_to_attach_debugger_to"), null, null);
            if (dialog.open() == 0) {
                String pidStr = dialog.getValue();
                try {
                    return Integer.parseInt(pidStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            Object[] results;
            LabelProvider provider = new LabelProvider(){

                public String getText(Object element) {
                    String description;
                    IProcessExtendedInfo info = (IProcessExtendedInfo)element;
                    String name = info.getName();
                    if (name == null || name.isEmpty()) {
                        return null;
                    }
                    name = name.split("\\s", 2)[0];
                    Path path = new Path(name);
                    StringBuilder text = new StringBuilder();
                    if (path.lastSegment() == null) {
                        text.append(name);
                    } else {
                        text.append(path.lastSegment());
                    }
                    String owner = info.getOwner();
                    if (owner != null && !owner.isEmpty()) {
                        text.append(" (").append(owner).append(")");
                    }
                    text.append(" - ").append(info.getPid());
                    String[] cores = info.getCores();
                    if (cores != null && cores.length > 0) {
                        String coreStr = cores.length == 1 ? LaunchUIMessages.getString("ProcessPrompter.Core") : LaunchUIMessages.getString("ProcessPrompter.Cores");
                        text.append(" [").append(coreStr).append(": ");
                        String[] stringArray = cores;
                        int n = cores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String core = stringArray[n2];
                            text.append(core).append(", ");
                            ++n2;
                        }
                        text.replace(text.length() - 2, text.length(), "]");
                    }
                    if ((description = info.getDescription()) != null) {
                        text.append(" : " + description);
                    }
                    return text.toString();
                }

                public Image getImage(Object element) {
                    return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                }
            };
            LabelProvider qprovider = new LabelProvider(){

                public String getText(Object element) {
                    IProcessExtendedInfo info = (IProcessExtendedInfo)element;
                    String description = info.getDescription();
                    if (description != null) {
                        return description;
                    }
                    return info.getName();
                }

                public Image getImage(Object element) {
                    return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                }
            };
            ProcessPrompterDialog dialog = new ProcessPrompterDialog(shell, (ILabelProvider)provider, (ILabelProvider)qprovider);
            dialog.setTitle(LaunchUIMessages.getString("LocalAttachLaunchDelegate.Select_Process"));
            dialog.setMessage(LaunchUIMessages.getString("LocalAttachLaunchDelegate.Select_Process_to_attach_debugger_to"));
            dialog.setMultipleSelection(true);
            dialog.setStatusLineAboveButtons(true);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object sel = objectArray[n2];
                        String pid = Integer.toString(((IProcessExtendedInfo)sel).getPid(), 10);
                        if (prompterInfo.debuggedProcesses.contains(pid)) {
                            return new Status(4, GdbUIPlugin.getUniqueIdentifier(), LaunchUIMessages.getFormattedString("ProcessPrompter.ErrProcessConected", pid));
                        }
                        ++n2;
                    }
                    return new Status(0, GdbUIPlugin.getUniqueIdentifier(), "");
                }
            });
            dialog.setElements(plist);
            if (dialog.open() == 0 && (results = dialog.getResult()) != null) {
                IProcessExtendedInfo[] processes = new IProcessExtendedInfo[results.length];
                int i = 0;
                while (i < processes.length) {
                    processes[i] = (IProcessExtendedInfo)results[i];
                    ++i;
                }
                return processes;
            }
        }
        return null;
    }

    public static class PrompterInfo {
        public IProcessExtendedInfo[] processList;
        public List<String> debuggedProcesses;

        public PrompterInfo(IProcessExtendedInfo[] list, List<String> debuggedProcs) {
            this.processList = list;
            this.debuggedProcesses = debuggedProcs;
        }
    }
}

