/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.ui.templates.IScriptTemplateContext;
import org.eclipse.dltk.ui.templates.IScriptTemplateIndenter;
import org.eclipse.dltk.ui.templates.NopScriptTemplateIndenter;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;

public class ScriptTemplateContext
extends DocumentTemplateContext
implements IScriptTemplateContext {
    private final ISourceModule sourceModule;
    protected final boolean fIsManaged;

    protected ScriptTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceModule sourceModule) {
        super(type, document, completionOffset, completionLength);
        Assert.isNotNull((Object)sourceModule);
        this.sourceModule = sourceModule;
        this.fIsManaged = false;
    }

    protected ScriptTemplateContext(TemplateContextType type, IDocument document, Position position, ISourceModule sourceModule) {
        super(type, document, position);
        Assert.isNotNull((Object)sourceModule);
        this.sourceModule = sourceModule;
        this.fIsManaged = true;
    }

    @Override
    public final ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    protected IPreferencesLookupDelegate getPreferences() {
        return new PreferencesLookupDelegate(this.sourceModule.getScriptProject());
    }

    private static boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    protected static String calculateIndent(IDocument document, int offset) {
        block4: {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                String indent = document.get(region.getOffset(), offset - region.getOffset());
                int i = 0;
                while (i < indent.length() && ScriptTemplateContext.isSpaceOrTab(indent.charAt(i))) {
                    ++i;
                }
                if (i > 0) {
                    return indent.substring(0, i);
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return "";
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        String[] lines = TextUtils.splitLines((CharSequence)template.getPattern());
        if (lines.length > 1) {
            String delimeter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
            String indent = ScriptTemplateContext.calculateIndent(this.getDocument(), this.getStart());
            IScriptTemplateIndenter indenter = this.getIndenter();
            StringBuffer buffer = new StringBuffer(lines[0]);
            int i = 1;
            while (i < lines.length) {
                buffer.append(delimeter);
                indenter.indentLine(buffer, indent, lines[i]);
                ++i;
            }
            template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), buffer.toString(), template.isAutoInsertable());
        }
        return super.evaluate(template);
    }

    protected IScriptTemplateIndenter getIndenter() {
        return new NopScriptTemplateIndenter();
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException e) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException e) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException e) {
            return super.getKey();
        }
    }
}

