/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.ObjectListController;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.handlers.AbstractObjectHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ObjectDeleteHandler
extends AbstractObjectHandler {
    public ObjectDeleteHandler() {
        super(null);
    }

    protected void preRun(ExecutionEvent event) throws Exception {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        DeleteObjectsDialog dialog = new DeleteObjectsDialog(shell, this.getCheckout(), this.elements);
        if (dialog.open() != 0) {
            this.cancel();
        }
    }

    @Override
    protected boolean doExecute(ExecutionEvent event, List<EObject> transactionalElements, IProgressMonitor monitor) {
        try {
            for (EObject eObject : transactionalElements) {
                EcoreUtil.remove((EObject)eObject);
            }
        }
        catch (Throwable ex) {
            final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (!shell.isDisposed()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!shell.isDisposed()) {
                                MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
                            }
                        }
                        catch (Exception ex2) {
                            OM.LOG.error((Throwable)ex2);
                        }
                    }
                });
            }
            return false;
        }
        return true;
    }

    private static class DeleteObjectsDialog
    extends TitleAreaDialog {
        private final CDOCheckout checkout;
        private final List<EObject> objects;

        public DeleteObjectsDialog(Shell parentShell, CDOCheckout checkout, List<EObject> objects) {
            super(parentShell);
            this.checkout = checkout;
            this.objects = objects;
            this.setShellStyle(65648);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            int size = this.objects.size();
            if (size != 0) {
                String title = "Delete " + (size == 1 ? "Object" : "Objects");
                this.getShell().setText(title);
                this.setTitle(title);
                this.setTitleImage(OM.getImage("icons/wiz/delete.gif"));
                this.updateMessage(size);
                Composite container = new Composite(area, 0);
                container.setLayoutData((Object)new GridData(1808));
                GridLayout containerGridLayout = new GridLayout();
                containerGridLayout.marginWidth = 10;
                containerGridLayout.marginHeight = 10;
                container.setLayout((Layout)containerGridLayout);
                final ObjectListController objectListController = new ObjectListController(this.checkout);
                for (EObject object : this.objects) {
                    objectListController.addObject(object, true);
                }
                CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(container);
                treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
                objectListController.configure((TreeViewer)treeViewer);
                treeViewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        EObject object = objectListController.getObject(event.getElement());
                        if (event.getChecked()) {
                            objects.add(object);
                        } else {
                            objects.remove(object);
                        }
                        int size = objects.size();
                        this.updateMessage(size);
                        if (size <= 1) {
                            Button button = this.getButton(0);
                            button.setEnabled(size != 0);
                        }
                    }
                });
            }
            return area;
        }

        protected Point getInitialSize() {
            return new Point(500, 400);
        }

        private void updateMessage(int size) {
            if (size == 0) {
                this.setMessage("No objects to delete.");
            } else {
                this.setMessage("Are you sure you want to delete " + (size == 1 ? "this" : "these") + " " + size + " " + (size == 1 ? "object" : "objects") + "?");
            }
        }
    }
}

