/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.util.Collection;
import org.eclipse.emf.cdo.server.db.evolution.phased.BasicPhaseHandler;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;

public class DefaultChangeDetector
extends BasicPhaseHandler {
    public static final String FACTORY_TYPE = "default-change-detector";

    @Override
    public void execute(Context context) throws Exception {
        Collection<Context.Model> models = context.getModels().values();
        models.forEach(model -> {
            Object changeInfo = this.getChangeInfo((Context.Model)model);
            if (changeInfo != null) {
                context.addChangeInfo((Context.Model)model, changeInfo);
            }
        });
    }

    protected Object getChangeInfo(Context.Model model) {
        String oldXMI = model.getOldXMI();
        String newXMI = model.getNewXMI();
        if (newXMI != null && !oldXMI.equals(newXMI)) {
            return Boolean.TRUE;
        }
        return null;
    }
}

