/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalView;

public class QueryIndication
extends CDOServerReadIndication {
    private boolean xrefs;
    private boolean disableResponseFlushing;
    private boolean disableResponseTimeout;
    private InternalQueryResult queryResult;

    public QueryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)17);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        IQueryHandler.PotentiallySlow potentiallySlow;
        IQueryHandler handler;
        int viewID = in.readXInt();
        InternalView view = this.getView(viewID);
        CDOQueryInfoImpl queryInfo = new CDOQueryInfoImpl(in);
        InternalQueryManager queryManager = this.getRepository().getQueryManager();
        this.queryResult = queryManager.execute(view, (CDOQueryInfo)queryInfo);
        String queryLanguage = queryInfo.getQueryLanguage();
        this.xrefs = queryLanguage.equals("xrefs");
        Map parameters = queryInfo.getParameters();
        this.disableResponseFlushing = this.xrefs || Boolean.TRUE.equals(parameters.get("disable.response.flushing"));
        this.disableResponseTimeout = Boolean.TRUE.equals(parameters.get("disable.response.timeout"));
        if (!this.disableResponseTimeout && (handler = this.queryResult.getQueryHandler()) instanceof IQueryHandler.PotentiallySlow && (potentiallySlow = (IQueryHandler.PotentiallySlow)handler).isSlow((CDOQueryInfo)queryInfo)) {
            this.disableResponseTimeout = true;
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        if (this.disableResponseTimeout) {
            try {
                this.monitor(1, 10, () -> this.doRespond(out));
            }
            catch (IOException | Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        } else {
            this.doRespond(out);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doRespond(CDODataOutput out) throws IOException {
        out.writeXInt(this.queryResult.getQueryID());
        this.flushUnlessDisabled();
        while (true) lbl-1000:
        // 4 sources

        {
            try {
                if (!this.queryResult.hasNext()) ** break;
                object = this.queryResult.next();
            }
            catch (Throwable ex) {
                out.writeBoolean(true);
                out.writeCDORevisionOrPrimitive((Object)ex);
                ** break;
            }
            out.writeBoolean(true);
            if (this.xrefs) {
                idReference = (CDOIDReference)object;
                out.writeCDOIDReference(idReference);
            } else {
                out.writeCDORevisionOrPrimitive(object);
            }
            try {
                if (this.queryResult.peek() != null) ** GOTO lbl-1000
                this.flushUnlessDisabled();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable var3_6) {
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl27:
        // 2 sources

        out.writeBoolean(false);
    }

    private void flushUnlessDisabled() throws IOException {
        if (!this.disableResponseFlushing) {
            this.flush();
        }
    }
}

