/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;

abstract class BinaryMember
extends BinaryAnnotatedElement
implements JavaResourceMember {
    private boolean final_ = this.buildFinal();
    private boolean transient_ = this.buildTransient();
    private boolean public_ = this.buildPublic();
    private boolean static_ = this.buildStatic();
    private boolean protected_ = this.buildProtected();

    public BinaryMember(JavaResourceModel parent, MemberAdapter adapter) {
        super(parent, adapter);
    }

    @Override
    public void update() {
        super.update();
        this.updateFinal();
        this.updateTransient();
        this.updatePublic();
        this.updateStatic();
        this.updateProtected();
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private boolean buildFinal() {
        try {
            return Flags.isFinal((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateFinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTransient() {
        return this.transient_;
    }

    private boolean buildTransient() {
        try {
            return Flags.isTransient((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateTransient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    private boolean buildPublic() {
        try {
            return Flags.isPublic((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updatePublic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private boolean buildStatic() {
        try {
            return Flags.isStatic((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateStatic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProtected() {
        return this.protected_;
    }

    private boolean buildProtected() {
        try {
            return Flags.isProtected((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateProtected() {
        throw new UnsupportedOperationException();
    }

    protected IMember getElement() {
        return (IMember)super.getElement();
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName_(typeSignature, typeParameters);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName_(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        String erasureSignature = Signature.getTypeErasure((String)typeSignature);
        if (Signature.getTypeSignatureKind((String)erasureSignature) == 3) {
            try {
                String typeParameterName = Signature.toString((String)erasureSignature);
                for (ITypeParameter typeParameter : typeParameters) {
                    String[] bounds;
                    if (!typeParameterName.equals(typeParameter.getElementName()) || (bounds = typeParameter.getBoundsSignatures()).length <= 0) continue;
                    return BinaryMember.convertTypeSignatureToTypeName_(bounds[0], typeParameters);
                }
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.instance().logError(jme);
            }
        } else {
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 4) {
                int dim = Signature.getArrayCount((String)erasureSignature);
                String arrayTypeName = BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)erasureSignature), typeParameters);
                return Signature.toString((String)Signature.createArraySignature((String)Signature.createTypeSignature((String)arrayTypeName, (boolean)true), (int)dim));
            }
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 5) {
                if (String.valueOf('*').equals(erasureSignature) || erasureSignature.startsWith(String.valueOf('-'))) {
                    return Object.class.getName();
                }
                return Signature.toString((String)erasureSignature.substring(1));
            }
        }
        return Signature.toString((String)erasureSignature);
    }

    static boolean convertTypeSignatureToTypeIsArray(String typeSignature) {
        return typeSignature == null ? false : Signature.getTypeSignatureKind((String)typeSignature) == 4;
    }

    static int convertTypeSignatureToTypeArrayDimensionality(String typeSignature) {
        return typeSignature == null ? 0 : Signature.getArrayCount((String)typeSignature);
    }

    static String convertTypeSignatureToTypeArrayComponentTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)typeSignature), typeParameters);
    }

    static List<String> convertTypeSignatureToTypeTypeArgumentNames(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        if (typeSignature == null) {
            return Collections.emptyList();
        }
        String[] typeArgumentSignatures = Signature.getTypeArguments((String)typeSignature);
        if (typeArgumentSignatures.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArgumentSignatures.length);
        String[] stringArray = typeArgumentSignatures;
        int n = typeArgumentSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String typeArgumentSignature = stringArray[n2];
            names.add(BinaryMember.convertTypeSignatureToTypeName(typeArgumentSignature, typeParameters));
            ++n2;
        }
        return names;
    }

    @Override
    public boolean isPublicOrProtected() {
        return this.isPublic() || this.isProtected();
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    static interface MemberAdapter
    extends BinaryAnnotatedElement.Adapter {
        public IMember getElement();
    }
}

