/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.types.TypeInfoCache;
import org.eclipse.jst.jsf.common.util.JDTBeanMethod;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.JDTBeanPropertyWorkingCopy;
import org.eclipse.jst.jsf.common.util.JDTTypeResolver;

public class JDTBeanIntrospector {
    private static final IType[] EMPTY_SUPER_TYPES = new IType[0];
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final IMethod[] EMTPY_METHODS = new IMethod[0];
    private final IType type;
    private final JDTTypeResolver typeResolver;
    private IMethod[] methods;
    private final IType[] superTypes;

    public static JDTBeanIntrospector forType(IType type) {
        TypeInfoCache cache = TypeInfoCache.getInstance();
        JDTBeanIntrospector beanIntrospector = cache.getCachedBeanIntrospector(type);
        if (beanIntrospector != null) {
            return beanIntrospector;
        }
        IType[] superTypes = cache.getCachedSupertypes(type);
        if (superTypes == null) {
            superTypes = cache.cacheSupertypesFor(type);
        }
        beanIntrospector = new JDTBeanIntrospector(type, superTypes);
        cache.cacheBeanIntrospector(type, beanIntrospector);
        return beanIntrospector;
    }

    private JDTBeanIntrospector(IType type, IType[] superTypes) {
        this.type = type;
        this.superTypes = superTypes;
        if (superTypes == null) {
            superTypes = EMPTY_SUPER_TYPES;
        }
        this.typeResolver = new JDTTypeResolver(type, superTypes);
    }

    public Map<String, JDTBeanProperty> getProperties() {
        HashMap<String, JDTBeanPropertyWorkingCopy> propertiesWorkingCopy = new HashMap<String, JDTBeanPropertyWorkingCopy>();
        IMethod[] mthds = this.methods();
        int i = 0;
        while (i < mthds.length) {
            try {
                this.processPropertyMethod(mthds[i], propertiesWorkingCopy);
            }
            catch (JavaModelException jme) {
                JSFCommonPlugin.log(jme, "Error processing IMethod for bean property info");
            }
            ++i;
        }
        HashMap<String, JDTBeanProperty> properties = new HashMap<String, JDTBeanProperty>();
        for (Map.Entry entry : propertiesWorkingCopy.entrySet()) {
            String key = (String)entry.getKey();
            JDTBeanPropertyWorkingCopy wcopy = (JDTBeanPropertyWorkingCopy)entry.getValue();
            properties.put(key, wcopy.toValueObject());
        }
        return properties;
    }

    private void processPropertyMethod(IMethod method, Map<String, JDTBeanPropertyWorkingCopy> properties) throws JavaModelException {
        if (!method.isConstructor() && (Flags.isPublic((int)method.getFlags()) || this.type.isInterface()) && !Flags.isStatic((int)method.getFlags())) {
            boolean startsWithSet;
            String methodName = method.getElementName();
            String returnType = method.getReturnType();
            boolean startsWithIs = methodName.startsWith(IS_PREFIX) && "Z".equals(returnType) && method.getNumberOfParameters() == 0 && methodName.length() > IS_PREFIX.length();
            boolean startsWithGet = methodName.startsWith(GET_PREFIX) && method.getNumberOfParameters() == 0 && !"V".equals(returnType) && methodName.length() > GET_PREFIX.length();
            boolean bl = startsWithSet = methodName.startsWith(SET_PREFIX) && method.getNumberOfParameters() == 1 && "V".equals(returnType) && methodName.length() > SET_PREFIX.length();
            if (startsWithGet || startsWithSet || startsWithIs) {
                String propertyName = Introspector.decapitalize(methodName.substring(startsWithIs ? 2 : 3));
                JDTBeanPropertyWorkingCopy workingCopy = properties.get(propertyName);
                if (workingCopy == null) {
                    workingCopy = new JDTBeanPropertyWorkingCopy(this.type, this.typeResolver, propertyName);
                    properties.put(propertyName, workingCopy);
                }
                if (startsWithIs) {
                    workingCopy.setIsGetter(method);
                } else if (startsWithGet) {
                    workingCopy.setGetter(method);
                } else if (startsWithSet) {
                    workingCopy.addSetter(method);
                }
            }
        }
    }

    public JDTBeanMethod[] getMethods() {
        ArrayList<JDTBeanMethod> beanMethods = new ArrayList<JDTBeanMethod>();
        IMethod[] iMethodArray = this.methods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            JDTBeanMethod beanMethod = this.toBeanMethod(method);
            if (beanMethod != null) {
                beanMethods.add(beanMethod);
            }
            ++n2;
        }
        return beanMethods.toArray(new JDTBeanMethod[beanMethods.size()]);
    }

    private JDTBeanMethod toBeanMethod(IMethod method) {
        try {
            String resMethodSigErased = this.typeResolver.resolveMethodEraseTypeParams(method.getSignature());
            String resMethodSigUnerased = this.typeResolver.resolveMethodKeepTypeParams(method.getSignature());
            return new JDTBeanMethod(method, resMethodSigErased, resMethodSigUnerased);
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log(jme, "Error processing IMethod for bean method info");
            return null;
        }
    }

    private IMethod[] methods() {
        if (this.type == null) {
            return EMTPY_METHODS;
        }
        if (this.methods == null) {
            this.methods = this.allMethods();
        }
        return this.methods;
    }

    private IMethod[] allMethods() {
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        IType[] closure = new IType[this.superTypes.length + 1];
        closure[0] = this.type;
        System.arraycopy(this.superTypes, 0, closure, 1, this.superTypes.length);
        IType[] iTypeArray = closure;
        int n = closure.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            try {
                allMethods.addAll(Arrays.asList(t.getMethods()));
            }
            catch (JavaModelException e) {
                JSFCommonPlugin.log(e, "Error getting super type information for bean");
            }
            ++n2;
        }
        return allMethods.toArray(new IMethod[allMethods.size()]);
    }

    public String resolveFullQualifiedTypeName(String simpleName) {
        IType resolvedType = this.typeResolver.resolveTypeName(simpleName);
        if (resolvedType == null) {
            return null;
        }
        return resolvedType.getFullyQualifiedName();
    }
}

