/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.PartsFactory;
import org.eclipse.mat.report.internal.RenderingInfo;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class QueryPart
extends AbstractPart {
    PartsFactory factory;

    public QueryPart(String id, AbstractPart parent, DataFile artefact, QuerySpec spec) {
        super(id, parent, artefact, spec);
    }

    @Override
    void init(PartsFactory factory) {
        this.factory = factory;
    }

    @Override
    public QuerySpec spec() {
        return (QuerySpec)super.spec();
    }

    @Override
    public String getCommand() {
        return this.params().expand(this.spec().getCommand());
    }

    @Override
    public AbstractPart execute(IQueryContext context, ResultRenderer renderer, IProgressListener listener) throws SnapshotException, IOException {
        RefinedResultBuilder builder;
        String sectionName = this.parent != null ? this.parent.spec().getName() : Messages.QueryPart_Label_ReportRoot;
        String subTaskName = MessageUtil.format(Messages.QueryPart_Msg_TestProgress, this.spec().getName(), sectionName);
        listener.subTask(subTaskName);
        IResult result = this.spec().getResult();
        SimpleMonitor monitor = new SimpleMonitor(subTaskName, listener, new int[]{80, 20});
        if (result == null) {
            if (this.getCommand() == null) {
                ReportPlugin.log(4, MessageUtil.format(Messages.QueryPart_Error_NoCommand, this.spec().getName(), sectionName));
            } else {
                try {
                    result = CommandLine.execute(context, this.getCommand(), monitor.nextMonitor());
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getName();
                    }
                    ReportPlugin.log(e, MessageUtil.format(Messages.QueryPart_Error_IgnoringResult, this.spec().getName(), msg));
                    result = new TextResult(e.getLocalizedMessage());
                }
            }
        }
        if (result instanceof CompositeResult) {
            result = this.buildFor((CompositeResult)result);
        }
        if (result instanceof Spec) {
            Spec replacement = (Spec)result;
            replacement.setName(this.spec().getName());
            AbstractPart part = this.factory.createClone(this, replacement);
            return part.execute(context, renderer, monitor.nextMonitor());
        }
        if (result instanceof ITestResult) {
            this.status = ((ITestResult)((Object)result)).getStatus();
        }
        boolean hasParameterThatNeedRefining = this.hasParameterThatNeedRefining();
        if (result instanceof RefinedTable && !hasParameterThatNeedRefining) {
            this.readParamsAndProcess(renderer, (RefinedStructuredResult)result);
        } else if (result instanceof IResultTable) {
            builder = new RefinedResultBuilder(context, (IResultTable)result);
            this.readParamsAndProcess(renderer, context, result, builder);
        } else if (result instanceof RefinedTree && !hasParameterThatNeedRefining) {
            this.readParamsAndProcess(renderer, (RefinedStructuredResult)result);
        } else if (result instanceof IResultTree) {
            builder = new RefinedResultBuilder(context, (IResultTree)result);
            this.readParamsAndProcess(renderer, context, result, builder);
        } else if (!(result instanceof IResultPie) || Platform.getBundle((String)"org.eclipse.mat.chart") != null) {
            RenderingInfo rInfo = new RenderingInfo(this, renderer);
            renderer.process(this, result, rInfo);
        }
        int ii = 0;
        while (ii < this.children.size()) {
            AbstractPart part = ((AbstractPart)this.children.get(ii)).execute(context, renderer, listener);
            this.status = ITestResult.Status.max(this.status, part.status);
            this.children.set(ii, part);
            ++ii;
        }
        return this;
    }

    private boolean hasParameterThatNeedRefining() {
        String[] providers = this.params().getStringArray("derived_data_column");
        if (providers != null && providers.length > 0) {
            return true;
        }
        String sortColumn = this.params().get("sort_column");
        if (sortColumn != null) {
            return true;
        }
        String[] filters = this.params().getStringArray("filter");
        if (filters != null && filters.length > 0) {
            return true;
        }
        String[] hidden = this.params().getStringArray("hide_column");
        return hidden != null && hidden.length > 0;
    }

    private Spec buildFor(CompositeResult result) {
        String name = result.getName() != null ? result.getName() : this.spec().getName();
        SectionSpec spec = new SectionSpec(name);
        spec.setStatus(result.getStatus());
        String pattern = this.params().shallow().get("rendering.pattern");
        boolean isOverviewDetailsPattern = "overview_details".equals(pattern);
        int index = 1;
        for (CompositeResult.Entry entry : result.getResultEntries()) {
            String label = entry.getName();
            if (label == null && entry.getResult() instanceof Spec) {
                label = ((Spec)entry.getResult()).getName();
            }
            if (label == null) {
                label = String.valueOf(this.spec().getName()) + " " + index;
            }
            QuerySpec q = new QuerySpec(label);
            q.setResult(entry.getResult());
            if (index == 1 && isOverviewDetailsPattern) {
                q.set("rendering.pattern", "overview_details");
                q.set("html.is_important", this.params().get("html.is_important"));
            }
            spec.add(q);
            ++index;
        }
        return spec;
    }

    private void readParamsAndProcess(ResultRenderer renderer, IQueryContext context, IResult result, RefinedResultBuilder builder) throws IOException {
        builder.setInlineRetainedSizeCalculation(true);
        this.addDerivedDataColumns(context, builder, result);
        this.addSortOrder(builder);
        this.addFilter(builder);
        RenderingInfo rInfo = new RenderingInfo(this, renderer, builder.getColumns().size());
        this.addHiding(builder, rInfo);
        this.addHardLimit(rInfo);
        this.addShowTotals(rInfo);
        renderer.process(this, builder.build(), rInfo);
    }

    private void readParamsAndProcess(ResultRenderer renderer, RefinedStructuredResult result) throws IOException {
        RenderingInfo rInfo = new RenderingInfo(this, renderer, result.getColumns().length);
        this.addHardLimit(rInfo);
        this.addShowTotals(rInfo);
        renderer.process(this, result, rInfo);
    }

    private void addShowTotals(RenderingInfo rInfo) {
        rInfo.setShowTotals(this.params().getBoolean("html.show_totals", true));
    }

    private void addHiding(RefinedResultBuilder builder, RenderingInfo rInfo) {
        String[] hidden = this.params().getStringArray("hide_column");
        if (hidden == null || hidden.length == 0) {
            return;
        }
        String[] stringArray = hidden;
        int n = hidden.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            int columnIndex = this.getColumnIndex(builder, column);
            if (columnIndex < 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.QueryPart_Error_ColumnNotFound, column));
            } else {
                rInfo.setColumnVisible(columnIndex, false);
            }
            ++n2;
        }
    }

    private int getColumnIndex(RefinedResultBuilder builder, String column) {
        try {
            if (column.charAt(0) == '#') {
                return Integer.parseInt(column.substring(1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return builder.getColumnIndexByName(column);
    }

    private void addHardLimit(RenderingInfo info) {
        String MATUI_PLUGIN = "org.eclipse.mat.ui";
        int limit = Platform.getPreferencesService().getInt(MATUI_PLUGIN, "expand_entries", 25, null);
        info.setLimit(this.params().getInt("limit", limit));
    }

    private void localizeNumber(StringBuffer sb, String ss, Format in, Format out) {
        int pi = 0;
        while (pi < ss.length()) {
            ParsePosition p = new ParsePosition(pi);
            Object o = in.parseObject(ss, p);
            if (o != null) {
                sb.append(ss.substring(0, pi));
                out.format(o, sb, new FieldPosition(-1));
                sb.append(ss.substring(p.getIndex()));
                return;
            }
            ++pi;
        }
        sb.append(ss);
    }

    private void setFilter(RefinedResultBuilder builder, int col, String filter) {
        String filter2 = filter;
        Format fmt = builder.getColumns().get(col).getFormatter();
        if (fmt instanceof DecimalFormat) {
            DecimalFormat dfmt = (DecimalFormat)fmt;
            char decSep = dfmt.getDecimalFormatSymbols().getDecimalSeparator();
            char digit0 = dfmt.getDecimalFormatSymbols().getZeroDigit();
            char percent = dfmt.getDecimalFormatSymbols().getPercent();
            if (decSep != '.' && filter.indexOf(46) >= 0 || percent != '%' && filter.indexOf(37) >= 0 || dfmt.isDecimalSeparatorAlwaysShown() || dfmt.getPositiveSuffix().length() > 0 || dfmt.getNegativeSuffix().length() > 0 || digit0 != '0') {
                Locale eng = Locale.ENGLISH;
                NumberFormat in = dfmt.getMultiplier() > 1 || filter.indexOf(37) >= 0 ? NumberFormat.getPercentInstance((Locale)eng) : (dfmt.isParseIntegerOnly() ? NumberFormat.getIntegerInstance((Locale)eng) : NumberFormat.getNumberInstance((Locale)eng));
                String[] flts = filter.split("\\.\\.", 2);
                StringBuffer sb = new StringBuffer();
                this.localizeNumber(sb, flts[0], (Format)in, fmt);
                if (flts.length >= 2) {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
                        sb.append(digit0);
                    }
                    sb.append("..");
                    this.localizeNumber(sb, flts[1], (Format)in, fmt);
                }
                filter2 = sb.toString();
            }
        }
        builder.setFilter(col, filter2);
    }

    private void addFilter(RefinedResultBuilder builder) {
        String[] filters = this.params().getStringArray("filter");
        if (filters == null || filters.length == 0) {
            return;
        }
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            int p = filter.indexOf(61);
            if (p < 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.QueryPart_Error_MissingEqualsSign, filter));
            } else {
                int columnIndex = this.getColumnIndex(builder, filter.substring(0, p));
                if (columnIndex < 0) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.QueryPart_Error_ColumnNotFound, filter.substring(0, p)));
                } else {
                    try {
                        this.setFilter(builder, columnIndex, filter.substring(p + 1));
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.QueryPart_Error_Filter, filter.substring(p + 1)), e);
                    }
                }
            }
            ++n2;
        }
    }

    private void addDerivedDataColumns(IQueryContext context, RefinedResultBuilder builder, IResult result) {
        String[] providers = this.params().getStringArray("derived_data_column");
        if (providers == null || providers.length == 0) {
            return;
        }
        ResultMetaData metaData = result.getResultMetaData();
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            int p = provider.indexOf(61);
            if (p < 0) {
                ReportPlugin.log(2, MessageUtil.format(Messages.QueryPart_Error_InvalidProvider, "derived_data_column", provider));
            } else {
                String code = provider.substring(p + 1);
                ContextDerivedData.DerivedOperation operation = null;
                ContextDerivedData.DerivedColumn[] derivedColumnArray = context.getContextDerivedData().getDerivedColumns();
                int n3 = derivedColumnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ContextDerivedData.DerivedColumn derivedColumn = derivedColumnArray[n4];
                    ContextDerivedData.DerivedOperation[] derivedOperationArray = derivedColumn.getOperations();
                    int n5 = derivedOperationArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ContextDerivedData.DerivedOperation derivedOperation = derivedOperationArray[n6];
                        if (code.equals(derivedOperation.getCode())) {
                            operation = derivedOperation;
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                if (operation == null) {
                    ReportPlugin.log(2, MessageUtil.format(Messages.QueryPart_Error_InvalidProviderOperation, "derived_data_column", code));
                } else {
                    provider = provider.substring(0, p);
                    boolean added = false;
                    if ("_default_".equals(provider)) {
                        builder.addDefaultContextDerivedColumn(operation);
                        added = true;
                    } else if (metaData != null) {
                        for (ContextProvider cp : metaData.getContextProviders()) {
                            if (!provider.equals(cp.getLabel())) continue;
                            builder.addContextDerivedColumn(cp, operation);
                            added = true;
                            break;
                        }
                    }
                    if (!added) {
                        String msg = Messages.QueryPart_Error_RetainedSizeColumnNotFound;
                        Logger.getLogger(QueryPart.class.getName()).log(Level.WARNING, MessageUtil.format(msg, provider));
                    }
                }
            }
            ++n2;
        }
    }

    private void addSortOrder(RefinedResultBuilder builder) {
        String[] columns = this.params().getStringArray("sort_column");
        if (columns == null || columns.length == 0) {
            return;
        }
        ArrayInt indices = new ArrayInt(columns.length);
        ArrayList<Column.SortDirection> directions = new ArrayList<Column.SortDirection>(columns.length);
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            int p = column.indexOf(61);
            String name = p < 0 ? column : column.substring(0, p);
            Column.SortDirection direction = p < 0 ? null : Column.SortDirection.valueOf(column.substring(p + 1));
            int columnIndex = this.getColumnIndex(builder, name);
            if (columnIndex < 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, MessageUtil.format(Messages.QueryPart_Error_SortColumnNotFound, name));
            } else {
                indices.add(columnIndex);
                directions.add(direction);
            }
            ++n2;
        }
        builder.setSortOrder(indices.toArray(), directions.toArray(new Column.SortDirection[0]));
    }
}

