/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.core.gravatar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.Gravatar;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.GravatarUtils;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.IGravatarCallback;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.Messages;

public class GravatarStore
implements Serializable,
ISchedulingRule {
    public static final int TIMEOUT = 30000;
    public static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 6084425297832914970L;
    private long lastRefresh = 0L;
    private final String url;
    private Map<String, Gravatar> avatars;

    public GravatarStore() {
        this("https://www.gravatar.com/avatar/");
    }

    public GravatarStore(String url) {
        Assert.isNotNull((Object)url, (String)"Url cannot be null");
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.url = url;
    }

    public boolean isCacheEnabled() {
        return this.avatars != null;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        if (cacheEnabled && this.avatars == null) {
            this.avatars = Collections.synchronizedMap(new HashMap());
        } else if (!cacheEnabled && this.avatars != null) {
            this.avatars = null;
        }
    }

    public long getRefreshTime() {
        return this.lastRefresh;
    }

    public boolean containsGravatar(String hash) {
        return hash != null && this.avatars != null ? this.avatars.containsKey(hash) : false;
    }

    public GravatarStore scheduleRefresh() {
        Job refresh = new Job(Messages.GravatarStore_RefreshJobName){

            protected IStatus run(IProgressMonitor monitor) {
                GravatarStore.this.refresh(monitor);
                return Status.OK_STATUS;
            }
        };
        refresh.setRule((ISchedulingRule)this);
        refresh.schedule();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GravatarStore refresh(IProgressMonitor monitor) {
        if (this.avatars == null) {
            return this;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] entries = null;
        Map<String, Gravatar> map = this.avatars;
        synchronized (map) {
            entries = new String[this.avatars.size()];
            entries = this.avatars.keySet().toArray(entries);
        }
        monitor.beginTask("", entries.length);
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (monitor.isCanceled()) break;
            monitor.setTaskName(MessageFormat.format(Messages.GravatarStore_LoadingAvatar, entry));
            try {
                this.loadGravatarByHash(entry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
        this.lastRefresh = System.currentTimeMillis();
        return this;
    }

    public GravatarStore loadGravatarByHash(final String hash, final IGravatarCallback callback) {
        String title = MessageFormat.format(Messages.GravatarStore_LoadingAvatar, hash);
        Job job = new Job(title){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    try {
                        Gravatar avatar = GravatarStore.this.loadGravatarByHash(hash);
                        if (avatar != null && callback != null) {
                            callback.loaded(avatar);
                        }
                    }
                    catch (IOException e) {
                        if (callback == null) break block3;
                        callback.error(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this);
        job.schedule();
        return this;
    }

    public GravatarStore loadGravatarByEmail(String email, IGravatarCallback callback) {
        this.loadGravatarByHash(GravatarUtils.getHash(email), callback);
        return this;
    }

    public Gravatar loadGravatarByHash(String hash) throws IOException {
        return this.loadGravatarByHash(hash, -1, null);
    }

    public Gravatar loadGravatarByHash(String hash, int size, Rating rating) throws IOException {
        Assert.isLegal((size == -1 || size >= 1 && size <= 512 ? 1 : 0) != 0, (String)"size must have a value of -1 or between 1 and 512");
        if (!GravatarUtils.isValidHash(hash)) {
            return null;
        }
        Gravatar avatar = null;
        String location = this.url + hash + "?d=404";
        if (size != -1) {
            location = location + "&s=" + size;
        }
        if (rating != null) {
            location = location + "&r=" + rating.name().toLowerCase();
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(location).openConnection();
        connection.setConnectTimeout(30000);
        connection.setUseCaches(false);
        connection.connect();
        if (connection.getResponseCode() != 200) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream input = connection.getInputStream();){
            byte[] buffer = new byte[8192];
            int read = -1;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        avatar = new Gravatar(hash, System.currentTimeMillis(), output.toByteArray());
        if (this.avatars != null) {
            this.avatars.put(hash, avatar);
        }
        return avatar;
    }

    public Gravatar loadGravatarByEmail(String email) throws IOException {
        return this.loadGravatarByHash(GravatarUtils.getHash(email));
    }

    public Gravatar getGravatarByHash(String hash) {
        return hash != null && this.avatars != null ? this.avatars.get(hash) : null;
    }

    public Gravatar getGravatarByEmail(String email) {
        return this.getGravatarByHash(GravatarUtils.getHash(email));
    }

    public boolean contains(ISchedulingRule rule) {
        return this == rule;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    public static enum Rating {
        G,
        PG,
        R,
        X;

    }
}

