/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatementPart;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;

public class QVTimperativeUtil
extends QVTbaseUtil {
    public static @Nullable ImperativeTransformation basicGetContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof ImperativeTransformation) {
                return (ImperativeTransformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Mapping basicGetContainingMapping(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Mapping) {
                return (Mapping)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull Iterable<@NonNull EntryPoint> computeEntryPoints(@NonNull ImperativeTransformation iTransformation) {
        ArrayList<@NonNull EntryPoint> iMappings = new ArrayList<EntryPoint>();
        for (Mapping iMapping : QVTimperativeUtil.getOwnedMappings(iTransformation)) {
            if (!(iMapping instanceof EntryPoint)) continue;
            iMappings.add((EntryPoint)iMapping);
        }
        return iMappings;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Iterable<@NonNull Mapping> computeMappingClosure(@NonNull EntryPoint entryPoint) {
        @NonNull UniqueList mappings = new UniqueList();
        mappings.add((Object)entryPoint);
        int i = 0;
        while (i < mappings.size()) {
            for (EObject eObject : new TreeIterable((EObject)mappings.get(i), true)) {
                if (!(eObject instanceof MappingCall)) continue;
                mappings.add((Object)QVTimperativeUtil.getReferredMapping((MappingCall)eObject));
            }
            ++i;
        }
        return mappings;
    }

    public static @NonNull Class getClassType(@NonNull TypedElement typedElement) {
        return (Class)ClassUtil.nonNullState((Object)((Class)typedElement.getType()));
    }

    public static @NonNull Class getCompileTimeContextClass(@NonNull ImperativeTransformation iTransformation) {
        Parameter ownedContext = iTransformation.getOwnedContext();
        if (ownedContext != null) {
            return PivotUtil.getClass((TypedElement)ownedContext);
        }
        return iTransformation;
    }

    public static @NonNull Mapping getContainingMapping(@Nullable EObject eObject) {
        return (Mapping)ClassUtil.nonNullState((Object)QVTimperativeUtil.basicGetContainingMapping(eObject));
    }

    public static @Nullable Statement getContainingStatement(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Statement) {
                return (Statement)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull ImperativeTransformation getContainingTransformation(@Nullable EObject eObject) {
        return (ImperativeTransformation)ClassUtil.nonNullState((Object)QVTimperativeUtil.basicGetContainingTransformation(eObject));
    }

    public static @NonNull EntryPoint getDefaultEntryPoint(@NonNull ImperativeTransformation iTransformation) {
        return QVTimperativeUtil.computeEntryPoints(iTransformation).iterator().next();
    }

    public static @NonNull EntryPoint getEntryPoint(@NonNull ImperativeTransformation iTransformation, @NonNull String targetName) {
        for (Mapping iMapping : QVTimperativeUtil.getOwnedMappings(iTransformation)) {
            if (!(iMapping instanceof EntryPoint) || !targetName.equals(((EntryPoint)iMapping).getTargetName())) continue;
            return (EntryPoint)iMapping;
        }
        throw new IllegalArgumentException("Unknown entry point target name '" + targetName + "'");
    }

    public static @NonNull Iterable<@NonNull TypedModel> getInputTypedModels(@NonNull EntryPoint entryPoint) {
        return ClassUtil.nullFree(entryPoint.getInputTypedModels());
    }

    public static @NonNull String getName(@NonNull Mapping asMapping) {
        return (String)ClassUtil.nonNullState((Object)asMapping.getName());
    }

    public static @NonNull String getName(@NonNull MappingParameter asParameter) {
        return (String)ClassUtil.nonNullState((Object)asParameter.getName());
    }

    public static @NonNull Iterable<@NonNull Property> getObservedProperties(@NonNull ObservableStatement observableStatement) {
        return ClassUtil.nullFree(observableStatement.getObservedProperties());
    }

    public static @NonNull Iterable<@NonNull TypedModel> getOutputTypedModels(@NonNull EntryPoint entryPoint) {
        return ClassUtil.nullFree(entryPoint.getOutputTypedModels());
    }

    public static @NonNull OCLExpression getOwnedExpression(@NonNull NewStatementPart asNewStatementPart) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asNewStatementPart.getOwnedExpression());
    }

    public static @NonNull OCLExpression getOwnedExpression(@NonNull SetStatement asSetStatement) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asSetStatement.getOwnedExpression());
    }

    public static @NonNull Iterable<@NonNull OCLExpression> getOwnedExpressions(@NonNull SpeculateStatement speculateStatement) {
        return ClassUtil.nullFree(speculateStatement.getOwnedExpressions());
    }

    public static @NonNull Mapping getOwnedMapping(@NonNull ImperativeTransformation transformation, @Nullable String name) {
        return (Mapping)ClassUtil.nonNullState((Object)((Mapping)NameUtil.getNameable(QVTimperativeUtil.getOwnedMappings(transformation), (String)name)));
    }

    public static @NonNull Iterable<@NonNull MappingParameterBinding> getOwnedMappingParameterBindings(@NonNull MappingCall mappingCall) {
        return ClassUtil.nullFree(mappingCall.getOwnedMappingParameterBindings());
    }

    public static @NonNull Iterable<@NonNull MappingParameter> getOwnedMappingParameters(@NonNull Mapping mapping) {
        return ClassUtil.nullFree(mapping.getOwnedMappingParameters());
    }

    public static @NonNull Iterable<@NonNull Mapping> getOwnedMappings(@NonNull ImperativeTransformation transformation) {
        EList rule = transformation.getRule();
        return (Iterable)rule;
    }

    public static @NonNull Iterable<@NonNull Statement> getOwnedStatements(@NonNull Mapping iMapping) {
        return ClassUtil.nullFree(iMapping.getOwnedStatements());
    }

    public static @NonNull MappingCall getOwningMappingCall(@NonNull MappingParameterBinding mappingParameterBinding) {
        return (MappingCall)ClassUtil.nonNullState((Object)mappingParameterBinding.getOwningMappingCall());
    }

    public static @NonNull NewStatement getOwningNewStatement(@NonNull NewStatementPart newStatementPart) {
        return (NewStatement)ClassUtil.nonNullState((Object)newStatementPart.getOwningNewStatement());
    }

    public static @NonNull Mapping getReferredMapping(MappingCall asMappingCall) {
        return (Mapping)ClassUtil.nonNullState((Object)asMappingCall.getReferredMapping());
    }

    public static @NonNull Property getReferredProperty(@NonNull NewStatementPart asNewStatementPart) {
        return (Property)ClassUtil.nonNullState((Object)asNewStatementPart.getReferredProperty());
    }

    public static @NonNull TypedModel getReferredTypedModel(@NonNull GuardParameter asGuardParameter) {
        return (TypedModel)ClassUtil.nonNullState((Object)asGuardParameter.getReferredTypedModel());
    }

    public static @NonNull TypedModel getReferredTypedModel(@NonNull NewStatement asNewStatement) {
        return (TypedModel)ClassUtil.nonNullState((Object)asNewStatement.getReferredTypedModel());
    }

    public static @NonNull TypedModel getReferredTypedModel(@NonNull SimpleParameter asSimpleParameter) {
        return (TypedModel)ClassUtil.nonNullState((Object)asSimpleParameter.getReferredTypedModel());
    }

    public static @NonNull Class getRuntimeContextClass(@NonNull ImperativeTransformation iTransformation) {
        Class contextClass = iTransformation.getContextType();
        if (contextClass != null) {
            return contextClass;
        }
        Parameter ownedContext = iTransformation.getOwnedContext();
        if (ownedContext != null) {
            return PivotUtil.getClass((TypedElement)ownedContext);
        }
        return iTransformation;
    }

    public static @NonNull Property getSuccessProperty(@NonNull GuardParameter asMappingParameter) {
        return (Property)ClassUtil.nonNullState((Object)asMappingParameter.getSuccessProperty());
    }

    public static @NonNull Property getTargetProperty(@NonNull SetStatement asSetStatement) {
        Property referredProperty = (Property)ClassUtil.nonNullState((Object)asSetStatement.getTargetProperty());
        if (asSetStatement.isIsOpposite()) {
            if (referredProperty.eIsProxy()) {
                throw new IllegalStateException("Unresolved target property proxy '" + EcoreUtil.getURI((EObject)referredProperty) + "' at '" + EcoreUtil.getURI((EObject)asSetStatement) + "'");
            }
            return (Property)ClassUtil.nonNullState((Object)referredProperty.getOpposite());
        }
        return referredProperty;
    }

    public static @NonNull VariableDeclaration getTargetVariable(@NonNull SetStatement asSetStatement) {
        return (VariableDeclaration)ClassUtil.nonNullState((Object)asSetStatement.getTargetVariable());
    }

    public static boolean isObserver(@NonNull Mapping asMapping) {
        boolean isHazardous = false;
        for (Statement asStatement : ClassUtil.nullFree(asMapping.getOwnedStatements())) {
            if (!(asStatement instanceof ObservableStatement) || ((ObservableStatement)asStatement).getObservedProperties().size() <= 0) continue;
            return true;
        }
        return isHazardous;
    }

    public static boolean isInput(@NonNull TypedModel typedModel) {
        Transformation transformation = QVTimperativeUtil.getOwningTransformation((TypedModel)typedModel);
        for (Rule rule : QVTimperativeUtil.getRule((Transformation)transformation)) {
            if (!(rule instanceof EntryPoint) || !Iterables.contains(QVTimperativeUtil.getInputTypedModels((EntryPoint)rule), (Object)typedModel)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutput(@NonNull TypedModel typedModel) {
        Transformation transformation = QVTimperativeUtil.getOwningTransformation((TypedModel)typedModel);
        for (Rule rule : QVTimperativeUtil.getRule((Transformation)transformation)) {
            if (!(rule instanceof EntryPoint) || !Iterables.contains(QVTimperativeUtil.getOutputTypedModels((EntryPoint)rule), (Object)typedModel)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveVariable(@NonNull VariableDeclaration asVariable) {
        return !(asVariable.getType() instanceof CollectionType);
    }

    public static @NonNull ImperativeTransformation loadTransformation(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTiEnvironmentFactory.CREATE_STRATEGY);
        try {
            ImperativeTransformation imperativeTransformation = (ImperativeTransformation)QVTimperativeUtil.loadTransformation(ImperativeModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            return imperativeTransformation;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void sortPatternVariables(@NonNull List<@NonNull ? extends Variable> variables) {
        if (variables.size() > 1) {
            boolean bl;
            HashMap<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs = new HashMap<Variable, List<VariableDeclaration>>();
            for (Variable variable : variables) {
                def2refs.put(variable, null);
            }
            for (Variable variable : variables) {
                ArrayList<VariableDeclaration> refs = null;
                OCLExpression initExpression = variable.getOwnedInit();
                if (initExpression == null) continue;
                for (EObject eObject : new TreeIterable((EObject)initExpression, true)) {
                    if (!(eObject instanceof VariableExp)) continue;
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    assert (referredVariable != null);
                    if (!def2refs.containsKey(referredVariable)) continue;
                    if (refs == null) {
                        refs = new ArrayList<VariableDeclaration>();
                        def2refs.put(variable, refs);
                    }
                    if (refs.contains(referredVariable)) continue;
                    refs.add(referredVariable);
                }
            }
            boolean bl2 = true;
            while (bl) {
                bl = false;
                for (Variable variable : def2refs.keySet()) {
                    @NonNull List refs = (List)def2refs.get(variable);
                    if (refs == null) continue;
                    int i = 0;
                    while (i < refs.size()) {
                        VariableDeclaration ref = (VariableDeclaration)refs.get(i);
                        @NonNull List refRefs = (List)def2refs.get(ref);
                        if (refRefs != null) {
                            for (VariableDeclaration refRef : refRefs) {
                                if (refs.contains(refRef)) continue;
                                refs.add(refRef);
                                bl = true;
                            }
                        }
                        ++i;
                    }
                }
            }
            ClassUtil.sort(variables, (Comparator)new PatternVariableComparator(def2refs));
        }
    }

    public static class Internal
    extends QVTbaseUtil.Internal {
        public static @NonNull List<@NonNull OCLExpression> getOwnedExpressionsList(@NonNull SpeculateStatement asSpeculateStatement) {
            return ClassUtil.nullFree(asSpeculateStatement.getOwnedExpressions());
        }
    }

    public static final class MappingParameterBindingComparator
    implements Comparator<MappingParameterBinding> {
        public static final @NonNull MappingParameterBindingComparator INSTANCE = new MappingParameterBindingComparator();

        @Override
        public int compare(@NonNull MappingParameterBinding o1, @NonNull MappingParameterBinding o2) {
            MappingParameter v1 = o1.getBoundVariable();
            MappingParameter v2 = o2.getBoundVariable();
            String n1 = v1 != null ? v1.getName() : null;
            String n2 = v2 != null ? v2.getName() : null;
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    protected static class PatternVariableComparator
    implements Comparator<Variable> {
        private final @NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs;

        protected PatternVariableComparator(@NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs) {
            this.def2refs = def2refs;
        }

        @Override
        public int compare(@NonNull Variable o1, @NonNull Variable o2) {
            int s2;
            List<@NonNull VariableDeclaration> l1 = this.def2refs.get(o1);
            List<@NonNull VariableDeclaration> l2 = this.def2refs.get(o2);
            int s1 = l1 != null ? l1.size() : 0;
            int n = s2 = l2 != null ? l2.size() : 0;
            if (s1 != s2) {
                return s1 - s2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

