/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.thread;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.ui.interpreter.internal.language.CompilationResult;
import org.eclipse.sirius.ui.interpreter.internal.view.InterpreterView;
import org.eclipse.swt.widgets.Display;

public class CompilationThread
extends Thread {
    private boolean cancelled;
    private Future<CompilationResult> compilationTask;
    private InterpreterView interpreterView;

    public CompilationThread(Future<CompilationResult> compilationTask, InterpreterView interpreterView) {
        super("InterpreterCompilationThread");
        this.compilationTask = compilationTask;
        this.interpreterView = interpreterView;
    }

    @Override
    public void interrupt() {
        this.cancelled = true;
        this.compilationTask.cancel(true);
        super.interrupt();
    }

    @Override
    public void run() {
        try {
            final CompilationResult result = this.compilationTask.get();
            this.checkCancelled();
            if (result != null && result.getStatus() != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CompilationThread.this.interpreterView.clearCompilationMessages();
                        CompilationThread.this.checkCancelled();
                        CompilationThread.this.interpreterView.addStatusMessages(result.getStatus(), "compilation.message");
                    }
                });
            }
            this.interpreterView.setCompilationResult(result);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException e) {
            this.checkCancelled();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            Status status = new Status(4, "org.eclipse.sirius.ui.interpreter", message);
            CompilationResult result = new CompilationResult((IStatus)status);
            Display.getDefault().asyncExec(new Runnable((IStatus)status){
                private final /* synthetic */ IStatus val$status;
                {
                    this.val$status = iStatus;
                }

                @Override
                public void run() {
                    CompilationThread.this.interpreterView.clearCompilationMessages();
                    CompilationThread.this.checkCancelled();
                    CompilationThread.this.interpreterView.addStatusMessages(this.val$status, "compilation.message");
                }
            });
            this.interpreterView.setCompilationResult(result);
        }
    }

    protected void checkCancelled() {
        if (this.cancelled) {
            throw new CancellationException();
        }
    }
}

