/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.ecore.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.emf.exporter.util.ExporterUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ecore.exporter.UMLExporterPlugin;
import org.eclipse.uml2.uml.resource.CMOF2UMLResource;
import org.eclipse.uml2.uml.resource.XMI2UMLResource;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLExporter
extends ModelExporter {
    protected final Map<String, String> options = new HashMap<String, String>();

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getID() {
        return "org.eclipse.uml2.uml.ecore.exporter";
    }

    protected String getDefaultArtifactLocation(EPackage ePackage) {
        return String.valueOf(this.getDefaultArtifactFileName(ePackage)) + '.' + "uml";
    }

    protected String doCheckEPackageArtifactLocation(String location, String packageName) {
        if (!(location.endsWith(".uml") || location.endsWith(".xmi") || location.endsWith(".cmof"))) {
            return UMLExporterPlugin.INSTANCE.getString("_UI_InvalidArtifactFileNameExtension_message");
        }
        return super.doCheckEPackageArtifactLocation(location, packageName);
    }

    protected Diagnostic doExport(Monitor monitor, ModelExporter.ExportData exportData) throws Exception {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("xmi", XMI2UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("cmof", CMOF2UMLResource.Factory.INSTANCE);
        UMLUtil.Ecore2UMLConverter ecore2umlConverter = new UMLUtil.Ecore2UMLConverter((ResourceSet)resourceSet){
            private final /* synthetic */ ResourceSet val$resourceSet;
            {
                this.val$resourceSet = resourceSet;
            }

            protected Profile getEcoreProfile(EObject eObject) {
                return (Profile)UMLUtil.load((ResourceSet)this.val$resourceSet, (URI)URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"), (EClass)UMLPackage.Literals.PROFILE);
            }

            protected void processEcoreTaggedValues(Element element, EPackage ePackage, Map<String, String> options, DiagnosticChain diagnostics, Map<Object, Object> context) {
                Stereotype ePackageStereotype;
                super.processEcoreTaggedValues(element, ePackage, options, diagnostics, context);
                GenPackage genPackage = (GenPackage)UMLExporter.this.getEPackageToGenPackageMap().get(ePackage);
                if (genPackage != null && (ePackageStereotype = this.getEcoreStereotype((EModelElement)ePackage, "EPackage")) != null) {
                    UMLUtil.safeApplyStereotype((Element)element, (Stereotype)ePackageStereotype);
                    this.processEcoreTaggedValue(element, ePackageStereotype, "basePackage", genPackage.getBasePackage(), options, diagnostics, context);
                }
            }
        };
        BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.emf.converter", 0, UMLExporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessing_message"), null);
        HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider> context = new HashMap<Class<UML2Util.QualifiedTextProvider>, UMLUtil.QualifiedTextProvider>();
        context.put(UML2Util.QualifiedTextProvider.class, UMLUtil.QualifiedTextProvider.DEFAULT);
        monitor.beginTask("", exportData.genPackageToArtifactURI.size());
        ArrayList<Resource> resourcesToSave = new ArrayList<Resource>();
        for (Map.Entry entry : exportData.genPackageToArtifactURI.entrySet()) {
            URI artifactURI = (URI)entry.getValue();
            Resource resource = resourceSet.createResource(artifactURI);
            resourcesToSave.add(resource);
            EPackage ePackage = ((GenPackage)entry.getKey()).getEcorePackage();
            monitor.subTask(UMLExporterPlugin.INSTANCE.getString("_UI_Exporting_message", new Object[]{artifactURI.toString()}));
            ecore2umlConverter.convert(Collections.singleton(ePackage), this.getOptions(), (DiagnosticChain)diagnostics, context);
            Package package_ = (Package)ecore2umlConverter.doSwitch((EObject)ePackage);
            EList contents = resource.getContents();
            contents.add((Object)package_);
            TreeIterator allContents = UML2Util.getAllContents((EObject)package_, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                contents.addAll((Collection)((Element)eObject).getStereotypeApplications());
            }
            if ("PROCESS".equals(this.options.get("XMI_IDENTIFIERS")) && resource instanceof XMIResource) {
                XMIResource xmiResource = (XMIResource)resource;
                TreeIterator allContents2 = xmiResource.getAllContents();
                while (allContents2.hasNext()) {
                    EObject eObject = (EObject)allContents2.next();
                    String xmiIdentifier = UML2Util.getXMIIdentifier((InternalEObject)((InternalEObject)eObject));
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2.uml", 3008, UMLPlugin.INSTANCE.getString("_UI_Ecore2UMLConverter_ProcessXMIIdentifier_diagnostic", UML2Util.getMessageSubstitutions(context, (Object)eObject, (Object)xmiIdentifier)), new Object[]{eObject}));
                    }
                    xmiResource.setID(eObject, xmiIdentifier);
                }
            }
            monitor.worked(1);
        }
        for (Map.Entry entry : exportData.referencedGenPackagesToArtifactURI.entrySet()) {
            Resource referencedResource = resourceSet.getResource((URI)entry.getValue(), true);
            if (referencedResource != null) {
                Package package_ = (Package)ecore2umlConverter.doSwitch((EObject)this.getReferredEPackage((GenPackage)entry.getKey()));
                TreeIterator allContents = UML2Util.getAllContents((EObject)package_, (boolean)true, (boolean)false);
                while (allContents.hasNext()) {
                    Collection namedElements;
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof NamedElement) || (namedElements = UMLUtil.findNamedElements((Resource)referencedResource, (String)((NamedElement)eObject).getQualifiedName(), (boolean)true)).size() != 1) continue;
                    ((InternalEObject)eObject).eSetProxyURI(EcoreUtil.getURI((EObject)((EObject)namedElements.iterator().next())));
                }
            }
            monitor.worked(1);
        }
        for (Resource resource : resourcesToSave) {
            resource.save(null);
        }
        monitor.done();
        if (1 < diagnostics.getSeverity()) {
            diagnostic = diagnostics;
        }
        return diagnostic;
    }

    protected boolean isValidEPackage(GenPackage genPackage) {
        EPackage ecorePackage = genPackage.getEcorePackage();
        return ecorePackage != null && ecorePackage.getESuperPackage() == null;
    }

    public void setGenModel(GenModel genModel) throws DiagnosticException {
        super.setGenModel(genModel);
        Ecore2UMLConverter converter = new Ecore2UMLConverter();
        ModelExporter.GenPackagesTreeIterator genPackages = new ModelExporter.GenPackagesTreeIterator(genModel);
        while (genPackages.hasNext()) {
            GenPackage genPackage = (GenPackage)genPackages.next();
            if (!this.isValidEPackage(genPackage)) continue;
            converter.convert(Collections.singleton(genPackage.getEcorePackage()), this.getOptions(), null, null);
        }
        Map ePackageToGenPackageMap = this.getEPackageToGenPackageMap();
        List ePackages = this.getEPackages();
        for (EPackage convertedEPackage : converter.getEcorePackages()) {
            GenPackage convertedGenPackage = genModel.findGenPackage(convertedEPackage);
            if (convertedGenPackage == null || !this.isValidEPackage(convertedGenPackage)) continue;
            ePackageToGenPackageMap.put(convertedEPackage, convertedGenPackage);
            String nsURI = convertedEPackage.getNsURI();
            int i = 0;
            while (i < ePackages.size()) {
                EPackage ePackage = (EPackage)ePackages.get(i);
                if (ePackage != convertedEPackage && UML2Util.safeEquals((Object)ePackage.getNsURI(), (Object)nsURI)) {
                    ePackages.remove(i);
                    ePackages.add(i, convertedEPackage);
                }
                ++i;
            }
            if (ePackages.contains(convertedEPackage)) continue;
            ePackages.add(convertedEPackage);
        }
        this.adjustGenModel();
        genModel = this.getGenModel();
        if (genModel != null) {
            this.getOptions().putAll(ExporterUtil.findOrCreateGenAnnotation((GenBase)genModel, (String)this.getConverterGenAnnotationSource()).getDetails().map());
        }
    }

    protected boolean saveExporter() {
        boolean changed = super.saveExporter();
        GenModel genModel = this.getGenModel();
        GenAnnotation genAnnotation = genModel.getGenAnnotation(this.getConverterGenAnnotationSource());
        if (genAnnotation == null) {
            changed = true;
            ExporterUtil.findOrCreateGenAnnotation((GenBase)genModel, (String)this.getConverterGenAnnotationSource()).getDetails().putAll(this.getOptions());
        } else {
            EMap details = genAnnotation.getDetails();
            for (Map.Entry<String, String> entry : this.getOptions().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.equals(details.get((Object)key))) continue;
                changed = true;
                details.put((Object)key, (Object)value);
            }
        }
        return changed;
    }

    protected ModelConverter.ReferencedGenPackageConvertInfo createGenPackageConvertInfo(GenPackage genPackage) {
        ModelExporter.ReferencedGenPackageExportInfo genPackageInfo = (ModelExporter.ReferencedGenPackageExportInfo)super.createGenPackageConvertInfo(genPackage);
        if (this.getExporterNestedGenAnnotations((GenBase)genPackage).isEmpty()) {
            String nsURI = genPackage.getEcorePackage().getNsURI();
            if ("http://www.eclipse.org/emf/2002/Ecore".equals(nsURI)) {
                genPackageInfo.setArtifactURI(URI.createURI((String)"pathmap://UML_METAMODELS/Ecore.metamodel.uml"));
            } else if ("http://www.eclipse.org/uml2/5.0.0/Types".equals(nsURI)) {
                genPackageInfo.setArtifactURI(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
            } else if ("http://www.eclipse.org/uml2/5.0.0/UML".equals(nsURI)) {
                genPackageInfo.setArtifactURI(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"));
            } else if ("http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard".equals(nsURI)) {
                genPackageInfo.setArtifactURI(URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml"));
            }
            genPackageInfo.setValidReference(genPackageInfo.getArtifactURI() != null);
        }
        return genPackageInfo;
    }

    private static final class Ecore2UMLConverter
    extends UMLUtil.Ecore2UMLConverter {
        private Ecore2UMLConverter() {
        }

        private Collection<EPackage> getEcorePackages() {
            return EcoreUtil.getObjectsByType(this.eModelElementToElementMap.keySet(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        }
    }
}

