/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;

public final class CachingLayoutRequestValidator
implements ILayoutRequestValidator {
    private final ILayoutRequestValidator m_validator;

    public CachingLayoutRequestValidator(ILayoutRequestValidator validator) {
        this.m_validator = validator;
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        Map<EditPart, Boolean> cache = this.getCache((Request)request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateCreateRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        Map<EditPart, Boolean> cache = this.getCache((Request)request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validatePasteRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        Map<EditPart, Boolean> cache = this.getCache((Request)request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateMoveRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        Map<EditPart, Boolean> cache = this.getCache((Request)request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateAddRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    private Map<EditPart, Boolean> getCache(Request request) {
        HashMap cache = (HashMap)request.getExtendedData().get(this);
        if (cache == null) {
            cache = new HashMap();
            request.getExtendedData().put(this, cache);
        }
        return cache;
    }
}

