/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.css.core.internal.cleanup.CleanupProcessorCSS;
import org.eclipse.wst.css.ui.internal.edit.ui.CleanupDialogCSS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class CleanupDocumentHandler
extends AbstractHandler
implements IHandler {
    private IStructuredCleanupProcessor fCleanupProcessor;

    public void dispose() {
        this.fCleanupProcessor = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor editor;
        CleanupDialogCSS cleanupDialog;
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        } else {
            Object o = editorPart.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (cleanupDialog = new CleanupDialogCSS((editor = textEditor).getSite().getShell())).open() == 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IStructuredCleanupProcessor cleanupProcessor = CleanupDocumentHandler.this.getCleanupProcessor();
                    if (cleanupProcessor != null) {
                        IStructuredModel model = null;
                        try {
                            model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                            if (model != null) {
                                cleanupProcessor.cleanupModel(model);
                            }
                        }
                        finally {
                            if (model != null) {
                                model.releaseFromEdit();
                            }
                        }
                    }
                }
            };
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                if (model != null) {
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.beginRecording((Object)this, SSEUIMessages.Cleanup_Document_UI_, SSEUIMessages.Cleanup_Document_UI_, selection.getOffset(), selection.getLength());
                    model.aboutToChangeModel();
                    BusyIndicator.showWhile((Display)editor.getEditorSite().getWorkbenchWindow().getShell().getDisplay(), (Runnable)runnable);
                }
            }
            finally {
                if (model != null) {
                    model.changedModel();
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.endRecording((Object)this, selection.getOffset(), selection.getLength());
                    model.releaseFromEdit();
                }
            }
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    IStructuredCleanupProcessor getCleanupProcessor() {
        if (this.fCleanupProcessor == null) {
            this.fCleanupProcessor = new CleanupProcessorCSS();
        }
        return this.fCleanupProcessor;
    }
}

