/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;

public abstract class FigureSubgraph
extends DefaultSubgraph {
    protected IFigure figure;
    private DisplayIndependentPoint location;
    private boolean isLayoutBeingApplied = false;

    protected abstract void createFigure();

    protected abstract void updateFigure();

    public IFigure getFigure() {
        if (this.figure == null) {
            this.createFigure();
            this.updateFigure();
            this.figure.addFigureListener((FigureListener)new SubgraphFigrueListener());
            this.context.container.addSubgraphFigure(this.figure);
        }
        return this.figure;
    }

    protected FigureSubgraph(NodeLayout[] nodes, LayoutContext context) {
        super(context);
        this.addNodes(nodes);
    }

    @Override
    public void addNodes(NodeLayout[] nodes) {
        int initialCount = this.nodes.size();
        super.addNodes(nodes);
        if (this.nodes.size() > initialCount && this.figure != null) {
            this.updateFigure();
            if (this.location != null) {
                NodeLayout[] nodeLayoutArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeLayout node = nodeLayoutArray[n2];
                    node.setLocation(this.location.x, this.location.y);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void removeNodes(NodeLayout[] nodes) {
        int initialCount = this.nodes.size();
        super.removeNodes(nodes);
        if (this.nodes.size() < initialCount && this.figure != null && !this.disposed) {
            this.updateFigure();
        }
    }

    @Override
    public EntityLayout[] getSuccessingEntities() {
        return super.getSuccessingEntities();
    }

    @Override
    public EntityLayout[] getPredecessingEntities() {
        return super.getPredecessingEntities();
    }

    @Override
    public DisplayIndependentDimension getSize() {
        Dimension size = this.getFigure().getSize();
        return new DisplayIndependentDimension((double)size.width, (double)size.height);
    }

    @Override
    public DisplayIndependentPoint getLocation() {
        if (this.location == null) {
            Point location2 = this.getFigure().getBounds().getLocation();
            Dimension size = this.getFigure().getSize();
            return new DisplayIndependentPoint((double)(location2.x + size.width / 2), (double)(location2.y + size.height / 2));
        }
        return new DisplayIndependentPoint(this.location);
    }

    @Override
    public void setLocation(double x, double y) {
        super.setLocation(x, y);
        for (Object node2 : this.nodes) {
            NodeLayout node = (NodeLayout)node2;
            node.setLocation(x, y);
        }
        if (this.location != null) {
            this.location.x = x;
            this.location.y = y;
        } else {
            this.location = new DisplayIndependentPoint(x, y);
            this.applyLayoutChanges();
        }
    }

    @Override
    protected void refreshLocation() {
        Rectangle bounds = this.figure.getBounds();
        if (this.location == null) {
            this.location = new DisplayIndependentPoint(0.0, 0.0);
        }
        this.location.x = bounds.x + bounds.width / 2;
        this.location.y = bounds.y + bounds.height / 2;
    }

    @Override
    public boolean isGraphEntity() {
        return true;
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    protected void dispose() {
        if (!this.disposed) {
            super.dispose();
            if (this.figure != null) {
                this.context.container.getGraph().removeSubgraphFigure(this.figure);
            }
        }
    }

    @Override
    protected void applyLayoutChanges() {
        this.getFigure();
        if (this.location != null) {
            this.isLayoutBeingApplied = true;
            Dimension size = this.figure.getSize();
            this.figure.setLocation((Point)new PrecisionPoint(this.location.x - (double)(size.width / 2), this.location.y - (double)(size.height / 2)));
            this.isLayoutBeingApplied = false;
        }
    }

    protected class SubgraphFigrueListener
    implements FigureListener {
        private Rectangle previousBounds;

        protected SubgraphFigrueListener() {
            this.previousBounds = FigureSubgraph.this.figure.getBounds().getCopy();
        }

        public void figureMoved(IFigure source) {
            if (Animation.isAnimating() || FigureSubgraph.this.isLayoutBeingApplied) {
                return;
            }
            Rectangle newBounds = FigureSubgraph.this.figure.getBounds();
            if (!newBounds.getSize().equals((Object)this.previousBounds.getSize())) {
                FigureSubgraph.this.context.fireSubgraphResizedEvent(FigureSubgraph.this);
            } else if (!newBounds.getLocation().equals((Object)this.previousBounds.getLocation())) {
                FigureSubgraph.this.context.fireSubgraphMovedEvent(FigureSubgraph.this);
            }
            this.previousBounds = newBounds.getCopy();
        }
    }
}

