/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.SoftAssertionsProvider;
import org.assertj.core.error.AssertionErrorCreator;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

class SoftAssertionsStatement {
    private SoftAssertionsProvider soft;
    private AssertionErrorCreator assertionErrorCreator = new AssertionErrorCreator();

    private SoftAssertionsStatement(SoftAssertionsProvider soft) {
        this.soft = soft;
    }

    public static Statement softAssertionsStatement(SoftAssertionsProvider softAssertions, Statement baseStatement) {
        return new SoftAssertionsStatement(softAssertions).build(baseStatement);
    }

    private Statement build(final Statement baseStatement) {
        return new Statement(this){
            final /* synthetic */ SoftAssertionsStatement this$0;
            {
                this.this$0 = this$0;
            }

            public void evaluate() throws Throwable {
                baseStatement.evaluate();
                List<AssertionError> errors = this.this$0.soft.assertionErrorsCollected();
                if (errors.isEmpty()) {
                    return;
                }
                this.this$0.assertionErrorCreator.tryThrowingMultipleFailuresError(errors);
                MultipleFailureException.assertEmpty(new ArrayList<AssertionError>(errors));
            }
        };
    }
}

