/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.transport.nntp;

import java.io.PrintStream;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.NewsAddress;
import org.apache.geronimo.javamail.transport.nntp.NNTPConnection;
import org.apache.geronimo.javamail.transport.nntp.NNTPReply;
import org.apache.geronimo.mail.util.SessionUtil;

public class NNTPTransport
extends Transport {
    protected static final String NNTP_AUTH = "auth";
    protected static final String NNTP_PORT = "port";
    protected static final String NNTP_FROM = "from";
    protected static final String protocol = "nntp-post";
    protected static final int DEFAULT_NNTP_PORT = 119;
    protected NNTPConnection connection;
    protected PrintStream debugStream;

    public NNTPTransport(Session session, URLName name) {
        super(session, name);
        this.debugStream = session.getDebugOut();
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        boolean mustAuthenticate;
        if (this.debug) {
            this.debugOut("Connecting to server " + host + ":" + port + " for user " + username);
        }
        if ((mustAuthenticate = SessionUtil.getBooleanProperty(this.session, NNTP_AUTH, false)) && (username == null || password == null)) {
            return false;
        }
        if (port == -1) {
            port = SessionUtil.getIntProperty(this.session, NNTP_PORT, 119);
        }
        this.connection = new NNTPConnection(protocol, this.session, host, port, username, password, this.debug);
        this.connection.connect();
        return true;
    }

    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        String defaultFrom;
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (!this.connection.isPostingAllowed()) {
            throw new MessagingException("Posting disabled for host server");
        }
        if (message == null) {
            throw new MessagingException("Null message");
        }
        if (!(message instanceof MimeMessage)) {
            throw new MessagingException("NNTP can only send MimeMessages");
        }
        Object from = null;
        Address[] fromAddresses = message.getFrom();
        if ((fromAddresses == null || fromAddresses.length == 0) && (defaultFrom = this.session.getProperty(NNTP_FROM)) == null) {
            message.setFrom(new InternetAddress(defaultFrom));
        }
        if (addresses == null || addresses.length == 0) {
            throw new MessagingException("Null or empty address array");
        }
        boolean haveGroup = false;
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] instanceof NewsAddress) continue;
            System.out.println("Illegal address is of class " + addresses[i].getClass());
            throw new MessagingException("Illegal NewsAddress " + addresses[i]);
        }
        ArrayList<Address> sentAddresses = new ArrayList<Address>();
        ArrayList<Address> unsentAddresses = new ArrayList<Address>();
        ArrayList<Address> invalidAddresses = new ArrayList<Address>();
        boolean sendFailure = false;
        for (int i = 0; i < addresses.length; ++i) {
            try {
                NNTPReply reply = this.connection.selectGroup(((NewsAddress)addresses[i]).getNewsgroup());
                if (reply.getCode() != 211) {
                    invalidAddresses.add(addresses[i]);
                    sendFailure = true;
                    continue;
                }
                this.connection.sendPost(message);
                sentAddresses.add(addresses[i]);
                continue;
            }
            catch (MessagingException e) {
                unsentAddresses.add(addresses[i]);
                sendFailure = true;
            }
        }
        Address[] sent = sentAddresses.toArray(new Address[0]);
        Address[] unsent = unsentAddresses.toArray(new Address[0]);
        Address[] invalid = invalidAddresses.toArray(new Address[0]);
        if (sendFailure) {
            if (sent.length == 0) {
                this.notifyTransportListeners(2, sent, unsent, invalid, message);
            } else {
                this.notifyTransportListeners(3, sent, unsent, invalid, message);
            }
            throw new MessagingException("Error posting NNTP message");
        }
        this.notifyTransportListeners(1, sent, unsent, invalid, message);
    }

    public void close() throws MessagingException {
        super.close();
        this.connection.close();
        this.connection = null;
    }

    protected void debugOut(String message) {
        this.debugStream.println("NNTPTransport DEBUG: " + message);
    }

    protected void debugOut(String message, Throwable e) {
        this.debugOut("Received exception -> " + message);
        this.debugOut("Exception message -> " + e.getMessage());
        e.printStackTrace(this.debugStream);
    }

    String getProperty(String name) {
        String fullName = "mail.nntp-post." + name;
        return this.session.getProperty(fullName);
    }

    String getProperty(String name, String defaultValue) {
        String fullName = "mail.nntp-post." + name;
        return SessionUtil.getProperty(this.session, fullName, defaultValue);
    }

    int getIntProperty(String name, int defaultValue) {
        String fullName = "mail.nntp-post." + name;
        return SessionUtil.getIntProperty(this.session, fullName, defaultValue);
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String fullName = "mail.nntp-post." + name;
        return SessionUtil.getBooleanProperty(this.session, fullName, defaultValue);
    }
}

