/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.dltk.internal.debug.ui.actions.Messages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptEvaluationAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IPartListener,
IScriptEvaluationListener,
IEditorActionDelegate,
IViewActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private IAction action;
    private Object selectedObject;
    private boolean evaluation;
    private ScriptEditor editor;

    protected static IDebugModelPresentation getDebugModelPresentation(String identifier) {
        return DebugUITools.newDebugModelPresentation((String)identifier);
    }

    private void setWindow(IWorkbenchWindow window) {
        this.window = window;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    protected IWorkbenchPart getPart() {
        return this.editor != null ? this.editor : this.part;
    }

    private void setAction(IAction action) {
        this.action = action;
    }

    protected IAction getAction() {
        return this.action;
    }

    private void setSelectedObject(Object object) {
        this.selectedObject = object;
    }

    protected Object getSelectedObject() {
        return this.selectedObject;
    }

    private void setEvaluating(boolean evaluation) {
        this.evaluation = evaluation;
    }

    protected boolean isEvaluating() {
        return this.evaluation;
    }

    protected void evaluationCleanup() {
        this.setEvaluating(false);
    }

    private void setEditor(ScriptEditor editor) {
        this.editor = editor;
    }

    protected ScriptEditor getEditor() {
        return this.editor;
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        this.update();
    }

    public void dispose() {
        IWorkbenchWindow window = this.getWindow();
        if (window != null) {
            window.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setPart(targetPart);
        this.update();
    }

    public void run(IAction action) {
        this.update();
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getPart()) {
            this.setPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            ObjectResolver or = new ObjectResolver(this.getPart());
            this.setSelectedObject(or.resolveSelectedObject());
        }
    }

    protected void showExpressionView() {
        if (this.getPart().getSite().getId().equals("org.eclipse.debug.ui.ExpressionView")) {
            return;
        }
        IWorkbenchPage page = DLTKDebugUIPlugin.getActivePage();
        if (page != null) {
            IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
            if (part == null) {
                try {
                    page.showView("org.eclipse.debug.ui.ExpressionView");
                }
                catch (PartInitException partInitException) {}
            } else {
                page.bringToTop((IWorkbenchPart)part);
            }
        }
    }

    public static StyledText getStyledText(IWorkbenchPart part) {
        ITextViewer viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        StyledText textWidget = null;
        if (viewer == null) {
            Control control = (Control)part.getAdapter(Control.class);
            if (control instanceof StyledText) {
                textWidget = (StyledText)control;
            }
        } else {
            textWidget = viewer.getTextWidget();
        }
        return textWidget;
    }

    public static Point getPopupAnchor(StyledText textWidget) {
        if (textWidget != null) {
            Point docRange = textWidget.getSelectionRange();
            int midOffset = docRange.x + docRange.y / 2;
            Point point = textWidget.getLocationAtOffset(midOffset);
            point = textWidget.toDisplay(point);
            GC gc = new GC((Drawable)textWidget);
            gc.setFont(textWidget.getFont());
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            point.y += height;
            return point;
        }
        return null;
    }

    protected Shell getShell() {
        if (this.getPart() != null) {
            return this.getPart().getSite().getShell();
        }
        return DLTKDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected IScriptStackFrame getStackFrameContext() {
        IWorkbenchPart part = this.getPart();
        IScriptStackFrame frame = null;
        frame = part == null ? ScriptEvaluationContextManager.getEvaluationContext(this.getWindow()) : ScriptEvaluationContextManager.getEvaluationContext(part);
        return frame;
    }

    protected void run() {
        IScriptStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            this.reportError(Messages.ScriptEvaluationAction_cannotGetStackFrame);
            return;
        }
        IRunnableWithProgress runnable = monitor -> {
            Object selection;
            if (stackFrame.isSuspended()) {
                selection = this.getSelectedObject();
                if (!(selection instanceof String)) {
                    return;
                }
            } else {
                throw new InvocationTargetException(null, Messages.ScriptEvaluationAction_threadIsNotSuspended);
            }
            String expression = (String)selection;
            IScriptEvaluationEngine engine = stackFrame.getScriptThread().getEvaluationEngine();
            this.setEvaluating(true);
            engine.asyncEvaluate(expression, stackFrame, (IScriptEvaluationListener)this);
        };
        try {
            IWorkbench workbench = DLTKDebugUIPlugin.getDefault().getWorkbench();
            workbench.getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            this.evaluationCleanup();
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
                if (e.getCause() != null) {
                    message = e.getCause().getClass().getName();
                    if (e.getCause().getMessage() != null) {
                        message = e.getCause().getMessage();
                    }
                }
            }
            this.reportError(message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof CoreException) {
                return ScriptEvaluationAction.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = NLS.bind((String)Messages.ScriptEvaluationAction_anExceptionOccurred, exception.getClass());
        if (exception.getMessage() != null) {
            message = NLS.bind((String)Messages.ScriptEvaluationAction_anExceptionOccurred2, (Object)message, (Object)exception.getMessage());
        }
        return message;
    }

    protected static String getErrorMessage(IScriptEvaluationResult result) {
        String[] errors = result.getErrorMessages();
        if (errors.length == 0) {
            return ScriptEvaluationAction.getExceptionMessage(result.getException());
        }
        return ScriptEvaluationAction.getErrorMessage(errors);
    }

    protected static String getErrorMessage(String[] errors) {
        String message = "";
        int i = 0;
        while (i < errors.length) {
            String msg = errors[i];
            message = i == 0 ? msg : NLS.bind((String)Messages.ScriptEvaluationAction_errorMessage, (Object)message, (Object)msg);
            ++i;
        }
        return message;
    }

    protected void reportErrors(IScriptEvaluationResult result) {
        String message = ScriptEvaluationAction.getErrorMessage(result);
        this.reportError(message);
    }

    protected void reportError(String message) {
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 4, message, null);
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ScriptEvaluationAction_errorEvaluating, null, (IStatus)status);
    }

    public void evaluationComplete(IScriptEvaluationResult result) {
        if (DLTKDebugUIPlugin.getDefault() == null) {
            return;
        }
        IScriptValue value = result.getValue();
        if (result.hasErrors() || value != null) {
            Display display = DLTKDebugUIPlugin.getStandardDisplay();
            if (display.isDisposed()) {
                return;
            }
            this.displayResult(result);
        }
    }

    protected void displayResult(IScriptEvaluationResult result) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setEditor((ScriptEditor)targetEditor);
    }

    public void init(IViewPart view) {
        this.setPart((IWorkbenchPart)view);
    }

    private static class ObjectResolver {
        private IWorkbenchPart part;
        private IRegion region;

        protected static ISelection getSelection(IWorkbenchPart part) {
            ISelectionProvider provider;
            if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
                return provider.getSelection();
            }
            return null;
        }

        protected static boolean textHasContent(String text) {
            int length;
            if (text != null && (length = text.length()) > 0) {
                int i = 0;
                while (i < length) {
                    if (Character.isLetterOrDigit(text.charAt(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected Object resolveTextSelection(ITextSelection selection) {
            IEditorPart editor;
            String text = selection.getText();
            if (ObjectResolver.textHasContent(text)) {
                this.region = new Region(selection.getOffset(), selection.getLength());
                return text;
            }
            if (this.part instanceof IEditorPart && (editor = (IEditorPart)this.part) instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                this.region = ScriptWordFinder.findWord((IDocument)doc, (int)selection.getOffset());
                if (this.region != null) {
                    try {
                        return doc.get(this.region.getOffset(), this.region.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        protected Object resolveStructuredSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                if (this.part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                    IEditorPart editor = this.part.getSite().getPage().getActiveEditor();
                    ISelection newSelection = ObjectResolver.getSelection((IWorkbenchPart)editor);
                    if (newSelection instanceof ITextSelection) {
                        return this.resolveTextSelection((ITextSelection)newSelection);
                    }
                } else {
                    for (Object element : selection) {
                        if (element instanceof IScriptVariable) continue;
                        return null;
                    }
                    return selection;
                }
            }
            return null;
        }

        public ObjectResolver(IWorkbenchPart part) {
            this.part = part;
        }

        public Object resolveSelectedObject() {
            ISelection selection = ObjectResolver.getSelection(this.part);
            if (selection instanceof ITextSelection) {
                return this.resolveTextSelection((ITextSelection)selection);
            }
            if (selection instanceof IStructuredSelection) {
                return this.resolveStructuredSelection((IStructuredSelection)selection);
            }
            return null;
        }
    }
}

