/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.editor.highlighting;

import org.eclipse.dltk.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;

public class HighlightedPosition
extends Position {
    public static final HighlightedPosition[] NO_POSITIONS = new HighlightedPosition[0];
    private HighlightingStyle fStyle;
    private Object fLock;

    public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock) {
        super(offset, length);
        this.fStyle = highlighting;
        this.fLock = lock;
    }

    public StyleRange createStyleRange() {
        int len = 0;
        if (this.fStyle.isEnabled()) {
            len = this.getLength();
        }
        TextAttribute textAttribute = this.fStyle.getTextAttribute();
        int style = textAttribute.getStyle();
        int fontStyle = style & 3;
        StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
        styleRange.strikeout = (style & 0x20000000) != 0;
        styleRange.underline = (style & 0x40000000) != 0;
        return styleRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(int off, int len, HighlightingStyle highlighting) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContained(int off, int len) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int off, int len) {
        Object object = this.fLock;
        synchronized (object) {
            super.setOffset(off);
            super.setLength(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(int length) {
        Object object = this.fLock;
        synchronized (object) {
            super.setLength(length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(int offset) {
        Object object = this.fLock;
        synchronized (object) {
            super.setOffset(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.fLock;
        synchronized (object) {
            super.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undelete() {
        Object object = this.fLock;
        synchronized (object) {
            super.undelete();
        }
    }

    public HighlightingStyle getHighlighting() {
        return this.fStyle;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HLPos[");
        sb.append(this.offset);
        sb.append("+");
        sb.append(this.length);
        sb.append(":");
        sb.append(this.fStyle.getSemaHighlighting().getPreferenceKey());
        sb.append("]");
        return sb.toString();
    }
}

