/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.notifications.AbstractNotificationPopup;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FetchResultNotification
extends AbstractNotificationPopup {
    private static final long DELAY_CLOSE_MS = 5000L;
    private final Repository repository;
    private final FetchResult result;
    private final String source;

    public FetchResultNotification(Shell parent, Repository repository, FetchResult result, String source) {
        super(parent.getDisplay());
        this.repository = repository;
        this.result = result;
        this.source = source;
        this.setDelayClose(5000L);
        this.setFadingEnabled(true);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            Rectangle wb = window.getShell().getBounds();
            Rectangle nb = this.getShell().getBounds();
            this.getShell().setLocation(wb.x + wb.width - nb.width, wb.y + wb.height - nb.height);
        }
    }

    protected String getPopupShellTitle() {
        return NLS.bind((String)UIText.FetchResultNotification_Title, (Object)this.source);
    }

    protected void createContentArea(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(4, 0).applyTo(parent);
        Label body = new Label(parent, 64);
        int updateCount = this.result.getTrackingRefUpdates().size();
        if (updateCount == 0) {
            body.setText(UIText.FetchResultNotification_UpToDate);
        } else {
            body.setText(NLS.bind((String)UIText.FetchResultNotification_RefsUpdated, (Object)updateCount));
        }
        GridDataFactory.fillDefaults().grab(true, false).hint(280, -1).applyTo((Control)body);
        Link details = new Link(parent, 0);
        details.setText("<a>" + UIText.FetchResultNotification_Details + "</a>");
        details.addListener(13, e -> {
            this.close();
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FetchResultDialog dialog = new FetchResultDialog(activeShell, this.repository, this.result, this.source);
            dialog.open();
        });
        GridDataFactory.fillDefaults().applyTo((Control)details);
    }
}

