/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.match;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.resource.LocationMatchingStrategy;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.match.DefaultRCPMatchEngineFactory;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EGitMatchEngineFactory
extends DefaultRCPMatchEngineFactory {
    public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
        Notifier left;
        Notifier right = scope.getRight();
        boolean activateEGitMatchEngine = this.isNotifierContainsSharedResource(right);
        if (!activateEGitMatchEngine && !(activateEGitMatchEngine = this.isNotifierContainsSharedResource(left = scope.getLeft()))) {
            Notifier origin = scope.getOrigin();
            activateEGitMatchEngine = this.isNotifierContainsSharedResource(origin);
        }
        return activateEGitMatchEngine;
    }

    public IMatchEngine getMatchEngine() {
        UseIdentifiers useUdentifier = EGitMatchEngineFactory.getUseIdentifierValue();
        LinkedHashSet strategies = Sets.newLinkedHashSet();
        strategies.add(new LocationMatchingStrategy());
        return DefaultMatchEngine.create((UseIdentifiers)useUdentifier, (WeightProvider.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getWeightProviderRegistry(), (EqualityHelperExtensionProvider.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getEqualityHelperExtensionProviderRegistry(), (Collection)strategies);
    }

    private boolean isNotifierContainsSharedResource(Notifier notifier) {
        if (notifier instanceof ResourceSet) {
            for (Resource resource : ((ResourceSet)notifier).getResources()) {
                if (!this.isResourceSharedWithGit(resource)) continue;
                return true;
            }
        } else if (notifier instanceof Resource && this.isResourceSharedWithGit((Resource)notifier)) {
            return true;
        }
        return false;
    }

    private boolean isResourceSharedWithGit(Resource resource) {
        Adapter leftAdapter = EcoreUtil.getAdapter((List)resource.eAdapters(), StoragePathAdapter.class);
        return leftAdapter instanceof StoragePathAdapter && !((StoragePathAdapter)leftAdapter).isLocal() && !this.isFileURI(((StoragePathAdapter)leftAdapter).getStoragePath());
    }

    private boolean isFileURI(String path) {
        boolean isFileURI = path == null ? false : path.startsWith("file:");
        return isFileURI;
    }
}

