/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OrthogonalConnectionAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;

public class OrthogonalRouterUtilities {
    public static Point getAdjustedCenterPoint(Rectangle rect, Point ref) {
        Point ptNewCenter = new Point(rect.getCenter());
        if (ref.x < rect.getRight().x && ref.x > rect.getLeft().x) {
            ptNewCenter.x = ref.x;
        } else if (ref.y < rect.getBottom().y && ref.y > rect.getTop().y) {
            ptNewCenter.y = ref.y;
        }
        return ptNewCenter;
    }

    public static void resetEndPointsToCenter(Connection conn, PointList newLine) {
        Rectangle startRect = OrthogonalRouterUtilities.getBounds(conn.getSourceAnchor().getOwner());
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        Point ptStart = newLine.getPoint(1);
        conn.translateToAbsolute((Translatable)ptStart);
        ptStart = OrthogonalRouterUtilities.getAdjustedCenterPoint(startRect, ptStart);
        conn.translateToRelative((Translatable)ptStart);
        newLine.setPoint(ptStart, 0);
        Rectangle endRect = OrthogonalRouterUtilities.getBounds(conn.getTargetAnchor().getOwner());
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        Point ptEnd = newLine.getPoint(newLine.size() - 2);
        conn.translateToAbsolute((Translatable)ptEnd);
        ptEnd = OrthogonalRouterUtilities.getAdjustedCenterPoint(endRect, ptEnd);
        conn.translateToRelative((Translatable)ptEnd);
        newLine.setPoint(ptEnd, newLine.size() - 1);
    }

    private static Point getEdgePoint(Connection conn, ConnectionAnchor anchor, Point ptRef) {
        Rectangle rect = OrthogonalRouterUtilities.getBounds(anchor.getOwner());
        anchor.getOwner().translateToAbsolute((Translatable)rect);
        conn.translateToRelative((Translatable)rect);
        Point ptRef2 = new Point(ptRef);
        Point ptRef1 = OrthogonalRouterUtilities.getAdjustedCenterPoint(rect, ptRef2);
        Point ptAbsRef2 = new Point(ptRef2);
        conn.translateToAbsolute((Translatable)ptAbsRef2);
        Point ptEdge = anchor.getLocation(ptAbsRef2);
        conn.translateToRelative((Translatable)ptEdge);
        LineSeg lineSeg = new LineSeg(ptRef1, ptRef2);
        Point ptProj = lineSeg.perpIntersect(ptEdge.x, ptEdge.y);
        if (Math.abs(ptProj.x - ptRef2.x) < Math.abs(ptProj.y - ptRef2.y)) {
            ptProj.x = ptRef2.x;
        } else {
            ptProj.y = ptRef2.y;
        }
        return ptProj;
    }

    public static LineSeg getOrthogonalLineSegToAnchorLoc(Connection conn, ConnectionAnchor anchor, Point ref) {
        assert (anchor != null && anchor.getOwner() != null);
        if (anchor instanceof OrthogonalConnectionAnchor) {
            PrecisionPoint refAbs = new PrecisionPoint(ref);
            conn.translateToAbsolute((Translatable)refAbs);
            PrecisionPoint anchorPoint = new PrecisionPoint(((OrthogonalConnectionAnchor)anchor).getOrthogonalLocation((Point)refAbs));
            conn.translateToRelative((Translatable)anchorPoint);
            return new LineSeg((Point)anchorPoint, ref);
        }
        Point ptAbsRef = OrthogonalRouterUtilities.getEdgePoint(conn, anchor, ref);
        conn.translateToAbsolute((Translatable)ptAbsRef);
        Point ptEdge = anchor.getLocation(ptAbsRef);
        conn.translateToRelative((Translatable)ptEdge);
        LineSeg result = new LineSeg(ptEdge, ref);
        if (!result.isHorizontal() && !result.isVertical()) {
            if (Math.abs(result.getOrigin().x - result.getTerminus().x) < Math.abs(result.getOrigin().y - result.getTerminus().y)) {
                result.setTerminus(new Point(result.getOrigin().x, result.getTerminus().y));
            } else {
                result.setTerminus(new Point(result.getTerminus().x, result.getOrigin().y));
            }
        }
        return result;
    }

    private static Rectangle getBounds(IFigure figure) {
        return figure instanceof Connection ? ((Connection)figure).getPoints().getBounds().getCopy() : figure.getBounds().getCopy();
    }

    public static boolean isRectilinear(PointList points) {
        int i = 1;
        while (i < points.size()) {
            Point currentPt = points.getPoint(i);
            Point previousPt = points.getPoint(i - 1);
            if (currentPt.x != previousPt.x && currentPt.y != previousPt.y) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void transformToOrthogonalPointList(PointList points, int offStartDirection, int offEndDirection) {
        if (points.size() > 1) {
            Point firstEndPt;
            boolean isOffTargetDirectionSet;
            PointList startPoints = new PointList(points.size());
            PointList endPoints = new PointList(points.size());
            boolean isOffSourceDirectionSet = offStartDirection == 64 || offStartDirection == 128;
            boolean bl = isOffTargetDirectionSet = offEndDirection == 128 || offEndDirection == 64;
            if (!isOffSourceDirectionSet && !isOffTargetDirectionSet) {
                Point first = points.getPoint(0);
                Point second = points.getPoint(1);
                offStartDirection = Math.abs(first.x - second.x) < Math.abs(first.y - second.y) ? 64 : 128;
                isOffSourceDirectionSet = true;
            }
            startPoints.addPoint(points.removePoint(0));
            endPoints.addPoint(points.removePoint(points.size() - 1));
            while (points.size() != 0) {
                Point nextPt;
                if (isOffSourceDirectionSet) {
                    nextPt = points.removePoint(0);
                    Point lastStartPt = startPoints.getLastPoint();
                    if (nextPt.x != lastStartPt.x && nextPt.y != lastStartPt.y) {
                        if (offStartDirection == 128) {
                            startPoints.addPoint(new Point(lastStartPt.x, nextPt.y));
                            offStartDirection = 64;
                        } else {
                            startPoints.addPoint(new Point(nextPt.x, lastStartPt.y));
                            offStartDirection = 128;
                        }
                    } else {
                        offStartDirection = nextPt.x == lastStartPt.x ? 128 : 64;
                    }
                    startPoints.addPoint(nextPt);
                }
                if (!isOffTargetDirectionSet || points.size() == 0) continue;
                nextPt = points.removePoint(points.size() - 1);
                firstEndPt = endPoints.getFirstPoint();
                if (nextPt.x != firstEndPt.x && nextPt.y != firstEndPt.y) {
                    if (offEndDirection == 128) {
                        endPoints.insertPoint(new Point(firstEndPt.x, nextPt.y), 0);
                        offEndDirection = 64;
                    } else {
                        endPoints.insertPoint(new Point(nextPt.x, firstEndPt.y), 0);
                        offEndDirection = 128;
                    }
                } else {
                    offEndDirection = nextPt.x == firstEndPt.x ? 128 : 64;
                }
                endPoints.insertPoint(nextPt, 0);
            }
            Point lastStartPt = startPoints.getLastPoint();
            firstEndPt = endPoints.getFirstPoint();
            if (lastStartPt.x != firstEndPt.x && lastStartPt.y != firstEndPt.y) {
                if (!isOffSourceDirectionSet && isOffTargetDirectionSet || isOffTargetDirectionSet && endPoints.size() < startPoints.size()) {
                    if (offEndDirection == 128) {
                        startPoints.addPoint(new Point(firstEndPt.x, lastStartPt.y));
                    } else {
                        startPoints.addPoint(new Point(lastStartPt.x, firstEndPt.y));
                    }
                } else if (offStartDirection == 128) {
                    startPoints.addPoint(new Point(lastStartPt.x, firstEndPt.y));
                } else {
                    startPoints.addPoint(new Point(firstEndPt.x, lastStartPt.y));
                }
            }
            points.addAll(startPoints);
            points.addAll(endPoints);
        }
    }
}

