/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ui.project.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.AvailableJ2EEComponentsForEARContentProvider;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.DefaultJ2EEComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.DefaultJ2EEComponentCreationWizard;
import org.eclipse.jst.j2ee.internal.wizard.J2EEComponentLabelProvider;
import org.eclipse.jst.j2ee.internal.wizard.J2EEModuleFacetInstallPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EarFacetInstallPage
extends J2EEModuleFacetInstallPage
implements IEarFacetInstallDataModelProperties {
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button newModuleButton;
    private Label moduleProjectsLabel;
    private CheckboxTableViewer moduleProjectsViewer;
    private boolean ignoreCheckedState = false;
    private Label contentDirLabel;
    private Text contentDir;

    public EarFacetInstallPage() {
        super("ear.facet.install.page");
        this.setTitle(J2EEUIMessages.getResourceString("EARComponentCreationWizard.secondPage.title"));
        this.setDescription(J2EEUIMessages.getResourceString("EARComponentCreationWizard.secondPage.desc"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("ear_wiz"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEarFacetInstallDataModelProperties.CONTENT_DIR", "IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.setInfopopID("org.eclipse.jst.j2ee.ui.NEW_EAR_ADD_MODULES_PAGE");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)EarFacetInstallPage.gdhfill());
        this.createModuleProjectOptions(composite);
        this.createContentDirGroup(composite);
        this.createGenerateDescriptorControl(composite, "application.xml");
        this.registerFacetVersionChangeListener();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected int getJ2EEVersion() {
        IProjectFacetVersion version = (IProjectFacetVersion)this.getDataModel().getProperty("IFacetDataModelPropeties.FACET_VERSION");
        return J2EEVersionUtil.convertVersionStringToInt((String)version.getVersionString());
    }

    private void createModuleProjectOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.moduleProjectsLabel = new Label(composite, 0);
        this.moduleProjectsLabel.setText(J2EEUIMessages.getResourceString("J2EEModuleDependencies.label"));
        GridData gd = EarFacetInstallPage.gdhfill();
        gd.horizontalSpan = 2;
        this.moduleProjectsLabel.setLayoutData((Object)gd);
        this.moduleProjectsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.moduleProjectsViewer.getControl().setLayoutData((Object)gData);
        int j2eeVersion = this.getJ2EEVersion();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        AvailableJ2EEComponentsForEARContentProvider provider = new AvailableJ2EEComponentsForEARContentProvider(null, j2eeVersion, decorator);
        this.moduleProjectsViewer.setContentProvider((IContentProvider)provider);
        J2EEComponentLabelProvider labelProvider = new J2EEComponentLabelProvider(provider);
        decorator.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                if (!EarFacetInstallPage.this.moduleProjectsViewer.getTable().isDisposed()) {
                    EarFacetInstallPage.this.moduleProjectsViewer.refresh(true);
                }
            }
        });
        this.moduleProjectsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.setCheckedItemsFromModel();
        this.moduleProjectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!EarFacetInstallPage.this.ignoreCheckedState) {
                    EarFacetInstallPage.this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", (Object)EarFacetInstallPage.this.getCheckedJ2EEElementsAsList());
                    EarFacetInstallPage.this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", (Object)EarFacetInstallPage.this.getCheckedJavaProjectsAsList());
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.moduleProjectsViewer.getTable().setLayout((Layout)tableLayout);
        this.moduleProjectsViewer.getTable().setHeaderVisible(false);
        this.moduleProjectsViewer.getTable().setLinesVisible(false);
        this.moduleProjectsViewer.setSorter(null);
        this.moduleProjectsViewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = J2EEUIMessages.getResourceString("J2EEModuleDependencies.label_accessibility");
            }
        });
        this.createButtonsGroup(composite);
    }

    private void setCheckedItemsFromModel() {
        List components = (List)this.getDataModel().getProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST");
        TableItem[] items = this.moduleProjectsViewer.getTable().getItems();
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            if (element instanceof IVirtualComponent) {
                IVirtualComponent comp = (IVirtualComponent)element;
                for (IProject project : components) {
                    if (!comp.getProject().getName().equals(project.getName())) continue;
                    list.add(comp);
                }
            }
            ++i;
        }
        this.moduleProjectsViewer.setCheckedElements(list.toArray());
    }

    private void refreshModules() {
        this.moduleProjectsViewer.refresh();
        this.setCheckedItemsFromModel();
    }

    protected List getCheckedJ2EEElementsAsList() {
        ArrayList<IProject> list;
        Object[] elements = this.moduleProjectsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<IProject>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVirtualComponent) {
                    list.add(((IVirtualComponent)elements[i]).getProject());
                }
                ++i;
            }
        }
        return list;
    }

    protected List getCheckedJavaProjectsAsList() {
        ArrayList<Object> list;
        Object[] elements = this.moduleProjectsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = Collections.EMPTY_LIST;
        } else {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IProject) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        buttonGroup.setLayoutData((Object)new GridData(2));
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(J2EEUIMessages.getResourceString("10"));
        this.selectAllButton.addListener(13, (Listener)this);
        GridDataFactory.defaultsFor((Control)this.selectAllButton).applyTo((Control)this.selectAllButton);
        this.deselectAllButton = new Button(buttonGroup, 8);
        this.deselectAllButton.setText(J2EEUIMessages.getResourceString("11"));
        this.deselectAllButton.addListener(13, (Listener)this);
        GridDataFactory.defaultsFor((Control)this.deselectAllButton).applyTo((Control)this.deselectAllButton);
        new Label(buttonGroup, 0);
        this.newModuleButton = new Button(buttonGroup, 8);
        this.newModuleButton.setText(J2EEUIMessages.getResourceString("12"));
        this.newModuleButton.addListener(13, (Listener)this);
        GridDataFactory.defaultsFor((Control)this.newModuleButton).applyTo((Control)this.newModuleButton);
    }

    private void createContentDirGroup(Composite modulesGroup) {
        Composite composite = new Composite(modulesGroup, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)EarFacetInstallPage.gdhfill());
        this.contentDirLabel = new Label(composite, 0);
        this.contentDirLabel.setText(Resources.contentDirLabel);
        this.contentDirLabel.setLayoutData((Object)new GridData());
        this.contentDir = new Text(composite, 2048);
        this.contentDir.setLayoutData((Object)EarFacetInstallPage.gdhfill());
        this.synchHelper.synchText(this.contentDir, "IEarFacetInstallDataModelProperties.CONTENT_DIR", null);
    }

    public void handleEvent(Event evt) {
        if (evt.widget == this.selectAllButton) {
            this.handleSelectAllButtonPressed();
        } else if (evt.widget == this.deselectAllButton) {
            this.handleDeselectAllButtonPressed();
        } else if (evt.widget == this.newModuleButton) {
            this.handleNewModuleButtonPressed();
        } else {
            super.handleEvent(evt);
        }
    }

    @Override
    protected void handleFacetVersionChangedEvent() {
        String fv = this.model.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
        boolean isEAR50OrGreater = J2EEVersionUtil.convertVersionStringToInt((String)fv) >= 50;
        this.addDD.setVisible(isEAR50OrGreater);
    }

    private void handleNewModuleButtonPressed() {
        IDataModel aModel = this.createNewModuleModel();
        DefaultJ2EEComponentCreationWizard wizard = new DefaultJ2EEComponentCreationWizard(aModel);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() != 1) {
            IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
            this.moduleProjectsViewer.setInput((Object)input);
            this.setNewModules(aModel);
            this.refreshModules();
        }
    }

    private void setNewModules(IDataModel defaultModel) {
        ArrayList newComponents = new ArrayList();
        this.collectNewComponents(defaultModel, newComponents);
        List oldComponents = (List)this.getDataModel().getProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST");
        newComponents.addAll(oldComponents);
        this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", newComponents);
    }

    private void collectNewComponents(IDataModel defaultModel, List newProjects) {
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT"), newProjects);
        this.collectComponents(defaultModel.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA"), newProjects);
    }

    private void collectComponents(IDataModel compDM, List newProjects) {
        if (compDM != null) {
            String projectName = compDM.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            if (projectName == null) {
                return;
            }
            IProject project = ProjectUtilities.getProject((String)projectName);
            if (project != null && project.exists()) {
                newProjects.add(project);
            }
        }
    }

    private IDataModel createNewModuleModel() {
        IDataModel defaultModel = DataModelFactory.createDataModel((IDataModelProvider)new DefaultJ2EEComponentCreationDataModelProvider());
        String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.PROJECT_NAME", (Object)projectName);
        String earName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.EAR_NAME", (Object)earName);
        int j2eeVersion = this.getJ2EEVersion();
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION", (Object)new Integer(j2eeVersion));
        FacetedProjectWorkingCopy fpwc = (FacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IRuntime rt = fpwc.getPrimaryRuntime();
        defaultModel.setProperty("DefaultJ2EEComponentCreationDataModel.FACET_RUNTIME", (Object)rt);
        return defaultModel;
    }

    private void handleDeselectAllButtonPressed() {
        this.ignoreCheckedState = true;
        try {
            this.moduleProjectsViewer.setAllChecked(false);
            this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", null);
            this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", null);
        }
        finally {
            this.ignoreCheckedState = false;
        }
    }

    private void handleSelectAllButtonPressed() {
        this.ignoreCheckedState = true;
        try {
            this.moduleProjectsViewer.setAllChecked(true);
            this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", (Object)this.getCheckedJ2EEElementsAsList());
            this.getDataModel().setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", (Object)this.getCheckedJavaProjectsAsList());
        }
        finally {
            this.ignoreCheckedState = false;
        }
    }

    @Override
    protected void enter() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.moduleProjectsViewer.setInput((Object)input);
        super.enter();
    }

    private static final class Resources
    extends NLS {
        public static String contentDirLabel;

        static {
            Resources.initializeMessages((String)EarFacetInstallPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

