/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryPackage;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.adapter.MaintainDefaultImplementationAdapter;

public class JSFLibraryImpl
extends EObjectImpl
implements JSFLibrary {
    public static final String copyright = "Copyright (c) 2005 Oracle Corporation";
    protected static final String ID_EDEFAULT = "";
    protected String id = "";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final JSFVersion JSF_VERSION_EDEFAULT = JSFVersion.UNKNOWN_LITERAL;
    protected JSFVersion jsfVersion = JSF_VERSION_EDEFAULT;
    protected static final boolean DEPLOYED_EDEFAULT = true;
    protected boolean deployed = true;
    protected static final boolean IMPLEMENTATION_EDEFAULT = false;
    protected boolean implementation = false;
    protected EList archiveFiles;

    protected JSFLibraryImpl() {
        this.eAdapters().add((Object)MaintainDefaultImplementationAdapter.getInstance());
    }

    protected EClass eStaticClass() {
        return JSFLibraryRegistryPackage.Literals.JSF_LIBRARY;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public JSFVersion getJSFVersion() {
        return this.jsfVersion;
    }

    @Override
    public void setJSFVersion(JSFVersion newJSFVersion) {
        JSFVersion oldJSFVersion = this.jsfVersion;
        JSFVersion jSFVersion = this.jsfVersion = newJSFVersion == null ? JSF_VERSION_EDEFAULT : newJSFVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldJSFVersion, (Object)this.jsfVersion));
        }
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public void setDeployed(boolean newDeployed) {
        boolean oldDeployed = this.deployed;
        this.deployed = newDeployed;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldDeployed, this.deployed));
        }
    }

    @Override
    public boolean isImplementation() {
        return this.implementation;
    }

    @Override
    public void setImplementation(boolean newImplementation) {
        boolean oldImplementation = this.implementation;
        this.implementation = newImplementation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldImplementation, this.implementation));
        }
    }

    @Override
    public EList getArchiveFiles() {
        if (this.archiveFiles == null) {
            this.archiveFiles = new EObjectContainmentWithInverseEList(ArchiveFile.class, (InternalEObject)this, 5, 3);
        }
        return this.archiveFiles;
    }

    @Override
    public boolean containsArchiveFile(String fullPath) {
        boolean contains = false;
        if (fullPath != null) {
            for (ArchiveFile archiveFile : this.getArchiveFiles()) {
                if (!fullPath.equals(archiveFile.getResolvedSourceLocation())) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    @Override
    public JSFLibrary getWorkingCopy() {
        JSFLibrary workingCopyLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        workingCopyLib.setName(this.getName());
        workingCopyLib.setJSFVersion(this.getJSFVersion());
        workingCopyLib.setDeployed(this.isDeployed());
        workingCopyLib.setImplementation(this.isImplementation());
        for (ArchiveFile srcArchiveFile : this.getArchiveFiles()) {
            ArchiveFile destArchiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            destArchiveFile.setRelativeToWorkspace(srcArchiveFile.isRelativeToWorkspace());
            destArchiveFile.setSourceLocation(srcArchiveFile.getSourceLocation());
            destArchiveFile.setRelativeDestLocation(srcArchiveFile.getRelativeDestLocation());
            workingCopyLib.getArchiveFiles().add((Object)destArchiveFile);
        }
        return workingCopyLib;
    }

    @Override
    public void updateValues(JSFLibrary otherLibrary) {
        if (otherLibrary != null) {
            this.setName(otherLibrary.getName());
            this.setJSFVersion(otherLibrary.getJSFVersion());
            this.setDeployed(otherLibrary.isDeployed());
            this.setImplementation(otherLibrary.isImplementation());
            Iterator itArchiveFiles = otherLibrary.getArchiveFiles().iterator();
            this.getArchiveFiles().clear();
            while (itArchiveFiles.hasNext()) {
                ArchiveFile srcArchiveFile = (ArchiveFile)itArchiveFiles.next();
                ArchiveFile destArchiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
                destArchiveFile.setRelativeToWorkspace(srcArchiveFile.isRelativeToWorkspace());
                destArchiveFile.setSourceLocation(srcArchiveFile.getSourceLocation());
                destArchiveFile.setRelativeDestLocation(srcArchiveFile.getRelativeDestLocation());
                this.getArchiveFiles().add((Object)destArchiveFile);
            }
        }
    }

    @Override
    public boolean copyTo(String baseDestLocation) {
        boolean allCopied = true;
        for (ArchiveFile archiveFile : this.getArchiveFiles()) {
            boolean copied = archiveFile.copyTo(baseDestLocation);
            boolean bl = allCopied = allCopied && copied;
        }
        return allCopied;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getArchiveFiles()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getArchiveFiles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getID();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getJSFVersion();
            }
            case 3: {
                return this.isDeployed() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.isImplementation() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.getArchiveFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setJSFVersion((JSFVersion)((Object)newValue));
                return;
            }
            case 3: {
                this.setDeployed((Boolean)newValue);
                return;
            }
            case 4: {
                this.setImplementation((Boolean)newValue);
                return;
            }
            case 5: {
                this.getArchiveFiles().clear();
                this.getArchiveFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setJSFVersion(JSF_VERSION_EDEFAULT);
                return;
            }
            case 3: {
                this.setDeployed(true);
                return;
            }
            case 4: {
                this.setImplementation(false);
                return;
            }
            case 5: {
                this.getArchiveFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.jsfVersion != JSF_VERSION_EDEFAULT;
            }
            case 3: {
                return !this.deployed;
            }
            case 4: {
                return this.implementation;
            }
            case 5: {
                return this.archiveFiles != null && !this.archiveFiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (ID: ");
        result.append(this.id);
        result.append(", Name: ");
        result.append(this.name);
        result.append(", JSFVersion: ");
        result.append((Object)this.jsfVersion);
        result.append(", Deployed: ");
        result.append(this.deployed);
        result.append(", Implementation: ");
        result.append(this.implementation);
        result.append(')');
        return result.toString();
    }
}

