/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel;

import java.util.Enumeration;
import org.eclipse.wst.ws.internal.datamodel.BasicElement;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public abstract class TypeElement
extends BasicElement {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String NON_INSTANTIABLE = "nonInstantiable";
    public static int BEAN = 0;
    public static int SIMPLE = 1;
    public static int ARRAY = 2;
    private int fType;
    protected int fOwnerType;
    private boolean fPrimitive = false;
    public static String REL_ATTRIBUTES = "attributes";
    public static String REL_FIELDS = "fields";
    public static final String REL_TYPE = "type";
    public static final String REL_OWNER = "owner";
    public static int PARAMETER_OWNER = 0;
    public static int ATTRIBUTE_OWNER = 1;
    public static int FIELD_OWNER = 2;
    public static int ROOT = 3;

    protected TypeElement(String name, Model model, int type) {
        super(name, model);
        this.fType = type;
    }

    protected TypeElement(String name, Element element, String outboundRelName, String inboundRelName, int type) {
        super(name, element, outboundRelName, inboundRelName);
        this.fType = type;
    }

    public boolean isBean() {
        return this.fType == BEAN;
    }

    public boolean isPrimitive() {
        return this.fPrimitive;
    }

    protected void setPrimitive(boolean prim) {
        this.fPrimitive = prim;
    }

    public String getTypeName() {
        return this.getName();
    }

    public boolean isSimple() {
        return this.fType == SIMPLE;
    }

    public boolean isArray() {
        return this.fType == ARRAY;
    }

    public boolean isRoot() {
        return this.fOwnerType == ROOT;
    }

    public boolean isOwnerParameter() {
        return this.fOwnerType == PARAMETER_OWNER;
    }

    public boolean isOwnerAttribute() {
        return this.fOwnerType == ATTRIBUTE_OWNER;
    }

    public boolean isOwnerField() {
        return this.fOwnerType == FIELD_OWNER;
    }

    public BasicElement getOwningElement() {
        if (this.isOwnerParameter()) {
            Enumeration e = this.getElements(REL_OWNER);
            return e.hasMoreElements() ? (BasicElement)e.nextElement() : null;
        }
        if (this.isOwnerAttribute()) {
            Enumeration e = this.getElements(REL_OWNER);
            return e.hasMoreElements() ? (BasicElement)e.nextElement() : null;
        }
        if (this.isOwnerField()) {
            Enumeration e = this.getElements(REL_OWNER);
            return e.hasMoreElements() ? (BasicElement)e.nextElement() : null;
        }
        return null;
    }
}

