/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.IClassifierProvider;

public abstract class AbstractClassifierProvider
implements IClassifierProvider {
    private final Set<EClassifier> myClassifiers = new HashSet<EClassifier>();

    protected AbstractClassifierProvider(List<EPackage> rootPackages) {
        for (EPackage pack : rootPackages) {
            this.collectClassifiers(pack, this.myClassifiers);
        }
    }

    @Override
    public EClassifier[] getClassifiers(String query) {
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        String normalizedQuery = this.normalizeQuery(query);
        if (normalizedQuery.length() > 0) {
            for (EClassifier classifier : this.myClassifiers) {
                if (!this.isMatching(classifier, normalizedQuery)) continue;
                result.add(classifier);
            }
            this.sortClassifiers(result);
        }
        return result.toArray(new EClassifier[result.size()]);
    }

    protected String normalizeQuery(String query) {
        return query;
    }

    protected abstract boolean isMatching(EClassifier var1, String var2);

    protected void sortClassifiers(List<EClassifier> result) {
        Collections.sort(result, new Comparator<EClassifier>(){

            @Override
            public int compare(EClassifier c1, EClassifier c2) {
                return String.CASE_INSENSITIVE_ORDER.compare(c1.getName(), c2.getName());
            }
        });
    }

    private void collectClassifiers(EPackage current, Set<EClassifier> classifiers) {
        classifiers.addAll((Collection<EClassifier>)current.getEClassifiers());
        for (EPackage pack : current.getESubpackages()) {
            this.collectClassifiers(pack, classifiers);
        }
    }
}

