/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ConfigPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ConstructorCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ContextualPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LocalPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingQueryCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingRuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.PackageRefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ParameterDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.RenameCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ScopedNameCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TagCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.StringLiteralExpCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.swt.graphics.Image;

public class QvtOutlineLabelProvider
implements ILabelProvider {
    public static final String TAGS_NODE = "tags";
    public static final String METAMODELS_NODE = "metamodels";
    public static final String IMPORTS_NODE = "imports";
    public static final String PROPERTIES_NODE = "properties";
    public static final String LIBRARY_NODE = "library";

    public Image getImage(Object element) {
        OutlineNode node = (OutlineNode)element;
        switch (node.getType()) {
            case 3: {
                return CompletionProposalUtil.getImage("impc_obj");
            }
            case 1: {
                return CompletionProposalUtil.getImage("impc_obj");
            }
            case 2: {
                return CompletionProposalUtil.getImage("cat-package");
            }
            case 0: 
            case 11: {
                return CompletionProposalUtil.getImage("cat-class");
            }
            case 10: {
                return CompletionProposalUtil.getImage("qvt_src_file");
            }
            case 5: {
                return CompletionProposalUtil.getImage("impc_obj");
            }
            case 4: {
                return CompletionProposalUtil.getImage("imp_obj");
            }
            case 7: {
                return CompletionProposalUtil.getImage("impc_obj");
            }
            case 6: {
                return CompletionProposalUtil.getImage("cat-property");
            }
            case 8: {
                CSTNode syntaxElement = node.getSyntaxElement();
                if (syntaxElement instanceof MappingMethodCS) {
                    if (syntaxElement instanceof MappingRuleCS) {
                        return CompletionProposalUtil.getImage("cat-mapping");
                    }
                    if (syntaxElement instanceof MappingQueryCS) {
                        return CompletionProposalUtil.getImage("cat-imperative-operation");
                    }
                    if (syntaxElement instanceof ConstructorCS) {
                        return CompletionProposalUtil.getImage("cat-operation");
                    }
                }
            }
            case 9: {
                return CompletionProposalUtil.getImage("impc_obj");
            }
        }
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String getMappingModuleLabel(MappingModuleCS m) {
        return m == null || m.getHeaderCS() == null || m.getHeaderCS().getPathNameCS() == null ? "" : QvtOutlineLabelProvider.getImportLabel(m.getHeaderCS().getPathNameCS());
    }

    public static String getMappingRuleLabel(MappingMethodCS r) {
        return QvtOutlineLabelProvider.getMappingDeclarationAsString(r.getMappingDeclarationCS());
    }

    public static String getRenameLabel(RenameCS r) {
        return String.valueOf(r.getOriginalName().getStringSymbol()) + " := " + r.getSimpleNameCS().getValue();
    }

    public static String getTagLabel(TagCS tag) {
        ScopedNameCS scopedNameCS;
        StringBuilder buf = new StringBuilder();
        if (tag.getName() != null) {
            buf.append(tag.getName().getStringSymbol()).append(' ');
        }
        if ((scopedNameCS = tag.getScopedNameCS()) != null) {
            if (scopedNameCS.getTypeCS() != null) {
                String type = QvtOutlineLabelProvider.getTypeAsString(scopedNameCS.getTypeCS());
                buf.append(type).append("::");
            }
            if (scopedNameCS.getName() != null) {
                buf.append(scopedNameCS.getName());
            }
        }
        buf.append(" = ");
        if (tag.getOclExpressionCS() instanceof StringLiteralExpCS) {
            StringLiteralExpCS stringLiteralExpCS = (StringLiteralExpCS)tag.getOclExpressionCS();
            buf.append(stringLiteralExpCS.getStringSymbol());
        }
        return buf.toString();
    }

    public static String getClassifierLabel(ClassifierDefCS classifierDefCS) {
        SimpleNameCS simpleNameCS = classifierDefCS.getSimpleNameCS();
        if (simpleNameCS != null && simpleNameCS.getValue() != null) {
            return simpleNameCS.getValue();
        }
        return "...";
    }

    public static String getPropertyLabel(ModulePropertyCS prop) {
        ContextualPropertyCS ctxPropCS;
        StringBuilder buf = new StringBuilder();
        if (prop instanceof ContextualPropertyCS && (ctxPropCS = (ContextualPropertyCS)prop).getTypeCS() != null) {
            buf.append(QvtOutlineLabelProvider.getTypeAsString(ctxPropCS.getTypeCS())).append("::");
        }
        buf.append(prop.getSimpleNameCS().getValue());
        TypeCS typeCS = null;
        if (prop instanceof LocalPropertyCS) {
            typeCS = ((LocalPropertyCS)prop).getTypeCS();
        } else if (prop instanceof ConfigPropertyCS) {
            typeCS = ((ConfigPropertyCS)prop).getTypeCS();
        } else if (prop instanceof ContextualPropertyCS) {
            typeCS = ((ContextualPropertyCS)prop).getTypeCS();
        }
        if (typeCS != null) {
            buf.append(" : ").append(QvtOutlineLabelProvider.getTypeAsString(typeCS));
        }
        return buf.toString();
    }

    public static String getImportLabel(PathNameCS path) {
        StringBuffer buffer = null;
        for (SimpleNameCS part : path.getSimpleNames()) {
            if (buffer != null) {
                buffer.append(".");
            } else {
                buffer = new StringBuffer();
            }
            buffer.append(part.getValue());
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String getMetamodelLabel(ModelTypeCS modelTypeCS) {
        StringLiteralExpCS uriCS = ((PackageRefCS)modelTypeCS.getPackageRefs().get(0)).getUriCS();
        if (uriCS == null) {
            return "";
        }
        return uriCS.getStringSymbol();
    }

    private static String getMappingDeclarationAsString(MappingDeclarationCS decl) {
        if (decl == null) {
            return "";
        }
        ArrayList<String> listParam = new ArrayList<String>();
        for (ParameterDeclarationCS param : decl.getParameters()) {
            listParam.add(QvtOutlineLabelProvider.getParameterDeclarationAsString(param));
        }
        String context = "";
        if (decl.getContextType() == null) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)decl);
            if (rootContainer instanceof MappingModuleCS) {
                context = QvtOutlineLabelProvider.getMappingModuleLabel((MappingModuleCS)rootContainer);
            }
        } else {
            context = QvtOutlineLabelProvider.getTypeAsString(decl.getContextType());
        }
        if (context.length() > 0) {
            context = String.valueOf(context) + "::";
        }
        return QvtOutlineLabelProvider.getMappingDeclarationAsString(decl.getSimpleNameCS().getValue(), context, listParam);
    }

    public static String getMappingDeclarationAsString(String name, String contextType, List<String> params) {
        StringBuffer result = new StringBuffer(contextType);
        result.append(name);
        result.append("(");
        Iterator<String> it = params.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    private static String getParameterDeclarationAsString(ParameterDeclarationCS decl) {
        StringBuffer result = new StringBuffer();
        if (decl.getDirectionKind().getValue() == 0) {
            result.append("in ");
        } else if (decl.getDirectionKind().getValue() == 0) {
            result.append("out ");
        } else if (decl.getDirectionKind().getValue() == 0) {
            result.append("inout ");
        }
        if (decl.getSimpleNameCS() != null) {
            result.append(decl.getSimpleNameCS().getValue());
        }
        String typeName = QvtOutlineLabelProvider.getTypeAsString(decl.getTypeSpecCS().getTypeCS());
        result.append(":").append(typeName);
        return result.toString();
    }

    private static String getTypeAsString(TypeCS type) {
        String typeName = type instanceof EClassifier ? QvtOperationalTypesUtil.getTypeFullName((EClassifier)((EClassifier)type)) : (type != null ? QvtOperationalUtil.getStringRepresentation((TypeCS)type) : "OclVoid");
        return typeName;
    }
}

